/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.mounted;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class MountedContraption
extends Contraption {
    public CartAssemblerBlockEntity.CartMovementMode rotationMode;
    public AbstractMinecart connectedCart;

    public MountedContraption() {
        this(CartAssemblerBlockEntity.CartMovementMode.ROTATE);
    }

    public MountedContraption(CartAssemblerBlockEntity.CartMovementMode mode) {
        this.rotationMode = mode;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.MOUNTED;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        BlockState state = world.getBlockState(pos);
        if (!state.hasProperty(CartAssemblerBlock.RAIL_SHAPE)) {
            return false;
        }
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        Direction.Axis axis = state.getValue(CartAssemblerBlock.RAIL_SHAPE) == RailShape.EAST_WEST ? Direction.Axis.X : Direction.Axis.Z;
        this.addBlock(world, pos, (Pair<StructureTemplate.StructureBlockInfo, BlockEntity>)Pair.of((Object)new StructureTemplate.StructureBlockInfo(pos, (BlockState)AllBlocks.MINECART_ANCHOR.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis), null), null));
        return this.blocks.size() != 1;
    }

    @Override
    protected boolean addToInitialFrontier(Level world, BlockPos pos, Direction direction, Queue<BlockPos> frontier) {
        frontier.clear();
        frontier.add(pos.above());
        return true;
    }

    @Override
    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair = super.capture(world, pos);
        StructureTemplate.StructureBlockInfo capture = (StructureTemplate.StructureBlockInfo)pair.getKey();
        if (!capture.state().is((Block)AllBlocks.CART_ASSEMBLER)) {
            return pair;
        }
        Pair anchorSwap = Pair.of((Object)new StructureTemplate.StructureBlockInfo(pos, CartAssemblerBlock.createAnchor(capture.state()), null), (Object)((BlockEntity)pair.getValue()));
        if (pos.equals((Object)this.anchor) || this.connectedCart != null) {
            return anchorSwap;
        }
        for (Direction.Axis axis : Iterate.axes) {
            AbstractMinecart abstractMinecartEntity;
            if (axis.isVertical() || !VecHelper.onSameAxis(this.anchor, pos, axis)) continue;
            Iterator iterator = world.getEntitiesOfClass(AbstractMinecart.class, new AABB(pos)).iterator();
            while (iterator.hasNext() && CartAssemblerBlock.canAssembleTo(abstractMinecartEntity = (AbstractMinecart)iterator.next())) {
                this.connectedCart = abstractMinecartEntity;
                this.connectedCart.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
            }
        }
        return anchorSwap;
    }

    @Override
    protected boolean movementAllowed(BlockState state, Level world, BlockPos pos) {
        if (!pos.equals((Object)this.anchor) && state.is((Block)AllBlocks.CART_ASSEMBLER)) {
            return this.testSecondaryCartAssembler(world, pos);
        }
        return super.movementAllowed(state, world, pos);
    }

    protected boolean testSecondaryCartAssembler(Level world, BlockPos pos) {
        for (Direction.Axis axis : Iterate.axes) {
            AbstractMinecart abstractMinecartEntity;
            Iterator iterator;
            if (axis.isVertical() || !VecHelper.onSameAxis(this.anchor, pos, axis) || !(iterator = world.getEntitiesOfClass(AbstractMinecart.class, new AABB(pos)).iterator()).hasNext() || !CartAssemblerBlock.canAssembleTo(abstractMinecartEntity = (AbstractMinecart)iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(ValueOutput view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.store("RotationMode", CartAssemblerBlockEntity.CartMovementMode.CODEC, (Object)this.rotationMode);
    }

    @Override
    public void read(Level world, ValueInput view, boolean spawnData) {
        view.read("RotationMode", CartAssemblerBlockEntity.CartMovementMode.CODEC).ifPresent(mode -> {
            this.rotationMode = mode;
        });
        super.read(world, view, spawnData);
    }

    @Override
    protected boolean customBlockPlacement(LevelAccessor world, BlockPos pos, BlockState state) {
        return state.is((Block)AllBlocks.MINECART_ANCHOR);
    }

    @Override
    protected boolean customBlockRemoval(LevelAccessor world, BlockPos pos, BlockState state) {
        return state.is((Block)AllBlocks.MINECART_ANCHOR);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return true;
    }

    public void addExtraInventories(Entity cart) {
        if (cart instanceof Container) {
            Container inventory = (Container)cart;
            this.storage.attachExternal(inventory);
        }
    }
}

