/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlockEntity;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonExtensionPoleBlock
extends WrenchableDirectionalBlock
implements IWrenchable,
SimpleWaterloggedBlock {
    private static final int placementHelperId = PlacementHelpers.register(PlacementHelper.get());

    public PistonExtensionPoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        Direction.Axis axis = ((Direction)state.getValue((Property)FACING)).getAxis();
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        BlockPos pistonHead = null;
        BlockPos pistonBase = null;
        int[] nArray = new int[]{1, -1};
        int n = nArray.length;
        block0: for (int i = 0; i < n; ++i) {
            int modifier;
            int offset = modifier = nArray[i];
            while (modifier * offset < MechanicalPistonBlock.maxAllowedPistonPoles()) {
                BlockPos currentPos = pos.relative(direction, offset);
                BlockState block = worldIn.getBlockState(currentPos);
                if (!MechanicalPistonBlock.isExtensionPole(block) || axis != ((Direction)block.getValue((Property)FACING)).getAxis()) {
                    if (MechanicalPistonBlock.isPiston(block) && ((Direction)block.getValue((Property)BlockStateProperties.FACING)).getAxis() == axis) {
                        pistonBase = currentPos;
                    }
                    if (!MechanicalPistonBlock.isPistonHead(block) || ((Direction)block.getValue((Property)BlockStateProperties.FACING)).getAxis() != axis) continue block0;
                    pistonHead = currentPos;
                    continue block0;
                }
                offset += modifier;
            }
        }
        if (pistonHead != null && pistonBase != null && worldIn.getBlockState(pistonHead).getValue((Property)BlockStateProperties.FACING) == worldIn.getBlockState(pistonBase).getValue((Property)BlockStateProperties.FACING)) {
            BlockPos basePos = pistonBase;
            BlockPos.betweenClosedStream(pistonBase, pistonHead).filter(p -> !p.equals((Object)pos) && !p.equals((Object)basePos)).forEach(p -> worldIn.destroyBlock(p, !player.isCreative()));
            worldIn.setBlockAndUpdate(basePos, (BlockState)worldIn.getBlockState(basePos).setValue(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.RETRACTED)));
            BlockEntity blockEntity = worldIn.getBlockEntity(basePos);
            if (blockEntity instanceof MechanicalPistonBlockEntity) {
                MechanicalPistonBlockEntity baseBE = (MechanicalPistonBlockEntity)blockEntity;
                baseBE.onLengthBroken();
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.FOUR_VOXEL_POLE.get(((Direction)state.getValue((Property)FACING)).getAxis());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState FluidState2 = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (placementHelper.matchesItem(stack) && !player.isShiftKeyDown()) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand);
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighbourPos, BlockState neighbourState, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return state;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static class PlacementHelper
    extends PoleHelper<Direction> {
        private static final PlacementHelper instance = new PlacementHelper();

        public static PlacementHelper get() {
            return instance;
        }

        private PlacementHelper() {
            super(state -> state.is((Block)AllBlocks.PISTON_EXTENSION_POLE), state -> ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getAxis(), DirectionalBlock.FACING);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.is((Item)AllItems.PISTON_EXTENSION_POLE);
        }
    }
}

