/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.steamWhistle;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WhistleExtenderBlock
extends Block
implements IWrenchable {
    public static final EnumProperty<WhistleExtenderShape> SHAPE = EnumProperty.create((String)"shape", WhistleExtenderShape.class);
    public static final EnumProperty<WhistleBlock.WhistleSize> SIZE = WhistleBlock.SIZE;

    public WhistleExtenderBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)WhistleExtenderShape.SINGLE))).setValue(SIZE, (Comparable)((Object)WhistleBlock.WhistleSize.MEDIUM)));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (context.getClickLocation().y < (double)((float)context.getClickedPos().getY() + 0.5f) || state.getValue(SHAPE) == WhistleExtenderShape.SINGLE) {
            return IWrenchable.super.onSneakWrenched(state, context);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        world.setBlock(pos, (BlockState)state.setValue(SHAPE, (Comparable)((Object)WhistleExtenderShape.SINGLE)), 3);
        IWrenchable.playRemoveSound(world, pos);
        return InteractionResult.SUCCESS;
    }

    protected UseOnContext relocateContext(UseOnContext context, BlockPos target) {
        return new UseOnContext(context.getPlayer(), context.getHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), target, context.isInside()));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player == null || !stack.is((Item)AllItems.STEAM_WHISTLE)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockPos findRoot = WhistleExtenderBlock.findRoot((LevelAccessor)level, pos);
        BlockState blockState = level.getBlockState(findRoot);
        Block block = blockState.getBlock();
        if (block instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)block;
            return whistle.useItemOn(stack, blockState, level, findRoot, player, hand, new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), findRoot, hitResult.isInside()));
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos findRoot;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(findRoot = WhistleExtenderBlock.findRoot((LevelAccessor)level, context.getClickedPos()));
        Block block = blockState.getBlock();
        if (block instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)block;
            return whistle.onWrenched(blockState, this.relocateContext(context, findRoot));
        }
        return IWrenchable.super.onWrenched(state, context);
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return AllItems.STEAM_WHISTLE.getDefaultInstance();
    }

    public static BlockPos findRoot(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockState;
        BlockPos currentPos = pPos.below();
        while ((blockState = pLevel.getBlockState(currentPos)).is((Block)AllBlocks.STEAM_WHISTLE_EXTENSION)) {
            currentPos = currentPos.below();
        }
        return currentPos;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState below = pLevel.getBlockState(pPos.below());
        return below.is((Block)this) && below.getValue(SHAPE) != WhistleExtenderShape.SINGLE || below.is((Block)AllBlocks.STEAM_WHISTLE);
    }

    public BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pCurrentPos, Direction pFacing, BlockPos pFacingPos, BlockState pFacingState, RandomSource random) {
        if (pFacing.getAxis() != Direction.Axis.Y) {
            return pState;
        }
        if (pFacing == Direction.UP) {
            boolean connected = pState.getValue(SHAPE) == WhistleExtenderShape.DOUBLE_CONNECTED;
            boolean shouldConnect = pLevel.getBlockState(pCurrentPos.above()).is((Block)this);
            if (!connected && shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)WhistleExtenderShape.DOUBLE_CONNECTED));
            }
            if (connected && !shouldConnect) {
                return (BlockState)pState.setValue(SHAPE, (Comparable)((Object)WhistleExtenderShape.DOUBLE));
            }
            return pState;
        }
        return !pState.canSurvive(pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : (BlockState)pState.setValue(SIZE, (Comparable)((Object)((WhistleBlock.WhistleSize)((Object)pLevel.getBlockState(pCurrentPos.below()).getValue(SIZE)))));
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.getBlock() != this || pOldState.getValue(SHAPE) != pState.getValue(SHAPE)) {
            WhistleBlock.queuePitchUpdate((LevelAccessor)pLevel, WhistleExtenderBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public void affectNeighborsAfterRemoval(BlockState pState, ServerLevel pLevel, BlockPos pPos, boolean pIsMoving) {
        WhistleBlock.queuePitchUpdate((LevelAccessor)pLevel, WhistleExtenderBlock.findRoot((LevelAccessor)pLevel, pPos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{SHAPE, SIZE}));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)pState.getValue(SIZE));
        return switch (((WhistleExtenderShape)((Object)pState.getValue(SHAPE))).ordinal()) {
            case 1 -> {
                if (size == WhistleBlock.WhistleSize.LARGE) {
                    yield AllShapes.WHISTLE_EXTENDER_LARGE_DOUBLE;
                }
                if (size == WhistleBlock.WhistleSize.MEDIUM) {
                    yield AllShapes.WHISTLE_EXTENDER_MEDIUM_DOUBLE;
                }
                yield AllShapes.WHISTLE_EXTENDER_SMALL_DOUBLE;
            }
            case 2 -> {
                if (size == WhistleBlock.WhistleSize.LARGE) {
                    yield AllShapes.WHISTLE_EXTENDER_LARGE_DOUBLE_CONNECTED;
                }
                if (size == WhistleBlock.WhistleSize.MEDIUM) {
                    yield AllShapes.WHISTLE_EXTENDER_MEDIUM_DOUBLE_CONNECTED;
                }
                yield AllShapes.WHISTLE_EXTENDER_SMALL_DOUBLE_CONNECTED;
            }
            default -> size == WhistleBlock.WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE : (size == WhistleBlock.WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM : AllShapes.WHISTLE_EXTENDER_SMALL);
        };
    }

    public static enum WhistleExtenderShape implements StringRepresentable
    {
        SINGLE,
        DOUBLE,
        DOUBLE_CONNECTED;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

