/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.potatoCannon;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllEnchantments;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoCannonProjectileType;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileTypes;
import com.zurrtum.create.infrastructure.packet.s2c.NbtSpawnPacket;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotatoProjectileEntity
extends AbstractHurtingProjectile {
    protected PotatoCannonProjectileType type;
    protected ItemStack stack = ItemStack.EMPTY;
    protected Entity stuckEntity;
    protected Vec3 stuckOffset;
    protected PotatoProjectileRenderMode stuckRenderer;
    protected double stuckFallSpeed;
    protected float additionalDamageMult = 1.0f;
    protected float additionalKnockback = 0.0f;
    protected float recoveryChance = 0.0f;

    public PotatoProjectileEntity(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public void setItem(ItemStack stack) {
        this.stack = stack;
        RegistryAccess registryManager = this.registryAccess();
        this.type = (PotatoCannonProjectileType)PotatoCannonProjectileType.getTypeForItem(registryManager, stack.getItem()).orElseGet(() -> registryManager.lookupOrThrow(CreateRegistryKeys.POTATO_PROJECTILE_TYPE).getOrThrow(AllPotatoProjectileTypes.FALLBACK)).value();
    }

    public void setEnchantmentEffectsFromCannon(ItemStack cannon) {
        Registry enchantmentRegistry = this.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int recovery = cannon.getEnchantments().getLevel((Holder)enchantmentRegistry.getOrThrow(AllEnchantments.POTATO_RECOVERY));
        if (recovery > 0) {
            this.recoveryChance = 0.125f + (float)recovery * 0.125f;
        }
    }

    public ItemStack getItem() {
        return this.stack;
    }

    @Nullable
    public PotatoCannonProjectileType getProjectileType() {
        return this.type;
    }

    public void readAdditionalSaveData(ValueInput view) {
        this.setItem(view.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
        this.additionalDamageMult = view.getFloatOr("AdditionalDamage", 0.0f);
        this.additionalKnockback = view.getFloatOr("AdditionalKnockback", 0.0f);
        this.recoveryChance = view.getFloatOr("Recovery", 0.0f);
        super.readAdditionalSaveData(view);
    }

    public void addAdditionalSaveData(ValueOutput view) {
        if (!this.stack.isEmpty()) {
            view.store("Item", ItemStack.CODEC, (Object)this.stack);
        }
        view.putFloat("AdditionalDamage", this.additionalDamageMult);
        view.putFloat("AdditionalKnockback", this.additionalKnockback);
        view.putFloat("Recovery", this.recoveryChance);
        super.addAdditionalSaveData(view);
    }

    @Nullable
    public Entity getStuckEntity() {
        if (this.stuckEntity == null) {
            return null;
        }
        if (!this.stuckEntity.isAlive()) {
            return null;
        }
        return this.stuckEntity;
    }

    public void setStuckEntity(Entity stuckEntity) {
        this.stuckEntity = stuckEntity;
        this.stuckOffset = this.position().subtract(stuckEntity.position());
        this.stuckRenderer = new AllPotatoProjectileRenderModes.StuckToEntity(this.stuckOffset);
        this.stuckFallSpeed = 0.0;
        this.setDeltaMovement(Vec3.ZERO);
    }

    public PotatoProjectileRenderMode getRenderMode() {
        if (this.getStuckEntity() != null) {
            return this.stuckRenderer;
        }
        return this.type.renderMode();
    }

    public void tick() {
        Entity stuckEntity = this.getStuckEntity();
        if (stuckEntity != null) {
            if (this.getY() < stuckEntity.getY() - 0.1) {
                this.pop(this.position());
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    this.kill(serverWorld);
                }
            } else {
                this.stuckFallSpeed += 0.007 * (double)this.type.gravityMultiplier();
                this.stuckOffset = this.stuckOffset.add(0.0, -this.stuckFallSpeed, 0.0);
                Vec3 pos = stuckEntity.position().add(this.stuckOffset);
                this.setPos(pos.x, pos.y, pos.z);
            }
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05 * (double)this.type.gravityMultiplier(), 0.0).scale((double)this.type.drag()));
        }
        super.tick();
    }

    protected float getInertia() {
        return 1.0f;
    }

    protected ParticleOptions getTrailParticle() {
        return new AirParticleData(1.0f, 10.0f);
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    protected void onHitEntity(EntityHitResult ray) {
        Vec3 appliedMotion;
        Level world;
        WitherBoss wither;
        super.onHitEntity(ray);
        if (this.getStuckEntity() != null) {
            return;
        }
        Vec3 hit = ray.getLocation();
        Entity target = ray.getEntity();
        float damage = (float)this.type.damage() * this.additionalDamageMult;
        float knockback = this.type.knockback() + this.additionalKnockback;
        Entity owner = this.getOwner();
        if (!target.isAlive()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)owner;
            entity.setLastHurtMob(target);
        }
        if (target instanceof PotatoProjectileEntity) {
            PotatoProjectileEntity ppe = (PotatoProjectileEntity)target;
            if (this.tickCount < 10 && target.tickCount < 10) {
                return;
            }
            if (ppe.getProjectileType() != this.getProjectileType()) {
                Entity entity;
                ServerPlayer p;
                if (owner instanceof ServerPlayer) {
                    p = (ServerPlayer)owner;
                    AllAdvancements.POTATO_CANNON_COLLIDE.trigger(p);
                }
                if ((entity = ppe.getOwner()) instanceof ServerPlayer) {
                    p = (ServerPlayer)entity;
                    AllAdvancements.POTATO_CANNON_COLLIDE.trigger(p);
                }
            }
        }
        this.pop(hit);
        if (target instanceof WitherBoss && (wither = (WitherBoss)target).isPowered()) {
            return;
        }
        if (this.type.preEntityHit(this.stack, ray)) {
            return;
        }
        boolean targetIsEnderman = target.getType() == EntityType.ENDERMAN;
        int k = target.getRemainingFireTicks();
        if (this.isOnFire() && !targetIsEnderman) {
            target.igniteForSeconds(5.0f);
        }
        boolean onServer = !(world = this.level()).isClientSide();
        DamageSource damageSource = this.causePotatoDamage();
        if (onServer && !target.hurtServer((ServerLevel)world, damageSource, damage)) {
            target.setRemainingFireTicks(k);
            this.kill((ServerLevel)world);
            return;
        }
        if (targetIsEnderman) {
            return;
        }
        if (!this.type.onEntityHit(this.stack, ray) && onServer) {
            if (this.random.nextDouble() <= (double)this.recoveryChance) {
                this.recoverItem();
            } else {
                this.spawnAtLocation((ServerLevel)world, this.type.dropStack());
            }
        }
        if (!(target instanceof LivingEntity)) {
            PotatoProjectileEntity.playHitSound(world, this.position());
            if (onServer) {
                this.kill((ServerLevel)world);
            }
            return;
        }
        LivingEntity livingentity = (LivingEntity)target;
        if (this.type.reloadTicks() < 10) {
            livingentity.invulnerableTime = this.type.reloadTicks() + 10;
        }
        if (onServer && knockback > 0.0f && (appliedMotion = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize()).lengthSqr() > 0.0) {
            livingentity.knockback((double)knockback * 0.6, -appliedMotion.x, -appliedMotion.z);
        }
        if (onServer && owner instanceof LivingEntity) {
            EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)world), (Entity)livingentity, (DamageSource)damageSource);
        }
        if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            if (!this.isSilent()) {
                serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.PLAY_ARROW_HIT_SOUND, 0.0f));
            }
        }
        if (onServer && owner instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)owner;
            if (!target.isAlive() && target.getType().getCategory() == MobCategory.MONSTER || target instanceof Player && target != owner) {
                AllAdvancements.POTATO_CANNON.trigger(serverplayerentity);
            }
        }
        if (this.type.sticky() && target.isAlive()) {
            this.setStuckEntity(target);
        } else if (onServer) {
            this.kill((ServerLevel)world);
        }
    }

    private void recoverItem() {
        Level level;
        if (!this.stack.isEmpty() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.spawnAtLocation(serverWorld, this.stack.copyWithCount(1));
        }
    }

    public static void playHitSound(Level world, Vec3 location) {
        AllSoundEvents.POTATO_HIT.playOnServer(world, (Vec3i)BlockPos.containing((Position)location));
    }

    public static void playLaunchSound(Level world, Vec3 location, float pitch) {
        AllSoundEvents.FWOOMP.playAt(world, location, 1.0f, pitch, true);
    }

    protected void onHitBlock(BlockHitResult ray) {
        Vec3 hit = ray.getLocation();
        this.pop(hit);
        Level world = this.level();
        if (!this.type.onBlockHit((LevelAccessor)world, this.stack, ray) && !world.isClientSide()) {
            if (this.random.nextDouble() <= (double)this.recoveryChance) {
                this.recoverItem();
            } else {
                this.spawnAtLocation((ServerLevel)world, this.getProjectileType().dropStack());
            }
        }
        super.onHitBlock(ray);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.kill(serverWorld);
        }
    }

    public boolean hurtServer(ServerLevel world, @NotNull DamageSource source, float amt) {
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return false;
        }
        if (this.isInvulnerableToBase(source)) {
            return false;
        }
        this.pop(this.position());
        this.kill(world);
        return true;
    }

    private void pop(Vec3 hit) {
        if (!this.stack.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                Vec3 m = VecHelper.offsetRandomly(Vec3.ZERO, this.random, 0.25f);
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.stack), hit.x, hit.y, hit.z, m.x, m.y, m.z);
            }
        }
        if (!this.level().isClientSide()) {
            PotatoProjectileEntity.playHitSound(this.level(), this.position());
        }
    }

    private DamageSource causePotatoDamage() {
        return AllDamageSources.get(this.level()).potatoCannon((Entity)this, this.getOwner());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)this.registryAccess());
            this.addAdditionalSaveData((ValueOutput)view);
            NbtSpawnPacket nbtSpawnPacket = new NbtSpawnPacket((Entity)this, entityTrackerEntry, view.buildResult());
            return nbtSpawnPacket;
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        CompoundTag nbt = ((NbtSpawnPacket)packet).getNbt();
        if (nbt == null) {
            return;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
            this.readAdditionalSaveData(TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)this.registryAccess(), (CompoundTag)nbt));
        }
    }
}

