/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.spout;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.spout.FillingBySpout;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class SpoutBlockEntity
extends SmartBlockEntity {
    public static final int FILLING_TIME = 20;
    protected BeltProcessingBehaviour beltProcessing;
    public int processingTicks = -1;
    public boolean sendSplash;
    public BlockSpoutingBehaviour customProcess;
    public SmartFluidTankBehaviour tank;
    private boolean createdSweetRoll;
    private boolean createdHoneyApple;
    private boolean createdChocolateBerries;
    protected static int SPLASH_PARTICLE_COUNT = 20;

    public SpoutBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SPOUT, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().expandTowards(0.0, -2.0, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.tank = SmartFluidTankBehaviour.single(this, 81000, (TriFunction<SmartFluidTankBehaviour, Boolean, Optional<Integer>, SmartFluidTankBehaviour.InternalFluidHandler>)((TriFunction)SpoutFluidHandler::new));
        behaviours.add(this.tank);
        this.beltProcessing = new BeltProcessingBehaviour(this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add(this.beltProcessing);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.SPOUT, AllAdvancements.FOODS);
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!FillingBySpout.canItemBeFilled(this.level, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (FillingBySpout.getRequiredAmountForItem((ServerLevel)this.level, transported.stack, this.getCurrentFluidInTank()) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.processingTicks != -1 && this.processingTicks != 5) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!FillingBySpout.canItemBeFilled(this.level, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = FillingBySpout.getRequiredAmountForItem((ServerLevel)this.level, transported.stack, fluid.copy());
        if (requiredAmountForItem <= 0) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 20;
            this.notifyUpdate();
            AllSoundEvents.SPOUTING.playOnServer(this.level, (Vec3i)this.worldPosition, 0.75f, 0.9f + 0.2f * (float)Math.random());
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        ItemStack out = FillingBySpout.fillItem((ServerLevel)this.level, requiredAmountForItem, transported.stack, fluid);
        if (!out.isEmpty()) {
            transported.clearFanProcessingData();
            ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.isEmpty()) {
                held = transported.copy();
            }
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, held));
        }
        this.award(AllAdvancements.SPOUT);
        if (this.trackFoods()) {
            this.createdChocolateBerries |= out.is(AllItems.CHOCOLATE_BERRIES);
            this.createdHoneyApple |= out.is(AllItems.HONEYED_APPLE);
            this.createdSweetRoll |= out.is(AllItems.SWEET_ROLL);
            if (this.createdChocolateBerries && this.createdHoneyApple && this.createdSweetRoll) {
                this.award(AllAdvancements.FOODS);
            }
        }
        SmartFluidTankBehaviour.TankSegment primaryHandler = this.tank.getPrimaryHandler();
        primaryHandler.setFluid(fluid);
        primaryHandler.markDirty();
        this.sendSplash = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putInt("ProcessingTicks", this.processingTicks);
        if (this.sendSplash && clientPacket) {
            view.putBoolean("Splash", true);
            this.sendSplash = false;
        }
        if (!this.trackFoods()) {
            return;
        }
        if (this.createdChocolateBerries) {
            view.putBoolean("ChocolateBerries", true);
        }
        if (this.createdHoneyApple) {
            view.putBoolean("HoneyApple", true);
        }
        if (this.createdSweetRoll) {
            view.putBoolean("SweetRoll", true);
        }
    }

    private boolean trackFoods() {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        return behaviour != null && behaviour.isOwnerPresent();
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.processingTicks = view.getIntOr("ProcessingTicks", 0);
        this.createdChocolateBerries = view.getBooleanOr("ChocolateBerries", false);
        this.createdHoneyApple = view.getBooleanOr("HoneyApple", false);
        this.createdSweetRoll = view.getBooleanOr("SweetRoll", false);
        if (!clientPacket) {
            return;
        }
        if (view.getBooleanOr("Splash", false)) {
            this.spawnSplash(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    @Override
    public void tick() {
        BlockPos filling;
        BlockSpoutingBehaviour behavior;
        super.tick();
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (!(this.processingTicks != -1 || !this.isVirtual() && this.level.isClientSide() || currentFluidInTank.isEmpty() || (behavior = BlockSpoutingBehaviour.get(this.level, filling = this.worldPosition.below(2))) == null || behavior.fillBlock(this.level, filling, this, currentFluidInTank.copy(), true) <= 0)) {
            this.processingTicks = 20;
            this.customProcess = behavior;
            this.notifyUpdate();
        }
        if (this.processingTicks >= 0) {
            --this.processingTicks;
            if (this.processingTicks == 5 && this.customProcess != null) {
                int fillBlock = this.customProcess.fillBlock(this.level, this.worldPosition.below(2), this, currentFluidInTank.copy(), false);
                this.customProcess = null;
                if (fillBlock > 0) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount(currentFluidInTank, currentFluidInTank.getAmount() - fillBlock));
                    this.sendSplash = true;
                    this.notifyUpdate();
                }
            }
        }
        if (this.processingTicks >= 8 && this.level.isClientSide()) {
            this.spawnProcessingParticles(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    protected void spawnProcessingParticles(FluidStack fluid) {
        if (this.isVirtual() || fluid.isEmpty()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        vec = vec.subtract(0.0, 0.5, 0.0);
        FluidParticleData particle = new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
        this.level.addAlwaysVisibleParticle((ParticleOptions)particle, vec.x, vec.y, vec.z, 0.0, (double)-0.1f, 0.0);
    }

    protected void spawnSplash(FluidStack fluid) {
        if (this.isVirtual() || fluid.isEmpty()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        vec = vec.subtract(0.0, 1.6875, 0.0);
        FluidParticleData particle = new FluidParticleData(AllParticleTypes.FLUID_PARTICLE, fluid.getFluid(), fluid.getComponentChanges());
        for (int i = 0; i < SPLASH_PARTICLE_COUNT; ++i) {
            Vec3 m = VecHelper.offsetRandomly(Vec3.ZERO, this.level.random, 0.125f);
            m = new Vec3(m.x, Math.abs(m.y), m.z);
            this.level.addAlwaysVisibleParticle((ParticleOptions)particle, vec.x, vec.y, vec.z, m.x, m.y, m.z);
        }
    }

    public static class SpoutFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        private static final int[] EMPTY_SLOTS = new int[0];

        public SpoutFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            super(behaviour, enforceVariety, max);
        }

        @Override
        public int[] getAvailableSlots(@Nullable Direction side) {
            if (side == Direction.DOWN) {
                return EMPTY_SLOTS;
            }
            return super.getAvailableSlots(side);
        }
    }
}

