/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface IRotate
extends IWrenchable {
    public boolean hasShaftTowards(LevelReader var1, BlockPos var2, BlockState var3, Direction var4);

    public Direction.Axis getRotationAxis(BlockState var1);

    default public SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.NONE;
    }

    default public boolean hideStressImpact() {
        return false;
    }

    default public boolean showCapacityWithAnnotation() {
        return false;
    }

    public static enum SpeedLevel {
        NONE(ChatFormatting.DARK_GRAY, 0, 0),
        SLOW(ChatFormatting.GREEN, 0x22FF22, 10),
        MEDIUM(ChatFormatting.AQUA, 34047, 20),
        FAST(ChatFormatting.LIGHT_PURPLE, 0xFF55FF, 30);

        private final ChatFormatting textColor;
        private final int color;
        private final int particleSpeed;

        private SpeedLevel(ChatFormatting textColor, int color, int particleSpeed) {
            this.textColor = textColor;
            this.color = color;
            this.particleSpeed = particleSpeed;
        }

        public static SpeedLevel of(float speed) {
            if ((speed = Math.abs(speed)) >= ((Float)AllConfigs.server().kinetics.fastSpeed.get()).floatValue()) {
                return FAST;
            }
            if (speed >= ((Float)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue()) {
                return MEDIUM;
            }
            if (speed >= 1.0f) {
                return SLOW;
            }
            return NONE;
        }

        public ChatFormatting getTextColor() {
            return this.textColor;
        }

        public int getColor() {
            return this.color;
        }

        public int getParticleSpeed() {
            return this.particleSpeed;
        }

        public float getSpeedValue() {
            return switch (this.ordinal()) {
                case 3 -> ((Float)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
                case 2 -> ((Float)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
                case 1 -> 1.0f;
                default -> 0.0f;
            };
        }
    }

    public static enum StressImpact {
        LOW(ChatFormatting.YELLOW, ChatFormatting.GREEN),
        MEDIUM(ChatFormatting.GOLD, ChatFormatting.YELLOW),
        HIGH(ChatFormatting.RED, ChatFormatting.GOLD),
        OVERSTRESSED(ChatFormatting.RED, ChatFormatting.RED);

        private final ChatFormatting absoluteColor;
        private final ChatFormatting relativeColor;

        private StressImpact(ChatFormatting absoluteColor, ChatFormatting relativeColor) {
            this.absoluteColor = absoluteColor;
            this.relativeColor = relativeColor;
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1.0) {
                return OVERSTRESSED;
            }
            if (stressPercent > 0.75) {
                return HIGH;
            }
            if (stressPercent > 0.5) {
                return MEDIUM;
            }
            return LOW;
        }

        public static boolean isEnabled() {
            return (Boolean)AllConfigs.server().kinetics.disableStress.get() == false;
        }

        public ChatFormatting getAbsoluteColor() {
            return this.absoluteColor;
        }

        public ChatFormatting getRelativeColor() {
            return this.relativeColor;
        }
    }
}

