/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.logistics.chute.AbstractChuteBlock;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class AllArmInteractionPointTypes {
    public static final BasinType BASIN = AllArmInteractionPointTypes.register("basin", new BasinType());
    public static final BeltType BELT = AllArmInteractionPointTypes.register("belt", new BeltType());
    public static final BlazeBurnerType BLAZE_BURNER = AllArmInteractionPointTypes.register("blaze_burner", new BlazeBurnerType());
    public static final ChuteType CHUTE = AllArmInteractionPointTypes.register("chute", new ChuteType());
    public static final CrafterType CRAFTER = AllArmInteractionPointTypes.register("crafter", new CrafterType());
    public static final CrushingWheelsType CRUSHING_WHEELS = AllArmInteractionPointTypes.register("crushing_wheels", new CrushingWheelsType());
    public static final DeployerType DEPLOYER = AllArmInteractionPointTypes.register("deployer", new DeployerType());
    public static final DepotType DEPOT = AllArmInteractionPointTypes.register("depot", new DepotType());
    public static final FunnelType FUNNEL = AllArmInteractionPointTypes.register("funnel", new FunnelType());
    public static final MillstoneType MILLSTONE = AllArmInteractionPointTypes.register("millstone", new MillstoneType());
    public static final PackagerType PACKAGER = AllArmInteractionPointTypes.register("packager", new PackagerType());
    public static final SawType SAW = AllArmInteractionPointTypes.register("saw", new SawType());
    public static final CampfireType CAMPFIRE = AllArmInteractionPointTypes.register("campfire", new CampfireType());
    public static final ComposterType COMPOSTER = AllArmInteractionPointTypes.register("composter", new ComposterType());
    public static final JukeboxType JUKEBOX = AllArmInteractionPointTypes.register("jukebox", new JukeboxType());
    public static final RespawnAnchorType RESPAWN_ANCHOR = AllArmInteractionPointTypes.register("respawn_anchor", new RespawnAnchorType());

    private static <T extends ArmInteractionPointType> T register(String name, T type) {
        return (T)((ArmInteractionPointType)Registry.register(CreateRegistries.ARM_INTERACTION_POINT_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)name), type));
    }

    public static void register() {
    }

    public static class BasinType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return BasinBlock.isBasin((LevelReader)level, pos);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class BeltType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.BELT) && !(level.getBlockState(pos.above()).getBlock() instanceof BeltTunnelBlock) && BeltBlock.canTransportObjects(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BeltPoint(this, level, pos, state);
        }
    }

    public static class BlazeBurnerType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.BLAZE_BURNER);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BlazeBurnerPoint(this, level, pos, state);
        }
    }

    public static class ChuteType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AbstractChuteBlock.isChute(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class CrafterType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.MECHANICAL_CRAFTER);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CrafterPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelsType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.CRUSHING_WHEEL_CONTROLLER);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CrushingWheelPoint(this, level, pos, state);
        }
    }

    public static class DeployerType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.DEPLOYER);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DeployerPoint(this, level, pos, state);
        }
    }

    public static class DepotType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.DEPOT) || state.is((Block)AllBlocks.WEIGHTED_EJECTOR) || state.is((Block)AllBlocks.TRACK_STATION);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class FunnelType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return !(!(state.getBlock() instanceof AbstractFunnelBlock) || state.hasProperty((Property)FunnelBlock.EXTRACTING) && (Boolean)state.getValue((Property)FunnelBlock.EXTRACTING) != false || state.hasProperty(BeltFunnelBlock.SHAPE) && state.getValue(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PUSHING);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new FunnelPoint(this, level, pos, state);
        }
    }

    public static class MillstoneType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.MILLSTONE);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class PackagerType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.PACKAGER) || state.is((Block)AllBlocks.REPACKAGER);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class SawType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is((Block)AllBlocks.MECHANICAL_SAW) && state.getValue((Property)SawBlock.FACING) == Direction.UP && ((KineticBlockEntity)level.getBlockEntity(pos)).getSpeed() != 0.0f;
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class CampfireType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.getBlock() instanceof CampfireBlock;
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CampfirePoint(this, level, pos, state);
        }
    }

    public static class ComposterType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is(Blocks.COMPOSTER);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ComposterPoint(this, level, pos, state);
        }
    }

    public static class JukeboxType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is(Blocks.JUKEBOX);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new JukeboxPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.is(Blocks.RESPAWN_ANCHOR);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new RespawnAnchorPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelPoint
    extends DepositOnlyArmInteractionPoint {
        public CrushingWheelPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 1.0, 0.5);
        }
    }

    public static class RespawnAnchorPoint
    extends DepositOnlyArmInteractionPoint {
        public RespawnAnchorPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 1.0, 0.5);
        }

        @Override
        public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
            if (!stack.is(Items.GLOWSTONE)) {
                return stack;
            }
            if ((Integer)this.cachedState.getValueOrElse((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(4)) == 4) {
                return stack;
            }
            if (!simulate) {
                RespawnAnchorBlock.charge(null, (Level)this.level, (BlockPos)this.pos, (BlockState)this.cachedState);
            }
            ItemStack remainder = stack.copy();
            remainder.shrink(1);
            return remainder;
        }
    }

    public static class JukeboxPoint
    extends TopFaceArmInteractionPoint {
        public JukeboxPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public int getSlotCount(ArmBlockEntity armBlockEntity) {
            return 1;
        }

        @Override
        public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
            if (stack.get(DataComponents.JUKEBOX_PLAYABLE) == null) {
                return stack;
            }
            if (((Boolean)this.cachedState.getValueOrElse((Property)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(true))).booleanValue()) {
                return stack;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
            if (!(blockEntity instanceof JukeboxBlockEntity)) {
                return stack;
            }
            JukeboxBlockEntity jukeboxBE = (JukeboxBlockEntity)blockEntity;
            if (!jukeboxBE.getTheItem().isEmpty()) {
                return stack;
            }
            ItemStack remainder = stack.copy();
            ItemStack toInsert = remainder.split(1);
            if (!simulate) {
                jukeboxBE.setTheItem(toInsert);
            }
            return remainder;
        }

        @Override
        public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            if (!((Boolean)this.cachedState.getValueOrElse((Property)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                return ItemStack.EMPTY;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
            if (!(blockEntity instanceof JukeboxBlockEntity)) {
                return ItemStack.EMPTY;
            }
            JukeboxBlockEntity jukeboxBE = (JukeboxBlockEntity)blockEntity;
            if (!simulate) {
                return jukeboxBE.removeItem(slot, amount);
            }
            return jukeboxBE.getTheItem();
        }
    }

    public static class ComposterPoint
    extends ArmInteractionPoint {
        public ComposterPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 0.8125, 0.5);
        }

        @Override
        @Nullable
        protected Container getHandler(ArmBlockEntity armBlockEntity) {
            ComposterBlock composterBlock = (ComposterBlock)Blocks.COMPOSTER;
            return composterBlock.getContainer(this.cachedState, (LevelAccessor)this.level, this.pos);
        }

        @Override
        public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            Container handler = this.getHandler(armBlockEntity);
            if (handler == null) {
                return ItemStack.EMPTY;
            }
            if (simulate) {
                return handler.count(stack -> true, amount, Direction.DOWN);
            }
            return handler.extract(stack -> true, amount, Direction.DOWN);
        }

        @Override
        public int getSlotCount(ArmBlockEntity armBlockEntity) {
            return 2;
        }
    }

    public static class CampfirePoint
    extends DepositOnlyArmInteractionPoint {
        public CampfirePoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
            if (!(blockEntity instanceof CampfireBlockEntity)) {
                return stack;
            }
            CampfireBlockEntity campfireBE = (CampfireBlockEntity)blockEntity;
            if (!this.level.recipeAccess().propertySet(RecipePropertySet.CAMPFIRE_INPUT).test(stack)) {
                return stack;
            }
            if (simulate) {
                boolean hasSpace = false;
                for (ItemStack campfireStack : campfireBE.getItems()) {
                    if (!campfireStack.isEmpty()) continue;
                    hasSpace = true;
                    break;
                }
                if (!hasSpace) {
                    return stack;
                }
                ItemStack remainder = stack.copy();
                remainder.shrink(1);
                return remainder;
            }
            ItemStack remainder = stack.copy();
            campfireBE.placeFood((ServerLevel)this.level, null, remainder);
            return remainder;
        }
    }

    public static class FunnelPoint
    extends DepositOnlyArmInteractionPoint {
        public FunnelPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            Direction funnelFacing = FunnelBlock.getFunnelFacing(this.cachedState);
            Vec3i normal = funnelFacing != null ? funnelFacing.getUnitVec3i() : Vec3i.ZERO;
            return VecHelper.getCenterOf((Vec3i)this.pos).add(Vec3.atLowerCornerOf((Vec3i)normal).scale((double)-0.15f));
        }

        @Override
        protected Direction getInteractionDirection() {
            Direction funnelFacing = FunnelBlock.getFunnelFacing(this.cachedState);
            return funnelFacing != null ? funnelFacing.getOpposite() : Direction.UP;
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
            BlockEntity blockEntity;
            ServerFilteringBehaviour filtering = BlockEntityBehaviour.get((BlockGetter)this.level, this.pos, ServerFilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = BlockEntityBehaviour.get((BlockGetter)this.level, this.pos, InvManipulationBehaviour.TYPE);
            if (((Boolean)this.cachedState.getValueOrElse((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                return stack;
            }
            if (inserter == null) {
                return stack;
            }
            if (filtering != null && !filtering.test(stack)) {
                return stack;
            }
            if (simulate) {
                inserter.simulate();
            }
            ItemStack insert = inserter.insert(stack);
            if (!simulate && insert.getCount() != stack.getCount() && (blockEntity = this.level.getBlockEntity(this.pos)) instanceof FunnelBlockEntity) {
                FunnelBlockEntity funnelBlockEntity = (FunnelBlockEntity)blockEntity;
                funnelBlockEntity.onTransfer(stack);
                if (funnelBlockEntity.hasFlap()) {
                    funnelBlockEntity.flap(true);
                }
            }
            return insert;
        }
    }

    public static class DepotPoint
    extends ArmInteractionPoint {
        public DepotPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 0.875, 0.5);
        }
    }

    public static class DeployerPoint
    extends ArmInteractionPoint {
        public DeployerPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return ((Direction)this.cachedState.getValueOrElse((Property)DeployerBlock.FACING, (Comparable)Direction.UP)).getOpposite();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().add(Vec3.atLowerCornerOf((Vec3i)this.getInteractionDirection().getUnitVec3i()).scale((double)0.65f));
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }
    }

    public static class CrafterPoint
    extends ArmInteractionPoint {
        public CrafterPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return ((Direction)this.cachedState.getValueOrElse((Property)MechanicalCrafterBlock.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).getOpposite();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().add(Vec3.atLowerCornerOf((Vec3i)this.getInteractionDirection().getUnitVec3i()).scale(0.5));
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            BlockEntity be = this.level.getBlockEntity(this.pos);
            if (!(be instanceof MechanicalCrafterBlockEntity)) {
                return ItemStack.EMPTY;
            }
            MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)be;
            MechanicalCrafterBlockEntity.CrafterItemHandler inventory = crafter.getInventory();
            ItemStack stack = inventory.getStack();
            int count = stack.getCount();
            if (count == 0) {
                return ItemStack.EMPTY;
            }
            if (amount >= count) {
                inventory.setStack(ItemStack.EMPTY);
            } else {
                stack.setCount(count - amount);
                stack = stack.copyWithCount(amount);
            }
            inventory.setChanged();
            return inventory.onExtract(stack);
        }
    }

    public static class BlazeBurnerPoint
    extends DepositOnlyArmInteractionPoint {
        public BlazeBurnerPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
            InteractionResult.Success success;
            ItemStack newHandStack;
            ItemStack input = stack.copy();
            InteractionResult res = BlazeBurnerBlock.tryInsert(this.cachedState, this.level, this.pos, input, false, false, simulate);
            ItemStack remainder = ItemStack.EMPTY;
            if (res instanceof InteractionResult.Success && (newHandStack = (success = (InteractionResult.Success)res).heldItemTransformedTo()) != null && !newHandStack.isEmpty()) {
                remainder = newHandStack;
            }
            if (input.isEmpty()) {
                return remainder;
            }
            if (!simulate) {
                Containers.dropItemStack((Level)this.level, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), (ItemStack)remainder);
            }
            return input;
        }
    }

    public static class BeltPoint
    extends DepotPoint {
        public BeltPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public void keepAlive() {
            super.keepAlive();
            BeltBlockEntity beltBE = BeltHelper.getSegmentBE((LevelAccessor)this.level, this.pos);
            if (beltBE == null) {
                return;
            }
            TransportedItemStackHandlerBehaviour transport = beltBE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null) {
                return;
            }
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public static class TopFaceArmInteractionPoint
    extends ArmInteractionPoint {
        public TopFaceArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.atLowerCornerOf((Vec3i)this.pos).add(0.5, 1.0, 0.5);
        }
    }

    public static class DepositOnlyArmInteractionPoint
    extends ArmInteractionPoint {
        public DepositOnlyArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public void cycleMode() {
        }

        @Override
        public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        @Override
        public int getSlotCount(ArmBlockEntity armBlockEntity) {
            return 0;
        }
    }
}

