/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SteamEngineBlockEntity
extends SmartBlockEntity {
    protected ServerScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public WeakReference<PoweredShaftBlockEntity> target;
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public float prevAngle = 0.0f;

    public SteamEngineBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.STEAM_ENGINE, pos, state);
        this.target = new WeakReference<Object>(null);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.movementDirection = new ServerScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection>(WindmillBearingBlockEntity.RotationDirection.class, this);
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_ENGINE);
    }

    private void onDirectionChanged() {
    }

    @Override
    public void tick() {
        int conveyedSpeedLevel;
        float efficiency;
        super.tick();
        FluidTankBlockEntity tank = this.getTank();
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (tank == null || shaft == null || !this.isValid()) {
            if (this.level.isClientSide()) {
                return;
            }
            if (shaft == null) {
                return;
            }
            if (!shaft.getBlockPos().subtract((Vec3i)this.worldPosition).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            Direction facing = SteamEngineBlock.getFacing(this.getBlockState());
            if (this.level.isLoaded(this.worldPosition.relative(facing.getOpposite()))) {
                shaft.update(this.worldPosition, 0, 0.0f);
            }
            return;
        }
        BlockState shaftState = shaft.getBlockState();
        Direction.Axis targetAxis = Direction.Axis.X;
        Block block = shaftState.getBlock();
        if (block instanceof IRotate) {
            IRotate ir = (IRotate)block;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        boolean verticalTarget = targetAxis == Direction.Axis.Y;
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.STEAM_ENGINE)) {
            return;
        }
        Direction facing = SteamEngineBlock.getFacing(blockState);
        if (facing.getAxis() == Direction.Axis.Y) {
            facing = (Direction)blockState.getValue((Property)SteamEngineBlock.FACING);
        }
        if ((efficiency = Mth.clamp((float)tank.boiler.getEngineEfficiency(tank.getTotalTankSize()), (float)0.0f, (float)1.0f)) > 0.0f) {
            this.award(AllAdvancements.STEAM_ENGINE);
        }
        int n = efficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection(1.0f, facing));
        if (targetAxis == Direction.Axis.Z) {
            conveyedSpeedLevel *= -1;
        }
        if (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            this.movementDirection.setValue(1 - this.movementDirection.get().ordinal());
            conveyedSpeedLevel *= -1;
        }
        shaft.update(this.worldPosition, conveyedSpeedLevel, efficiency);
        if (!this.level.isClientSide()) {
            return;
        }
        AllClientHandle.INSTANCE.spawnSteamEngineParticles(this);
    }

    @Override
    public void remove() {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft != null) {
            shaft.remove(this.worldPosition);
        }
        super.remove();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public PoweredShaftBlockEntity getShaft() {
        PoweredShaftBlockEntity shaft = (PoweredShaftBlockEntity)this.target.get();
        if (shaft == null || shaft.isRemoved() || !shaft.canBePoweredBy(this.worldPosition)) {
            PoweredShaftBlockEntity ps;
            Direction facing;
            BlockEntity anyShaftAt;
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.level.getBlockEntity(this.worldPosition.relative(facing = SteamEngineBlock.getFacing(this.getBlockState()), 2))) instanceof PoweredShaftBlockEntity && (ps = (PoweredShaftBlockEntity)anyShaftAt).canBePoweredBy(this.worldPosition)) {
                shaft = ps;
                this.target = new WeakReference<PoweredShaftBlockEntity>(shaft);
            }
        }
        return shaft;
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.isRemoved()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.level.getBlockEntity(this.worldPosition.relative((facing = SteamEngineBlock.getFacing(this.getBlockState())).getOpposite()))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }

    public boolean isValid() {
        Direction dir = SteamEngineBlock.getConnectedDirection(this.getBlockState()).getOpposite();
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        return level.getBlockState(this.getBlockPos().relative(dir)).is((Block)AllBlocks.FLUID_TANK);
    }
}

