/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.box;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.chute.ChuteBlock;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.packet.s2c.PackageDestroyPacket;
import com.zurrtum.create.infrastructure.packet.s2c.PackageSpawnPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PackageEntity
extends LivingEntity {
    private Entity originalEntity;
    public ItemStack box;
    public int insertionDelay;
    public Vec3 vec2 = Vec3.ZERO;
    public Vec3 vec3 = Vec3.ZERO;
    public WeakReference<Player> tossedBy = new WeakReference<Object>(null);

    public PackageEntity(EntityType<? extends PackageEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.box = ItemStack.EMPTY;
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.setYHeadRot(this.getYRot());
        this.yRotO = this.getYRot();
        this.insertionDelay = 30;
    }

    public PackageEntity(Level worldIn, double x, double y, double z) {
        this(AllEntityTypes.PACKAGE, worldIn);
        this.setPos(x, y, z);
        this.refreshDimensions();
    }

    public void move(MoverType type, Vec3 movement) {
        super.move(type, movement);
        if (movement.lengthSqr() >= (double)0.01f) {
            this.needsSync = true;
        }
    }

    public static PackageEntity fromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack) {
        PackageEntity packageEntity = new PackageEntity(AllEntityTypes.PACKAGE, world);
        Vec3 position = originalEntity.position();
        packageEntity.setPos(position);
        packageEntity.setBox(itemstack);
        packageEntity.setDeltaMovement(originalEntity.getDeltaMovement().scale(1.5));
        packageEntity.originalEntity = originalEntity;
        if (world != null && !world.isClientSide() && ChuteBlock.isChute(world.getBlockState(BlockPos.containing((double)position.x, (double)(position.y + 0.5), (double)position.z)))) {
            packageEntity.setYRot((int)packageEntity.getYRot() / 90 * 90);
        }
        return packageEntity;
    }

    public static PackageEntity fromItemStack(Level world, Vec3 position, ItemStack itemstack) {
        PackageEntity packageEntity = new PackageEntity(AllEntityTypes.PACKAGE, world);
        packageEntity.setPos(position);
        packageEntity.setBox(itemstack);
        return packageEntity;
    }

    public ItemStack getPickResult() {
        return this.box.copy();
    }

    public static AttributeSupplier.Builder createPackageAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 1.0);
    }

    public boolean canSimulateMovement() {
        return true;
    }

    public boolean isEffectiveAi() {
        return true;
    }

    public void travel(Vec3 p_213352_1_) {
        super.travel(p_213352_1_);
        if (!this.level().isClientSide()) {
            return;
        }
        if (this.getDeltaMovement().length() < 0.0078125) {
            return;
        }
        if (this.tickCount >= 20) {
            return;
        }
        Vec3 motion = this.getDeltaMovement().scale(0.75);
        AABB bb = this.getBoundingBox();
        List entityStream = this.level().getEntityCollisions((Entity)this, bb.expandTowards(motion));
        motion = PackageEntity.collideBoundingBox((Entity)this, (Vec3)motion, (AABB)bb, (Level)this.level(), (List)entityStream);
        Vec3 clientPos = this.position().add(motion);
        if (this.isInterpolating()) {
            clientPos = VecHelper.lerp(Math.min(1.0f, (float)this.tickCount / 20.0f), clientPos, this.getInterpolation().position());
        }
        if (this.tickCount < 5) {
            this.setPos(clientPos.x, clientPos.y, clientPos.z);
        }
        if (this.tickCount < 20) {
            this.getInterpolation().interpolateTo(clientPos, this.getYRot(), this.getXRot());
        }
    }

    public void lerpMotion(Vec3 clientVelocity) {
        this.setDeltaMovement(this.getDeltaMovement().add(clientVelocity).scale(0.5));
    }

    public String getAddress() {
        return (String)this.box.get(AllDataComponents.PACKAGE_ADDRESS);
    }

    public void tick() {
        if (this.firstTick) {
            this.verifyInitialEntity();
            this.originalEntity = null;
        }
        this.insertionDelay = Math.min(this.insertionDelay + 1, 30);
        super.tick();
        if (!PackageItem.isPackage(this.box)) {
            this.discard();
        }
    }

    protected void verifyInitialEntity() {
        Entity entity = this.originalEntity;
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)this.registryAccess());
            itemEntity.addAdditionalSaveData((ValueOutput)view);
            if (view.buildResult().getIntOr("PickupDelay", 0) != Short.MAX_VALUE) {
                return;
            }
            this.discard();
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.box == null) {
            return super.getDefaultDimensions(pose);
        }
        return EntityDimensions.fixed((float)PackageItem.getWidth(this.box), (float)PackageItem.getHeight(this.box));
    }

    public ItemStack getBox() {
        return this.box;
    }

    public static boolean centerPackage(Entity entity, Vec3 target) {
        if (!(entity instanceof PackageEntity)) {
            return true;
        }
        PackageEntity packageEntity = (PackageEntity)entity;
        return packageEntity.decreaseInsertionTimer(target);
    }

    public boolean decreaseInsertionTimer(@Nullable Vec3 targetSpot) {
        if (targetSpot != null) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.75).multiply(1.0, 0.25, 1.0));
            Vec3 pos = this.position().add(targetSpot.subtract(this.position()).scale((double)0.2f));
            this.setPos(pos.x, pos.y, pos.z);
            float yawTarget = (int)this.getYRot() / 90 * 90;
            this.setYRot(AngleHelper.angleLerp(0.5, this.getYRot(), yawTarget));
        }
        this.insertionDelay = Math.max(this.insertionDelay - 3, 0);
        return this.insertionDelay == 0;
    }

    public void setBox(ItemStack box) {
        this.box = box.copy();
        this.refreshDimensions();
    }

    public boolean isPushable() {
        return true;
    }

    public boolean canCollideWith(Entity pEntity) {
        return pEntity instanceof PackageEntity && pEntity.getBoundingBox().maxY < this.getBoundingBox().minY + 0.125;
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        if (!pPlayer.getItemInHand(pHand).isEmpty()) {
            return super.interact(pPlayer, pHand);
        }
        if (pPlayer.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        pPlayer.setItemInHand(pHand, this.box);
        this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 0.75f + this.level().random.nextFloat());
        this.remove(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    public void push(Entity entityIn) {
        boolean isOtherPackage = entityIn instanceof PackageEntity;
        if (!isOtherPackage && this.tossedBy.get() != null) {
            this.tossedBy = new WeakReference<Object>(null);
        }
        if (isOtherPackage) {
            if (entityIn.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(entityIn);
            }
        } else if (entityIn.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(entityIn);
        }
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(0.0, (double)entity.getDimensions(this.getPose()).height(), 0.0);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).add(0.0, 0.125, 0.0);
    }

    protected void onInsideBlock(BlockState state) {
        super.onInsideBlock(state);
        if (!this.isAlive()) {
            return;
        }
        if (state.getBlock() == Blocks.WATER || state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            this.destroy(this.damageSources().drown());
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        AbstractArrow persistentProjectileEntity;
        if (this.level().isClientSide() || !this.isAlive()) {
            return false;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.remove(Entity.RemovalReason.KILLED);
            return false;
        }
        if (source.equals(this.damageSources().inWall()) && (this.isPassenger() || this.insertionDelay < 20)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FALL)) {
            return false;
        }
        if (this.isInvulnerableTo((ServerLevel)this.level(), source)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            this.destroy(source);
            this.remove(Entity.RemovalReason.KILLED);
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            if (this.isOnFire()) {
                this.takeDamage(source, 0.15f);
            } else {
                this.setRemainingFireTicks(100);
            }
            return false;
        }
        Entity entity = source.getDirectEntity();
        boolean shotCanPierce = entity instanceof AbstractArrow ? (persistentProjectileEntity = (AbstractArrow)entity).getPierceLevel() > 0 : false;
        entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.getAbilities().mayBuild) {
                return false;
            }
        }
        this.destroy(source);
        this.remove(Entity.RemovalReason.KILLED);
        return shotCanPierce;
    }

    private void takeDamage(DamageSource source, float amount) {
        float hp = this.getHealth();
        if ((hp -= amount) <= 0.5f) {
            this.destroy(source);
            this.remove(Entity.RemovalReason.KILLED);
        } else {
            this.setHealth(hp);
        }
    }

    private void destroy(DamageSource source) {
        AllSoundEvents.PACKAGE_POP.playOnServer(this.level(), (Vec3i)this.blockPosition());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dropAllDeathLoot(serverLevel, source);
            serverLevel.getChunkSource().sendToTrackingPlayers((Entity)this, (Packet)new PackageDestroyPacket(this.getBoundingBox().getCenter(), this.box));
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource pDamageSource) {
        super.dropAllDeathLoot(level, pDamageSource);
        ItemStackHandler contents = PackageItem.getContents(this.box);
        int size = contents.getContainerSize();
        for (int i = 0; i < size; ++i) {
            SpawnEggItem sei;
            EntityType entitytype;
            Entity entity;
            ItemStack itemstack = contents.getItem(i);
            Item item = itemstack.getItem();
            if (item instanceof SpawnEggItem && (entity = (entitytype = (sei = (SpawnEggItem)item).getType(itemstack)).spawn(level, itemstack, null, this.blockPosition(), EntitySpawnReason.SPAWN_ITEM_USE, false, false)) != null) {
                itemstack.shrink(1);
            }
            if (itemstack.isEmpty()) continue;
            ItemEntity entityIn = new ItemEntity((Level)level, this.getX(), this.getY(), this.getZ(), itemstack);
            level.addFreshEntity((Entity)entityIn);
        }
    }

    protected void readAdditionalSaveData(ValueInput view) {
        super.readAdditionalSaveData(view);
        this.box = view.read("Box", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.refreshDimensions();
    }

    protected void addAdditionalSaveData(ValueOutput view) {
        super.addAdditionalSaveData(view);
        if (!this.box.isEmpty()) {
            view.store("Box", ItemStack.CODEC, (Object)this.box);
        }
    }

    public ItemStack getItemBySlot(EquipmentSlot pSlot) {
        if (pSlot == EquipmentSlot.MAINHAND) {
            return this.getBox();
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot pSlot, ItemStack pStack) {
        if (pSlot == EquipmentSlot.MAINHAND) {
            this.setBox(pStack);
        }
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public InteractionHand getUsedItemHand() {
        return InteractionHand.MAIN_HAND;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new PackageSpawnPacket(this, entityTrackerEntry);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        PackageSpawnPacket spawnPacket = (PackageSpawnPacket)packet;
        this.setBox(spawnPacket.getBox());
    }

    public float getVoicePitch() {
        return 1.5f;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.CHISELED_BOOKSHELF_FALL, SoundEvents.CHISELED_BOOKSHELF_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return null;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean fireImmune() {
        return this.box.has(DataComponents.DAMAGE_RESISTANT) || super.fireImmune();
    }
}

