/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.box;

import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PackageStyles {
    public static final List<PackageItem> ALL_BOXES = new ArrayList<PackageItem>();
    public static final List<PackageItem> STANDARD_BOXES = new ArrayList<PackageItem>();
    public static final List<PackageItem> RARE_BOXES = new ArrayList<PackageItem>();
    private static final Random STYLE_PICKER = new Random();
    private static final int RARE_CHANCE = 7500;

    public static ItemStack getRandomBox() {
        List<PackageItem> pool = STYLE_PICKER.nextInt(7500) == 0 ? RARE_BOXES : STANDARD_BOXES;
        return new ItemStack((ItemLike)pool.get(STYLE_PICKER.nextInt(pool.size())));
    }

    public static ItemStack getDefaultBox() {
        return new ItemStack((ItemLike)ALL_BOXES.getFirst());
    }

    private static PackageStyle rare(String name) {
        return new PackageStyle("rare_" + name, 12, 10, 21.0f, true);
    }

    public record PackageStyle(String namespace, String type, int width, int height, float riggingOffset, boolean rare) {
        public PackageStyle(String type, int width, int height, float riggingOffset, boolean rare) {
            this("create", type, width, height, riggingOffset, rare);
        }

        public Identifier getItemId() {
            String size = "_" + this.width + "x" + this.height;
            String id = this.type + "_package" + (String)(this.rare ? "" : size);
            return Identifier.fromNamespaceAndPath((String)this.namespace, (String)id);
        }

        public Identifier getModel() {
            if (this.type.equals("cardboard")) {
                return Identifier.fromNamespaceAndPath((String)this.namespace, (String)("item/package/cardboard_" + this.width + "x" + this.height));
            }
            return this.getItemId().withPrefix("item/");
        }

        public Identifier getRiggingModel() {
            String size = this.width + "x" + this.height;
            return Identifier.fromNamespaceAndPath((String)this.namespace, (String)("item/package/rigging_" + size));
        }
    }
}

