/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.s2c.EjectorItemSpawnPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class EjectorItemEntity
extends ItemEntity {
    private boolean alive;
    public EntityLauncher launcher;
    public Direction direction;
    @Nullable
    public Pair<Vec3, BlockPos> earlyTarget;
    public float earlyTargetTime;
    public int progress;
    public RenderData data;

    public EjectorItemEntity(Level world, EjectorBlockEntity ejector, ItemStack stack) {
        super(AllEntityTypes.EJECTOR_ITEM, world);
        BlockPos pos = ejector.getBlockPos();
        this.setPos((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
        this.setItem(stack);
        if (this.level().isClientSide()) {
            this.data = new RenderData();
        }
        this.loadLauncher(ejector);
    }

    public EjectorItemEntity(EntityType<? extends EjectorItemEntity> type, Level world) {
        super(type, world);
        if (this.level().isClientSide()) {
            this.data = new RenderData();
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new EjectorItemSpawnPacket(this, entityTrackerEntry);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        EjectorItemSpawnPacket spawnPacket = (EjectorItemSpawnPacket)packet;
        this.alive = spawnPacket.getAlive();
        this.progress = spawnPacket.getProgress();
        if (!this.alive) {
            BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
            if (blockEntity instanceof EjectorBlockEntity) {
                EjectorBlockEntity ejector = (EjectorBlockEntity)blockEntity;
                this.loadLauncher(ejector);
                return;
            }
            if (spawnPacket.hasLauncher()) {
                this.launcher = spawnPacket.getLauncher();
                this.direction = spawnPacket.getDirection();
                this.data.calcRotate(this.direction.getOpposite());
            } else {
                this.alive = true;
            }
        }
    }

    private void loadLauncher(EjectorBlockEntity ejector) {
        this.launcher = ejector.launcher;
        Direction facing = ejector.getFacing();
        this.direction = facing.getOpposite();
        if (this.level().isClientSide()) {
            this.data.calcRotate(facing);
        }
    }

    public void addAdditionalSaveData(ValueOutput view) {
        view.putBoolean("Alive", this.alive);
        view.putInt("Progress", this.progress);
        if (!this.alive && !(this.level().getBlockEntity(this.blockPosition()) instanceof EjectorBlockEntity)) {
            view.store("Launcher", EntityLauncher.CODEC, (Object)this.launcher);
            view.store("Direction", (Codec)Direction.CODEC, (Object)this.direction);
        }
        super.addAdditionalSaveData(view);
    }

    public void readAdditionalSaveData(ValueInput view) {
        this.alive = view.getBooleanOr("Alive", false);
        this.progress = view.getIntOr("Progress", 0);
        if (!this.alive) {
            BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
            if (blockEntity instanceof EjectorBlockEntity) {
                EjectorBlockEntity ejector = (EjectorBlockEntity)blockEntity;
                this.loadLauncher(ejector);
            } else {
                view.read("Launcher", EntityLauncher.CODEC).ifPresentOrElse(this::setLauncher, this::setIsAlive);
                view.read("Direction", (Codec)Direction.CODEC).ifPresentOrElse(this::setDirection, this::setIsAlive);
                if (!this.alive && this.direction != null && this.level().isClientSide()) {
                    this.data.calcRotate(this.direction.getOpposite());
                }
            }
        }
        super.readAdditionalSaveData(view);
    }

    private void setLauncher(EntityLauncher launcher) {
        this.launcher = launcher;
    }

    private void setDirection(Direction direction) {
        this.direction = direction;
    }

    private void setIsAlive() {
        this.alive = true;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void playerTouch(Player player) {
        if (this.alive) {
            super.playerTouch(player);
        }
    }

    public void tick() {
        boolean isClient = this.level().isClientSide();
        if (this.alive) {
            if (isClient) {
                this.data.tick();
            }
            super.tick();
            return;
        }
        boolean hit = this.scanTrajectoryForObstacles(isClient, this.progress + 1);
        float totalTime = Math.max(3.0f, (float)this.launcher.getTotalFlyingTicks());
        if (hit) {
            this.placeItemAtTarget(isClient, Math.min(this.earlyTargetTime, totalTime));
            return;
        }
        if ((float)(this.progress + 2) >= totalTime) {
            if (isClient) {
                this.data.calcAnimateOffset(totalTime);
            }
            this.placeItemAtTarget(isClient, totalTime);
            return;
        }
        ++this.progress;
    }

    private void placeItemAtTarget(boolean isClient, float maxTime) {
        DirectBeltInputBehaviour targetOpenInv = this.getTargetOpenInv();
        if (targetOpenInv != null) {
            ItemStack remainder = targetOpenInv.handleInsertion(this.getItem(), Direction.UP, isClient);
            if (remainder.isEmpty()) {
                this.discard();
                return;
            }
            this.setItem(remainder);
        }
        this.alive = true;
        Vec3 ejectVec = this.earlyTarget != null ? this.earlyTarget.getFirst() : this.getLaunchedItemLocation(maxTime);
        Vec3 ejectMotionVec = this.getLaunchedItemMotion(maxTime);
        this.setPos(ejectVec.x, ejectVec.y, ejectVec.z);
        this.setOldPos();
        this.setDeltaMovement(ejectMotionVec);
    }

    private DirectBeltInputBehaviour getTargetOpenInv() {
        BlockPos targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.blockPosition().above(this.launcher.getVerticalDistance()).relative(this.getNearestViewDirection(), Math.max(1, this.launcher.getHorizontalDistance()));
        return BlockEntityBehaviour.get((BlockGetter)this.level(), targetPos, DirectBeltInputBehaviour.TYPE);
    }

    private boolean scanTrajectoryForObstacles(boolean isClient, float time) {
        BlockState blockState;
        Level world;
        BlockHitResult rayTraceBlocks;
        boolean miss;
        Vec3 source = this.getLaunchedItemLocation(time);
        Vec3 target = this.getLaunchedItemLocation(time + 1.0f);
        if (isClient) {
            this.data.calcRenderBox(source, target);
        }
        boolean bl = miss = (rayTraceBlocks = (world = this.level()).clip(new ClipContext(source, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType() == HitResult.Type.MISS;
        if (!miss && rayTraceBlocks.getType() == HitResult.Type.BLOCK && FunnelBlock.isFunnel(blockState = world.getBlockState(rayTraceBlocks.getBlockPos())) && blockState.hasProperty((Property)FunnelBlock.EXTRACTING) && ((Boolean)blockState.getValue((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            miss = true;
        }
        if (miss) {
            if (this.earlyTarget != null && this.earlyTargetTime < time + 1.0f) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        Vec3 vec = rayTraceBlocks.getLocation();
        this.earlyTarget = Pair.of(vec.add(Vec3.atLowerCornerOf((Vec3i)rayTraceBlocks.getDirection().getUnitVec3i()).scale(0.25)), rayTraceBlocks.getBlockPos());
        this.earlyTargetTime = (float)((double)time + source.distanceTo(vec) / source.distanceTo(target));
        return true;
    }

    public Vec3 getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos((double)time, this.direction, this.position());
    }

    public Vec3 getLaunchedItemMotion(float time) {
        return this.launcher.getGlobalVelocity(time, this.direction).scale(0.5);
    }

    public void moveOrInterpolateTo(Vec3 pos, float yaw, float pitch) {
    }

    public class RenderData {
        public float rotateY;
        public AABB renderBox;
        public int initAge;
        public float animateOffset;

        public RenderData() {
            this.renderBox = EjectorItemEntity.this.getBoundingBox();
            this.initAge = -1;
            this.animateOffset = -0.125f;
        }

        public void calcRotate(Direction facing) {
            this.rotateY = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        }

        public void calcRenderBox(Vec3 source, Vec3 target) {
            this.renderBox = new AABB(source.x - 1.0, source.y - 1.0, source.z - 1.0, target.x, target.y, target.z);
        }

        public void calcAnimateOffset(float totalTime) {
            this.animateOffset += (totalTime - (float)EjectorItemEntity.this.progress - 1.0f) / 4.0f;
        }

        public void tick() {
            if (this.initAge == -1) {
                if (EjectorItemEntity.this.onGround()) {
                    this.initAge = EjectorItemEntity.this.tickCount;
                }
            } else if (this.animateOffset < 0.0f) {
                this.animateOffset = Math.min(this.animateOffset + 0.005f, 0.0f);
            }
        }
    }
}

