/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.logistics.filter.AbstractFilterMenu;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AttributeFilterMenu
extends AbstractFilterMenu {
    public AttributeFilterWhitelistMode whitelistMode;
    public List<ItemAttributeEntry> selectedAttributes;

    public AttributeFilterMenu(int id, Inventory inv, ItemStack stack) {
        super(AllMenuTypes.ATTRIBUTE_FILTER, id, inv, stack);
    }

    public void appendSelectedAttribute(ItemAttribute itemAttribute, boolean inverted) {
        this.selectedAttributes.add(new ItemAttributeEntry(itemAttribute, inverted));
    }

    @Override
    protected void init(Inventory inv, ItemStack contentHolder) {
        super.init(inv, contentHolder);
        ItemStack stack = new ItemStack((ItemLike)Items.NAME_TAG);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Selected Tags").withStyle(new ChatFormatting[]{ChatFormatting.RESET, ChatFormatting.BLUE}));
        this.ghostInventory.setItem(1, stack);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 51;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 107;
    }

    @Override
    protected void addFilterSlots() {
        this.addSlot(new Slot((Container)this.ghostInventory, 0, 16, 27));
        this.addSlot(new Slot(this, this.ghostInventory, 1, 16, 62){

            public boolean mayPickup(Player playerIn) {
                return false;
            }
        });
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    @Override
    public void clearContents() {
        this.selectedAttributes.clear();
    }

    @Override
    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == 37) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public boolean canDragTo(Slot slotIn) {
        if (slotIn.index == 37) {
            return false;
        }
        return super.canDragTo(slotIn);
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        if (slotIn.index == 37) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slotIn);
    }

    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index == 37) {
            return ItemStack.EMPTY;
        }
        if (index == 36) {
            this.ghostInventory.setItem(37, ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.getItem(index);
            ItemStack copy = stackToInsert.copy();
            copy.setCount(1);
            this.ghostInventory.setItem(0, copy);
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory(filterItem);
        this.selectedAttributes = new ArrayList<ItemAttributeEntry>();
        this.whitelistMode = (AttributeFilterWhitelistMode)((Object)filterItem.getOrDefault(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)AttributeFilterWhitelistMode.WHITELIST_DISJ));
        List attributes = (List)filterItem.getOrDefault(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, List.of());
        this.selectedAttributes.addAll(attributes);
    }

    @Override
    protected void saveData(ItemStack filterItem) {
        filterItem.set(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)this.whitelistMode);
        ArrayList attributes = new ArrayList();
        this.selectedAttributes.forEach(at -> {
            if (at == null) {
                return;
            }
            attributes.add(new ItemAttributeEntry(at.attribute(), at.inverted()));
        });
        filterItem.set(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, attributes);
        if (attributes.isEmpty() && this.whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ) {
            filterItem.remove(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES);
            filterItem.remove(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE);
        }
    }
}

