/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.itemHatch;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.itemHatch.ItemHatchBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemHatchBlock
extends HorizontalDirectionalBlock
implements IBE<ItemHatchBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final MapCodec<ItemHatchBlock> CODEC = ItemHatchBlock.simpleCodec(ItemHatchBlock::new);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public ItemHatchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{OPEN, FACING, WATERLOGGED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        if (state == null) {
            return state;
        }
        if (pContext.getClickedFace().getAxis().isVertical()) {
            return null;
        }
        return this.withWater((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)pContext.getClickedFace().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), pContext);
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource random) {
        this.updateWater(pLevel, tickView, pState, pPos);
        return pState;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int end;
        boolean depositItemInHand;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (FakePlayerHandler.has((Entity)player)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos.relative((Direction)state.getValue((Property)FACING)));
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        Container targetInv = ItemHelper.getInventory(level, blockEntity.getBlockPos(), null, blockEntity, null);
        if (targetInv == null) {
            return InteractionResult.FAIL;
        }
        ServerFilteringBehaviour filter = BlockEntityBehaviour.get((BlockGetter)level, pos, ServerFilteringBehaviour.TYPE);
        if (filter == null) {
            return InteractionResult.FAIL;
        }
        Inventory inventory = player.getInventory();
        boolean anyInserted = false;
        boolean bl = depositItemInHand = !player.isShiftKeyDown();
        if (!depositItemInHand && stack.is(AllItemTags.TOOLS_WRENCH)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (depositItemInHand) {
            start = end = inventory.getSelectedSlot();
        } else {
            start = Inventory.getSelectionSize();
            end = 35;
        }
        for (int i = start; i <= end; ++i) {
            int count;
            int insert;
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty() || !item.getItem().canFitInsideContainerItems() && !PackageItem.isPackage(item) || !filter.getFilter().isEmpty() && !filter.test(item) || (insert = targetInv.insertExist(item, count = item.getCount())) == 0) continue;
            anyInserted = true;
            if (insert == count) {
                inventory.setItem(i, ItemStack.EMPTY);
                continue;
            }
            inventory.setItem(i, item.copyWithCount(count - insert));
        }
        if (!anyInserted) {
            return InteractionResult.SUCCESS;
        }
        AllSoundEvents.ITEM_HATCH.playOnServer(level, (Vec3i)pos);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)));
        level.scheduleTick(pos, (Block)this, 10);
        player.displayClientMessage((Component)Component.translatable((String)(depositItemInHand ? "create.item_hatch.deposit_item" : "create.item_hatch.deposit_inventory")), true);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.ITEM_HATCH.get(((Direction)pState.getValue((Property)FACING)).getOpposite());
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)OPEN)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public Class<ItemHatchBlockEntity> getBlockEntityClass() {
        return ItemHatchBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ItemHatchBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ITEM_HATCH;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

