/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager;

import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PackagerItemHandler
implements SidedItemInventory {
    private final int[] SLOTS = new int[]{0};
    private final PackagerBlockEntity blockEntity;

    public PackagerItemHandler(PackagerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public int[] getSlotsForFace(Direction side) {
        return this.SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.blockEntity.heldBox.isEmpty() && this.blockEntity.queuedExitingPackages.isEmpty();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return PackageItem.isPackage(stack) && this.blockEntity.unwrapBox(stack, true);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return this.blockEntity.animationTicks == 0;
    }

    public int getContainerSize() {
        return 1;
    }

    public ItemStack getStack() {
        return this.blockEntity.heldBox;
    }

    public ItemStack getItem(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        return this.blockEntity.heldBox;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        if (stack.isEmpty()) {
            this.blockEntity.heldBox = stack;
        } else {
            this.blockEntity.unwrapBox(stack, false);
            this.blockEntity.triggerStockCheck();
        }
    }

    @Override
    public void setChanged() {
        this.blockEntity.notifyUpdate();
    }
}

