/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.redstoneRequester;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.packet.s2c.RedstoneRequesterEffectPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class RedstoneRequesterBlockEntity
extends StockCheckingBlockEntity
implements MenuProvider {
    public boolean allowPartialRequests = false;
    public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
    public String encodedTargetAdress = "";
    public boolean lastRequestSucceeded;
    protected boolean redstonePowered;

    public RedstoneRequesterBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.REDSTONE_REQUESTER, pos, state);
    }

    protected void onRedstonePowerChanged() {
        boolean hasNeighborSignal = this.level.hasNeighborSignal(this.worldPosition);
        if (this.redstonePowered == hasNeighborSignal) {
            return;
        }
        this.lastRequestSucceeded = false;
        if (hasNeighborSignal) {
            this.triggerRequest();
        }
        this.redstonePowered = hasNeighborSignal;
        this.notifyUpdate();
    }

    public void triggerRequest() {
        if (this.encodedRequest.isEmpty()) {
            return;
        }
        boolean anySucceeded = false;
        InventorySummary summaryOfOrder = new InventorySummary();
        this.encodedRequest.stacks().forEach(summaryOfOrder::add);
        InventorySummary summary = this.getAccurateSummary();
        for (BigItemStack entry : summaryOfOrder.getStacks()) {
            Level level;
            if (summary.getCountOf(entry.stack) >= entry.count) {
                anySucceeded = true;
                continue;
            }
            if (this.allowPartialRequests || !((level = this.level) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().getPlayerList().broadcast(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 32.0, serverLevel.dimension(), (Packet)new RedstoneRequesterEffectPacket(this.worldPosition, false));
            return;
        }
        this.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.REDSTONE, this.encodedRequest, null, this.encodedTargetAdress);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().getPlayerList().broadcast(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 32.0, serverLevel.dimension(), (Packet)new RedstoneRequesterEffectPacket(this.worldPosition, anySucceeded));
        }
        this.lastRequestSucceeded = true;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.redstonePowered = view.getBooleanOr("Powered", false);
        this.lastRequestSucceeded = view.getBooleanOr("Success", false);
        this.allowPartialRequests = view.getBooleanOr("AllowPartial", false);
        this.encodedRequest = view.read("EncodedRequest", PackageOrderWithCrafts.CODEC).orElse(PackageOrderWithCrafts.empty());
        this.encodedTargetAdress = view.getStringOr("EncodedAddress", "");
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        view.putBoolean("AllowPartial", this.allowPartialRequests);
        view.putString("EncodedAddress", this.encodedTargetAdress);
        view.store("EncodedRequest", PackageOrderWithCrafts.CODEC, (Object)this.encodedRequest);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putBoolean("Powered", this.redstonePowered);
        view.putBoolean("Success", this.lastRequestSucceeded);
        view.putBoolean("AllowPartial", this.allowPartialRequests);
        view.putString("EncodedAddress", this.encodedTargetAdress);
        view.store("EncodedRequest", PackageOrderWithCrafts.CODEC, (Object)this.encodedRequest);
    }

    public InteractionResult use(Player player) {
        if (player == null || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (FakePlayerHandler.has((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (this.level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.behaviour.mayInteractMessage(player)) {
            return InteractionResult.SUCCESS;
        }
        this.openHandledScreen((ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    @Override
    public Component getDisplayName() {
        return Component.empty();
    }

    public RedstoneRequesterMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer, RegistryFriendlyByteBuf extraData) {
        extraData.writeBlockPos(this.worldPosition);
        return new RedstoneRequesterMenu(pContainerId, pPlayerInventory, this);
    }

    public void playEffect(boolean success) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)this.worldPosition);
        if (success) {
            AllSoundEvents.CONFIRM.playAt(this.level, (Vec3i)this.worldPosition, 0.5f, 1.5f, false);
            AllSoundEvents.STOCK_LINK.playAt(this.level, (Vec3i)this.worldPosition, 1.0f, 1.0f, false);
            this.level.addParticle((ParticleOptions)AllParticleTypes.WIFI, vec3.x, vec3.y, vec3.z, 1.0, 1.0, 1.0);
        } else {
            AllSoundEvents.DENY.playAt(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f, false);
            this.level.addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, vec3.x, vec3.y + 1.0, vec3.z, 0.0, 0.0, 0.0);
        }
    }
}

