/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.recipe;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum HeatCondition implements StringRepresentable
{
    NONE(-1),
    HEATED(-1539328),
    SUPERHEATED(-10710040);

    private final int color;
    public static final Codec<HeatCondition> CODEC;
    public static final StreamCodec<ByteBuf, HeatCondition> PACKET_CODEC;

    private HeatCondition(int color) {
        this.color = color;
    }

    public boolean testBlazeBurner(BlazeBurnerBlock.HeatLevel level) {
        if (this == SUPERHEATED) {
            return level == BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        if (this == HEATED) {
            return level != BlazeBurnerBlock.HeatLevel.NONE && level != BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return true;
    }

    public BlazeBurnerBlock.HeatLevel visualizeAsBlazeBurner() {
        if (this == SUPERHEATED) {
            return BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        if (this == HEATED) {
            return BlazeBurnerBlock.HeatLevel.KINDLED;
        }
        return BlazeBurnerBlock.HeatLevel.NONE;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getTranslationKey() {
        return "recipe.heat_requirement." + this.getSerializedName();
    }

    public int getColor() {
        return this.color;
    }

    static {
        CODEC = StringRepresentable.fromEnum(HeatCondition::values);
        PACKET_CODEC = CatnipStreamCodecBuilders.ofEnum(HeatCondition.class);
    }
}

