/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class RedstoneLinkBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private ServerLinkBehaviour link;
    private boolean transmitter;
    public FactoryPanelSupportBehaviour panelSupport;

    public RedstoneLinkBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.REDSTONE_LINK, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.panelSupport = new FactoryPanelSupportBehaviour(this, () -> this.link != null && this.link.isListening(), () -> this.receivedSignal > 0, () -> AllBlocks.REDSTONE_LINK.updateTransmittedSignal(this.getBlockState(), this.level, this.worldPosition));
        behaviours.add(this.panelSupport);
    }

    @Override
    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        this.link = this.transmitter ? ServerLinkBehaviour.transmitter(this, this::getSignal) : ServerLinkBehaviour.receiver(this, this::setSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int power) {
        if (this.receivedSignal != power) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = power;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putBoolean("Transmitter", this.transmitter);
        view.putInt("Receive", this.getReceivedSignal());
        view.putBoolean("ReceivedChanged", this.receivedSignalChanged);
        view.putInt("Transmit", this.transmittedSignal);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.transmitter = view.getBooleanOr("Transmitter", false);
        super.read(view, clientPacket);
        this.receivedSignal = view.getIntOr("Receive", 0);
        this.receivedSignalChanged = view.getBooleanOr("ReceivedChanged", false);
        if (this.level == null || this.level.isClientSide() || !this.link.newPosition) {
            this.transmittedSignal = view.getIntOr("Transmit", 0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            ServerLinkBehaviour prevlink = this.link;
            this.removeBehaviour(ServerLinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.REDSTONE_LINK)) {
            return;
        }
        if (this.getReceivedSignal() > 0 != (Boolean)blockState.getValue((Property)RedstoneLinkBlock.POWERED)) {
            this.receivedSignalChanged = true;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.cycle((Property)RedstoneLinkBlock.POWERED));
        }
        if (this.receivedSignalChanged) {
            this.updateSelfAndAttached(blockState);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.updateSelfAndAttached(this.getBlockState());
    }

    public void updateSelfAndAttached(BlockState blockState) {
        Direction attachedFace = ((Direction)blockState.getValue((Property)RedstoneLinkBlock.FACING)).getOpposite();
        BlockPos attachedPos = this.worldPosition.relative(attachedFace);
        this.level.updateNeighborsAt(this.worldPosition, this.level.getBlockState(this.worldPosition).getBlock());
        this.level.updateNeighborsAt(attachedPos, this.level.getBlockState(attachedPos).getBlock());
        this.receivedSignalChanged = false;
        this.panelSupport.notifyPanels();
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.getBlockState().getValue((Property)RedstoneLinkBlock.RECEIVER) == false;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }
}

