/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.minecart.TrainCargoManager;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.CarriageEntityHandler;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class Carriage {
    public static final StreamCodec<RegistryFriendlyByteBuf, Carriage> STREAM_CODEC = StreamCodec.composite(CarriageBogey.STREAM_CODEC, carriage -> (CarriageBogey)carriage.bogeys.getFirst(), CatnipStreamCodecBuilders.nullable(CarriageBogey.STREAM_CODEC), carriage -> (CarriageBogey)carriage.bogeys.getSecond(), (StreamCodec)ByteBufCodecs.VAR_INT, carriage -> carriage.bogeySpacing, Carriage::new);
    public static final AtomicInteger netIdGenerator = new AtomicInteger();
    public Train train;
    public int id;
    public boolean blocked;
    public boolean stalled;
    public Couple<Boolean> presentConductors;
    public int bogeySpacing;
    public Couple<CarriageBogey> bogeys;
    public TrainCargoManager storage;
    CompoundTag serialisedEntity;
    Map<Integer, CompoundTag> serialisedPassengers;
    private Map<ResourceKey<Level>, DimensionalCarriageEntity> entities;
    static final int FIRST = 0;
    static final int MIDDLE = 1;
    static final int LAST = 2;
    static final int BOTH = 3;
    private Set<ResourceKey<Level>> currentlyTraversedDimensions = new HashSet<ResourceKey<Level>>();
    private TravellingPoint portalScout = new TravellingPoint();

    public Carriage(CarriageBogey bogey1, @Nullable CarriageBogey bogey2, int bogeySpacing) {
        this.bogeySpacing = bogeySpacing;
        this.bogeys = Couple.create(bogey1, bogey2);
        this.id = netIdGenerator.incrementAndGet();
        this.serialisedEntity = new CompoundTag();
        this.presentConductors = Couple.create(false, false);
        this.serialisedPassengers = new HashMap<Integer, CompoundTag>();
        this.entities = new HashMap<ResourceKey<Level>, DimensionalCarriageEntity>();
        this.storage = new TrainCargoManager();
        bogey1.setLeading();
        bogey1.carriage = this;
        if (bogey2 != null) {
            bogey2.carriage = this;
        }
    }

    public boolean isOnIncompatibleTrack() {
        return this.leadingBogey().type.isOnIncompatibleTrack(this, true) || this.trailingBogey().type.isOnIncompatibleTrack(this, false);
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public boolean presentInMultipleDimensions() {
        return this.entities.size() > 1;
    }

    public List<ResourceKey<Level>> getPresentDimensions() {
        return this.entities.keySet().stream().distinct().toList();
    }

    public Optional<BlockPos> getPositionInDimension(ResourceKey<Level> dimension) {
        return Optional.ofNullable(this.entities.get(dimension)).map(carriage -> BlockPos.containing((Position)carriage.positionAnchor));
    }

    public void setContraption(Level level, CarriageContraption contraption) {
        this.storage = null;
        CarriageContraptionEntity entity = CarriageContraptionEntity.create(level, contraption);
        entity.setCarriage(this);
        contraption.startMoving(level);
        contraption.onEntityInitialize(level, entity);
        this.updateContraptionAnchors();
        DimensionalCarriageEntity dimensional = this.getDimensional(level);
        dimensional.alignEntity(entity);
        dimensional.removeAndSaveEntity(entity, true);
    }

    public DimensionalCarriageEntity getDimensional(Level level) {
        return this.getDimensional((ResourceKey<Level>)level.dimension());
    }

    public DimensionalCarriageEntity getDimensional(ResourceKey<Level> dimension) {
        return this.entities.computeIfAbsent(dimension, $ -> new DimensionalCarriageEntity());
    }

    @Nullable
    public DimensionalCarriageEntity getDimensionalIfPresent(ResourceKey<Level> dimension) {
        return this.entities.get(dimension);
    }

    public double travel(Level level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type) {
        Function<TravellingPoint, TravellingPoint.ITrackSelector> forwardControl;
        Function<TravellingPoint, TravellingPoint.ITrackSelector> function = toFollowForward == null ? this.train.navigation::control : (forwardControl = mp -> mp.follow(toFollowForward));
        Function<TravellingPoint, TravellingPoint.ITrackSelector> backwardControl = toFollowBackward == null ? this.train.navigation::control : mp -> mp.follow(toFollowBackward);
        boolean onTwoBogeys = this.isOnTwoBogeys();
        double stress = this.train.derailed ? 0.0 : (onTwoBogeys ? (double)this.bogeySpacing - this.getAnchorDiff() : 0.0);
        this.blocked = false;
        MutableDouble distanceMoved = new MutableDouble(distance);
        boolean iterateFromBack = distance < 0.0;
        for (boolean firstBogey : Iterate.trueAndFalse) {
            if (!firstBogey && !onTwoBogeys) continue;
            boolean actuallyFirstBogey = !onTwoBogeys || firstBogey ^ iterateFromBack;
            CarriageBogey bogey = this.bogeys.get(actuallyFirstBogey);
            double bogeyCorrection = stress * (actuallyFirstBogey ? 0.5 : -0.5);
            double bogeyStress = bogey.getStress();
            for (boolean firstWheel : Iterate.trueAndFalse) {
                TravellingPoint.ITrackSelector trackSelector;
                TravellingPoint prevPoint;
                boolean actuallyFirstWheel = firstWheel ^ iterateFromBack;
                TravellingPoint point = bogey.points.get(actuallyFirstWheel);
                TravellingPoint travellingPoint = !actuallyFirstWheel ? (TravellingPoint)bogey.points.getFirst() : (prevPoint = !actuallyFirstBogey && onTwoBogeys ? (TravellingPoint)((CarriageBogey)this.bogeys.getFirst()).points.getSecond() : null);
                TravellingPoint nextPoint = actuallyFirstWheel ? (TravellingPoint)bogey.points.getSecond() : (actuallyFirstBogey && onTwoBogeys ? (TravellingPoint)((CarriageBogey)this.bogeys.getSecond()).points.getFirst() : null);
                double correction = bogeyStress * (actuallyFirstWheel ? 0.5 : -0.5);
                double toMove = distanceMoved.getValue();
                TravellingPoint.ITrackSelector frontTrackSelector = prevPoint == null ? forwardControl.apply(point) : point.follow(prevPoint);
                TravellingPoint.ITrackSelector backTrackSelector = nextPoint == null ? backwardControl.apply(point) : point.follow(nextPoint);
                boolean atFront = (type == 0 || type == 3) && actuallyFirstWheel && actuallyFirstBogey;
                boolean atBack = !(type != 2 && type != 3 || actuallyFirstWheel || actuallyFirstBogey && onTwoBogeys);
                TravellingPoint.IEdgePointListener frontListener = this.train.frontSignalListener();
                TravellingPoint.IEdgePointListener backListener = this.train.backSignalListener();
                TravellingPoint.IEdgePointListener passiveListener = point.ignoreEdgePoints();
                TravellingPoint.ITrackSelector iTrackSelector = trackSelector = (toMove += correction + bogeyCorrection) > 0.0 ? frontTrackSelector : backTrackSelector;
                TravellingPoint.IEdgePointListener signalListener = toMove > 0.0 ? (atFront ? frontListener : (atBack ? backListener : passiveListener)) : (atFront ? backListener : (atBack ? frontListener : passiveListener));
                double moved = point.travel(graph, toMove, trackSelector, signalListener, point.ignoreTurns(), c -> {
                    for (DimensionalCarriageEntity dce : this.entities.values()) {
                        if (!c.either(tnl -> tnl.equalsIgnoreDim((Object)dce.pivot))) continue;
                        return false;
                    }
                    if (this.entities.size() > 1) {
                        this.train.status.doublePortal();
                        return true;
                    }
                    return false;
                });
                this.blocked |= point.blocked;
                distanceMoved.setValue(moved);
            }
        }
        this.updateContraptionAnchors();
        this.manageEntities(level);
        return distanceMoved.getValue();
    }

    public double getAnchorDiff() {
        double diff = 0.0;
        int entries = 0;
        TravellingPoint leadingPoint = this.getLeadingPoint();
        TravellingPoint trailingPoint = this.getTrailingPoint();
        if (leadingPoint.node1 != null && trailingPoint.node1 != null && !leadingPoint.node1.getLocation().dimension.equals(trailingPoint.node1.getLocation().dimension)) {
            return this.bogeySpacing;
        }
        for (DimensionalCarriageEntity dce : this.entities.values()) {
            if (dce.leadingAnchor() == null || dce.trailingAnchor() == null) continue;
            ++entries;
            diff += dce.leadingAnchor().distanceTo(dce.trailingAnchor());
        }
        if (entries == 0) {
            return this.bogeySpacing;
        }
        return diff / (double)entries;
    }

    public void updateConductors() {
        if (this.anyAvailableEntity() == null || this.entities.size() > 1 || this.serialisedPassengers.size() > 0) {
            return;
        }
        this.presentConductors.replace($ -> false);
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null || !entity.isAlive()) continue;
            this.presentConductors.replaceWithParams((current, checked) -> current != false || checked != false, entity.checkConductors());
        }
    }

    public void manageEntities(Level level) {
        this.currentlyTraversedDimensions.clear();
        this.bogeys.forEach(cb -> {
            if (cb == null) {
                return;
            }
            cb.points.forEach(tp -> {
                if (tp.node1 == null) {
                    return;
                }
                this.currentlyTraversedDimensions.add(tp.node1.getLocation().dimension);
            });
        });
        Iterator<Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            CarriageContraptionEntity entity;
            DimensionalCarriageEntity dimensionalCarriageEntity;
            block6: {
                boolean discard;
                block4: {
                    ServerLevel currentLevel;
                    block5: {
                        Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity> entry = iterator.next();
                        boolean bl = discard = !this.currentlyTraversedDimensions.isEmpty() && !this.currentlyTraversedDimensions.contains(entry.getKey());
                        MinecraftServer server = level.getServer();
                        if (server == null || (currentLevel = server.getLevel(entry.getKey())) == null) continue;
                        dimensionalCarriageEntity = entry.getValue();
                        entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
                        if (entity != null) break block4;
                        if (!discard) break block5;
                        iterator.remove();
                        break block6;
                    }
                    if (dimensionalCarriageEntity.positionAnchor == null || !CarriageEntityHandler.isActiveChunk((Level)currentLevel, BlockPos.containing((Position)dimensionalCarriageEntity.positionAnchor))) break block6;
                    dimensionalCarriageEntity.createEntity((Level)currentLevel, this.anyAvailableEntity() == null);
                    break block6;
                }
                if (discard) {
                    discard = dimensionalCarriageEntity.discardTicks > 3;
                    ++dimensionalCarriageEntity.discardTicks;
                } else {
                    dimensionalCarriageEntity.discardTicks = 0;
                }
                CarriageEntityHandler.validateCarriageEntity(entity);
                if (!entity.isAlive() || entity.leftTickingChunks || discard) {
                    dimensionalCarriageEntity.removeAndSaveEntity(entity, discard);
                    if (!discard) continue;
                    iterator.remove();
                    continue;
                }
            }
            if ((entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get())) == null || dimensionalCarriageEntity.positionAnchor == null) continue;
            dimensionalCarriageEntity.alignEntity(entity);
            entity.syncCarriage();
        }
    }

    public void updateContraptionAnchors() {
        CarriageBogey leadingBogey = this.leadingBogey();
        if (leadingBogey.points.either(t -> t.edge == null)) {
            return;
        }
        CarriageBogey trailingBogey = this.trailingBogey();
        if (trailingBogey.points.either(t -> t.edge == null)) {
            return;
        }
        ResourceKey<Level> leadingBogeyDim = leadingBogey.getDimension();
        ResourceKey<Level> trailingBogeyDim = trailingBogey.getDimension();
        double leadingWheelSpacing = leadingBogey.type.getWheelPointSpacing();
        double trailingWheelSpacing = trailingBogey.type.getWheelPointSpacing();
        boolean leadingUpsideDown = leadingBogey.isUpsideDown();
        boolean trailingUpsideDown = trailingBogey.isUpsideDown();
        for (boolean leading : Iterate.trueAndFalse) {
            TravellingPoint point = leading ? this.getLeadingPoint() : this.getTrailingPoint();
            TravellingPoint otherPoint = !leading ? this.getLeadingPoint() : this.getTrailingPoint();
            ResourceKey<Level> dimension = point.node1.getLocation().dimension;
            ResourceKey<Level> otherDimension = otherPoint.node1.getLocation().dimension;
            if (dimension.equals(otherDimension) && leading) {
                this.getDimensional(dimension).discardPivot();
                continue;
            }
            DimensionalCarriageEntity dce = this.getDimensional(dimension);
            dce.positionAnchor = dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 : (double)this.bogeySpacing + trailingWheelSpacing / 2.0, leadingUpsideDown, trailingUpsideDown);
            boolean backAnchorFlip = trailingBogey.isUpsideDown() ^ leadingBogey.isUpsideDown();
            if (this.isOnTwoBogeys()) {
                dce.rotationAnchors.setFirst(dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 : (double)this.bogeySpacing + trailingWheelSpacing / 2.0, leadingUpsideDown, trailingUpsideDown));
                dce.rotationAnchors.setSecond(dimension.equals(trailingBogeyDim) ? trailingBogey.getAnchorPosition(backAnchorFlip) : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 + (double)this.bogeySpacing : trailingWheelSpacing / 2.0, leadingUpsideDown, trailingUpsideDown));
            } else if (dimension.equals(otherDimension)) {
                dce.rotationAnchors = leadingBogey.points.map(tp -> tp.getPosition(this.train.graph));
            } else {
                dce.rotationAnchors.setFirst(leadingBogey.points.getFirst() == point ? point.getPosition(this.train.graph) : this.pivoted(dce, dimension, point, leadingWheelSpacing, leadingUpsideDown, trailingUpsideDown));
                dce.rotationAnchors.setSecond(leadingBogey.points.getSecond() == point ? point.getPosition(this.train.graph) : this.pivoted(dce, dimension, point, leadingWheelSpacing, leadingUpsideDown, trailingUpsideDown));
            }
            int prevmin = dce.minAllowedLocalCoord();
            int prevmax = dce.maxAllowedLocalCoord();
            dce.updateCutoff(leading);
            if (prevmin == dce.minAllowedLocalCoord() && prevmax == dce.maxAllowedLocalCoord()) continue;
            dce.updateRenderedCutoff();
            dce.updatePassengerLoadout();
        }
    }

    private Vec3 pivoted(DimensionalCarriageEntity dce, ResourceKey<Level> dimension, TravellingPoint start, double offset, boolean leadingUpsideDown, boolean trailingUpsideDown) {
        if (this.train.graph == null) {
            return dce.pivot == null ? null : dce.pivot.getLocation();
        }
        TrackNodeLocation pivot = dce.findPivot(dimension, start == this.getLeadingPoint());
        if (pivot == null) {
            return null;
        }
        boolean flipped = start != this.getLeadingPoint() && leadingUpsideDown != trailingUpsideDown;
        Vec3 startVec = start.getPosition(this.train.graph, flipped);
        Vec3 portalVec = pivot.getLocation().add(0.0, leadingUpsideDown ? -1.0 : 1.0, 0.0);
        return VecHelper.lerp((float)(offset / startVec.distanceTo(portalVec)), startVec, portalVec);
    }

    public void alignEntity(Level level) {
        CarriageContraptionEntity entity;
        DimensionalCarriageEntity dimensionalCarriageEntity = this.entities.get(level.dimension());
        if (dimensionalCarriageEntity != null && (entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get())) != null) {
            dimensionalCarriageEntity.alignEntity(entity);
        }
    }

    public TravellingPoint getLeadingPoint() {
        return this.leadingBogey().leading();
    }

    public TravellingPoint getTrailingPoint() {
        return this.trailingBogey().trailing();
    }

    public CarriageBogey leadingBogey() {
        return (CarriageBogey)this.bogeys.getFirst();
    }

    public CarriageBogey trailingBogey() {
        return this.isOnTwoBogeys() ? (CarriageBogey)this.bogeys.getSecond() : this.leadingBogey();
    }

    public boolean isOnTwoBogeys() {
        return this.bogeys.getSecond() != null;
    }

    public CarriageContraptionEntity anyAvailableEntity() {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public Pair<ResourceKey<Level>, DimensionalCarriageEntity> anyAvailableDimensionalCarriage() {
        for (Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity> entry : this.entities.entrySet()) {
            if (entry.getValue().entity.get() == null) continue;
            return Pair.of(entry.getKey(), entry.getValue());
        }
        return null;
    }

    public void forEachPresentEntity(Consumer<CarriageContraptionEntity> callback) {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            callback.accept(entity);
        }
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        ((CarriageBogey)this.bogeys.getFirst()).write(view.child("FirstBogey"), dimensions);
        if (this.isOnTwoBogeys()) {
            ((CarriageBogey)this.bogeys.getSecond()).write(view.child("SecondBogey"), dimensions);
        }
        view.putInt("Spacing", this.bogeySpacing);
        view.putBoolean("FrontConductor", ((Boolean)this.presentConductors.getFirst()).booleanValue());
        view.putBoolean("BackConductor", ((Boolean)this.presentConductors.getSecond()).booleanValue());
        view.putBoolean("Stalled", this.stalled);
        HashMap<Integer, CompoundTag> passengerMap = new HashMap<Integer, CompoundTag>();
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity2 = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity2 == null) continue;
            this.serialize(entity2);
            Contraption contraption = entity2.getContraption();
            if (contraption == null) continue;
            Map<UUID, Integer> mapping = contraption.getSeatMapping();
            for (Entity passenger : entity2.getPassengers()) {
                if (!mapping.containsKey(passenger.getUUID())) continue;
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(passenger.problemPath(), Create.LOGGER);){
                    TagValueOutput data = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)entity2.registryAccess());
                    if (!passenger.saveAsPassenger((ValueOutput)data)) continue;
                    passengerMap.put(mapping.get(passenger.getUUID()), data.buildResult());
                }
            }
        }
        view.store("Entity", CompoundTag.CODEC, (Object)this.serialisedEntity.copy());
        CompoundTag passengerTag = new CompoundTag();
        passengerMap.putAll(this.serialisedPassengers);
        passengerMap.forEach((seat, nbt) -> passengerTag.put("Seat" + seat, (Tag)nbt.copy()));
        view.store("Passengers", CompoundTag.CODEC, (Object)passengerTag);
        ValueOutput.ValueOutputList list = view.childrenList("EntityPositioning");
        this.entities.forEach((key, entity) -> {
            ValueOutput item = list.addChild();
            entity.write(item);
            item.store("Dim", (Codec)dimensions, key);
        });
    }

    public static <T> DataResult<T> encode(Carriage input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("FirstBogey", CarriageBogey.encode((CarriageBogey)input.bogeys.getFirst(), ops, empty, dimensions));
        if (input.isOnTwoBogeys()) {
            map.add("SecondBogey", CarriageBogey.encode((CarriageBogey)input.bogeys.getSecond(), ops, empty, dimensions));
        }
        map.add("Spacing", ops.createInt(input.bogeySpacing));
        map.add("FrontConductor", ops.createBoolean(((Boolean)input.presentConductors.getFirst()).booleanValue()));
        map.add("BackConductor", ops.createBoolean(((Boolean)input.presentConductors.getSecond()).booleanValue()));
        map.add("Stalled", ops.createBoolean(input.stalled));
        HashMap<Integer, CompoundTag> passengerMap = new HashMap<Integer, CompoundTag>();
        for (DimensionalCarriageEntity dimensionalCarriageEntity : input.entities.values()) {
            CarriageContraptionEntity entity2 = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity2 == null) continue;
            input.serialize(entity2);
            Contraption contraption = entity2.getContraption();
            if (contraption == null) continue;
            Map<UUID, Integer> mapping = contraption.getSeatMapping();
            for (Entity passenger : entity2.getPassengers()) {
                if (!mapping.containsKey(passenger.getUUID())) continue;
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(passenger.problemPath(), Create.LOGGER);){
                    TagValueOutput data = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)entity2.registryAccess());
                    if (!passenger.saveAsPassenger((ValueOutput)data)) continue;
                    passengerMap.put(mapping.get(passenger.getUUID()), data.buildResult());
                }
            }
        }
        map.add("Entity", (Object)input.serialisedEntity.copy(), (Encoder)CompoundTag.CODEC);
        CompoundTag passengerTag = new CompoundTag();
        passengerMap.putAll(input.serialisedPassengers);
        passengerMap.forEach((seat, nbt) -> passengerTag.put("Seat" + seat, (Tag)nbt.copy()));
        map.add("Passengers", (Object)passengerTag, (Encoder)CompoundTag.CODEC);
        ListBuilder list = ops.listBuilder();
        input.entities.forEach((key, entity) -> {
            RecordBuilder item = ops.mapBuilder();
            entity.write(ops, empty, item);
            item.add("Dim", key, (Encoder)dimensions);
            list.add(item.build(empty));
        });
        map.add("EntityPositioning", list.build(empty));
        return map.build(empty);
    }

    private void serialize(Entity entity) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(entity.problemPath(), Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)entity.registryAccess());
            entity.saveAsPassenger((ValueOutput)view);
            this.serialisedEntity = view.buildResult();
            this.serialisedEntity.remove("Passengers");
            this.serialisedEntity.getCompound("Contraption").ifPresent(nbt -> nbt.remove("Passengers"));
        }
    }

    public static Carriage read(ValueInput view, TrackGraph graph, DimensionPalette dimensions) {
        CarriageBogey bogey1 = CarriageBogey.read(view.childOrEmpty("FirstBogey"), graph, dimensions);
        CarriageBogey bogey2 = view.child("SecondBogey").map(bogey -> CarriageBogey.read(bogey, graph, dimensions)).orElse(null);
        Carriage carriage = new Carriage(bogey1, bogey2, view.getIntOr("Spacing", 0));
        carriage.stalled = view.getBooleanOr("Stalled", false);
        carriage.presentConductors = Couple.create(view.getBooleanOr("FrontConductor", false), view.getBooleanOr("BackConductor", false));
        carriage.serialisedEntity = view.read("Entity", CompoundTag.CODEC).orElseGet(CompoundTag::new);
        view.childrenListOrEmpty("EntityPositioning").forEach(item -> carriage.getDimensional((ResourceKey<Level>)((ResourceKey)item.read("Dim", (Codec)dimensions).orElseThrow())).read((ValueInput)item));
        view.read("Passengers", CompoundTag.CODEC).ifPresent(nbt -> nbt.forEach((key, value) -> carriage.serialisedPassengers.put(Integer.valueOf(key.substring(4)), (CompoundTag)value)));
        return carriage;
    }

    public static <T> Carriage decode(DynamicOps<T> ops, T input, TrackGraph graph, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        CarriageBogey bogey1 = CarriageBogey.decode(ops, map.get("FirstBogey"), graph, dimensions);
        CarriageBogey bogey2 = Optional.ofNullable(map.get("SecondBogey")).map(item -> CarriageBogey.decode(ops, item, graph, dimensions)).orElse(null);
        Carriage carriage = new Carriage(bogey1, bogey2, ops.getNumberValue(map.get("Spacing"), (Number)0).intValue());
        carriage.stalled = (Boolean)ops.getBooleanValue(map.get("Stalled")).getOrThrow();
        carriage.presentConductors = Couple.create((Boolean)ops.getBooleanValue(map.get("FrontConductor")).getOrThrow(), (Boolean)ops.getBooleanValue(map.get("BackConductor")).getOrThrow());
        carriage.serialisedEntity = CompoundTag.CODEC.parse(ops, map.get("Entity")).result().orElseGet(CompoundTag::new);
        ((Consumer)ops.getList(map.get("EntityPositioning")).getOrThrow()).accept(item -> {
            MapLike entity = (MapLike)ops.getMap(item).getOrThrow();
            carriage.getDimensional((ResourceKey<Level>)((ResourceKey)dimensions.parse(ops, entity.get("Dim")).getOrThrow())).read(ops, entity);
        });
        CompoundTag.CODEC.parse(ops, map.get("Passengers")).ifSuccess(nbt -> nbt.forEach((key, value) -> carriage.serialisedPassengers.put(Integer.valueOf(key.substring(4)), (CompoundTag)value)));
        return carriage;
    }

    public class DimensionalCarriageEntity {
        public Vec3 positionAnchor;
        public Couple<Vec3> rotationAnchors;
        public WeakReference<CarriageContraptionEntity> entity = new WeakReference<Object>(null);
        public TrackNodeLocation pivot;
        int discardTicks;
        public float cutoff;
        public boolean pointsInitialised = false;

        public DimensionalCarriageEntity() {
            this.rotationAnchors = Couple.create(null, null);
        }

        public void discardPivot() {
            int prevmin = this.minAllowedLocalCoord();
            int prevmax = this.maxAllowedLocalCoord();
            this.cutoff = 0.0f;
            this.pivot = null;
            if (!Carriage.this.serialisedPassengers.isEmpty() && this.entity.get() != null || prevmin != this.minAllowedLocalCoord() || prevmax != this.maxAllowedLocalCoord()) {
                this.updatePassengerLoadout();
                this.updateRenderedCutoff();
            }
        }

        public void updateCutoff(boolean leadingIsCurrent) {
            Vec3 leadingAnchor = (Vec3)this.rotationAnchors.getFirst();
            Vec3 trailingAnchor = (Vec3)this.rotationAnchors.getSecond();
            if (leadingAnchor == null || trailingAnchor == null) {
                return;
            }
            if (this.pivot == null) {
                this.cutoff = 0.0f;
                return;
            }
            Vec3 pivotLoc = this.pivot.getLocation().add(0.0, 1.0, 0.0);
            double leadingSpacing = Carriage.this.leadingBogey().type.getWheelPointSpacing() / 2.0;
            double trailingSpacing = Carriage.this.trailingBogey().type.getWheelPointSpacing() / 2.0;
            double anchorSpacing = leadingSpacing + (double)Carriage.this.bogeySpacing + trailingSpacing;
            if (Carriage.this.isOnTwoBogeys()) {
                Vec3 diff = trailingAnchor.subtract(leadingAnchor).normalize();
                trailingAnchor = trailingAnchor.add(diff.scale(trailingSpacing));
                leadingAnchor = leadingAnchor.add(diff.scale(-leadingSpacing));
            }
            double leadingDiff = leadingAnchor.distanceTo(pivotLoc);
            double trailingDiff = trailingAnchor.distanceTo(pivotLoc);
            this.cutoff = leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1.0 ? 0.0f : (leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1.0 ? 1.0f : (!leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1.0 ? -1.0f : (!leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1.0 ? 0.0f : (float)Mth.clamp((double)(1.0 - (leadingIsCurrent ? (leadingDiff /= anchorSpacing) : (trailingDiff /= anchorSpacing))), (double)0.0, (double)1.0) * (float)(leadingIsCurrent ? 1 : -1))));
        }

        public TrackNodeLocation findPivot(ResourceKey<Level> dimension, boolean leading) {
            if (this.pivot != null) {
                return this.pivot;
            }
            TravellingPoint start = leading ? Carriage.this.getLeadingPoint() : Carriage.this.getTrailingPoint();
            TravellingPoint end = !leading ? Carriage.this.getLeadingPoint() : Carriage.this.getTrailingPoint();
            Carriage.this.portalScout.node1 = start.node1;
            Carriage.this.portalScout.node2 = start.node2;
            Carriage.this.portalScout.edge = start.edge;
            Carriage.this.portalScout.position = start.position;
            TravellingPoint.ITrackSelector trackSelector = Carriage.this.portalScout.follow(end);
            int distance = Carriage.this.bogeySpacing + 10;
            int direction = leading ? -1 : 1;
            Carriage.this.portalScout.travel(Carriage.this.train.graph, direction * distance, trackSelector, Carriage.this.portalScout.ignoreEdgePoints(), Carriage.this.portalScout.ignoreTurns(), nodes -> {
                for (boolean b : Iterate.trueAndFalse) {
                    if (!((TrackNodeLocation)((Object)((Object)nodes.get((boolean)b)))).dimension.equals((Object)dimension)) continue;
                    this.pivot = (TrackNodeLocation)((Object)((Object)nodes.get(b)));
                }
                return true;
            });
            return this.pivot;
        }

        public void write(ValueOutput view) {
            view.putFloat("Cutoff", this.cutoff);
            view.putInt("DiscardTicks", this.discardTicks);
            Carriage.this.storage.write(view, false);
            if (this.pivot != null) {
                this.pivot.write(view.child("Pivot"), null);
            }
            if (this.positionAnchor != null) {
                view.store("PositionAnchor", Vec3.CODEC, (Object)this.positionAnchor);
            }
            if (this.rotationAnchors.both(Objects::nonNull)) {
                ValueOutput.TypedOutputList list = view.list("RotationAnchors", Vec3.CODEC);
                list.add((Object)((Vec3)this.rotationAnchors.getFirst()));
                list.add((Object)((Vec3)this.rotationAnchors.getSecond()));
            }
        }

        public <T> void write(DynamicOps<T> ops, T empty, RecordBuilder<T> map) {
            map.add("Cutoff", ops.createFloat(this.cutoff));
            map.add("DiscardTicks", ops.createInt(this.discardTicks));
            Carriage.this.storage.write(ops, empty, map, false);
            if (this.pivot != null) {
                map.add("Pivot", TrackNodeLocation.encode(this.pivot, ops, empty, null));
            }
            if (this.positionAnchor != null) {
                map.add("PositionAnchor", (Object)this.positionAnchor, (Encoder)Vec3.CODEC);
            }
            if (this.rotationAnchors.both(Objects::nonNull)) {
                ListBuilder list = ops.listBuilder();
                list.add((Object)((Vec3)this.rotationAnchors.getFirst()), (Encoder)Vec3.CODEC);
                list.add((Object)((Vec3)this.rotationAnchors.getSecond()), (Encoder)Vec3.CODEC);
                map.add("RotationAnchors", list.build(empty));
            }
        }

        public void read(ValueInput view) {
            this.cutoff = view.getFloatOr("Cutoff", 0.0f);
            this.discardTicks = view.getIntOr("DiscardTicks", 0);
            Carriage.this.storage.read(view, false, null);
            view.child("Pivot").ifPresent(pivot -> {
                this.pivot = TrackNodeLocation.read(pivot, null);
            });
            if (this.positionAnchor != null) {
                return;
            }
            this.positionAnchor = view.read("PositionAnchor", Vec3.CODEC).orElse(null);
            view.list("RotationAnchors", Vec3.CODEC).ifPresent(list -> {
                Iterator iterator = list.iterator();
                this.rotationAnchors = Couple.create((Vec3)iterator.next(), (Vec3)iterator.next());
            });
        }

        public <T> void read(DynamicOps<T> ops, MapLike<T> map) {
            this.cutoff = ops.getNumberValue(map.get("Cutoff"), (Number)0).floatValue();
            this.discardTicks = ops.getNumberValue(map.get("DiscardTicks"), (Number)0).intValue();
            Carriage.this.storage.read(ops, map, false, null);
            Optional.ofNullable(map.get("Pivot")).ifPresent(pivot -> {
                this.pivot = TrackNodeLocation.decode(ops, pivot, null);
            });
            if (this.positionAnchor != null) {
                return;
            }
            this.positionAnchor = Vec3.CODEC.parse(ops, map.get("PositionAnchor")).result().orElse(null);
            ops.getStream(map.get("RotationAnchors")).ifSuccess(list -> {
                Iterator iterator = list.iterator();
                this.rotationAnchors = Couple.create((Vec3)Vec3.CODEC.parse(ops, iterator.next()).getOrThrow(), (Vec3)Vec3.CODEC.parse(ops, iterator.next()).getOrThrow());
            });
        }

        public Vec3 leadingAnchor() {
            return Carriage.this.isOnTwoBogeys() ? (Vec3)this.rotationAnchors.getFirst() : this.positionAnchor;
        }

        public Vec3 trailingAnchor() {
            return Carriage.this.isOnTwoBogeys() ? (Vec3)this.rotationAnchors.getSecond() : this.positionAnchor;
        }

        public int minAllowedLocalCoord() {
            if (this.cutoff <= 0.0f) {
                return Integer.MIN_VALUE;
            }
            if (this.cutoff >= 1.0f) {
                return Integer.MAX_VALUE;
            }
            return Mth.floor((float)((float)(-Carriage.this.bogeySpacing + -1) + (float)(2 + Carriage.this.bogeySpacing) * this.cutoff));
        }

        public int maxAllowedLocalCoord() {
            if (this.cutoff >= 0.0f) {
                return Integer.MAX_VALUE;
            }
            if (this.cutoff <= -1.0f) {
                return Integer.MIN_VALUE;
            }
            return Mth.ceil((float)((float)(-Carriage.this.bogeySpacing + -1) + (float)(2 + Carriage.this.bogeySpacing) * (this.cutoff + 1.0f)));
        }

        public void updatePassengerLoadout() {
            Entity entity = (Entity)this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Level level = entity.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel sLevel = (ServerLevel)level;
            HashSet<Integer> loadedPassengers = new HashSet<Integer>();
            int min = this.minAllowedLocalCoord();
            int max = this.maxAllowedLocalCoord();
            for (Map.Entry<Integer, CompoundTag> entry : Carriage.this.serialisedPassengers.entrySet()) {
                BlockPos localPos;
                Integer seatId = entry.getKey();
                List<BlockPos> seats = cce.getContraption().getSeats();
                if (seatId >= seats.size() || !cce.isLocalCoordWithin(localPos = seats.get(seatId), min, max)) continue;
                CompoundTag tag = entry.getValue();
                Entity passenger = null;
                if (tag.contains("PlayerPassenger")) {
                    passenger = sLevel.getServer().getPlayerList().getPlayer((UUID)tag.read("PlayerPassenger", UUIDUtil.CODEC).orElse(null));
                } else {
                    passenger = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)entity.level(), (EntitySpawnReason)EntitySpawnReason.LOAD, e -> {
                        e.snapTo(this.positionAnchor);
                        return e;
                    });
                    if (passenger != null) {
                        sLevel.tryAddFreshEntityWithPassengers(passenger);
                    }
                }
                if (passenger != null) {
                    ResourceKey passengerDimension = passenger.level().dimension();
                    if (!passengerDimension.equals(sLevel.dimension()) && passenger instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)passenger;
                        continue;
                    }
                    cce.addSittingPassenger(passenger, seatId);
                }
                loadedPassengers.add(seatId);
            }
            loadedPassengers.forEach(Carriage.this.serialisedPassengers::remove);
            Map<UUID, Integer> mapping = cce.getContraption().getSeatMapping();
            for (Entity passenger : entity.getPassengers()) {
                BlockPos localPos = cce.getContraption().getSeatOf(passenger.getUUID());
                if (cce.isLocalCoordWithin(localPos, min, max) || !mapping.containsKey(passenger.getUUID())) continue;
                Integer seat = mapping.get(passenger.getUUID());
                if (passenger instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)passenger;
                    this.dismountPlayer(sLevel, sp, seat, true);
                    continue;
                }
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(passenger.problemPath(), Create.LOGGER);){
                    TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)entity.registryAccess());
                    passenger.saveAsPassenger((ValueOutput)view);
                    Carriage.this.serialisedPassengers.put(seat, view.buildResult());
                    passenger.discard();
                }
            }
        }

        private void dismountPlayer(ServerLevel sLevel, ServerPlayer sp, Integer seat, boolean capture) {
            if (!capture) {
                sp.stopRiding();
                return;
            }
            CompoundTag tag = new CompoundTag();
            tag.store("PlayerPassenger", UUIDUtil.CODEC, (Object)sp.getUUID());
            Carriage.this.serialisedPassengers.put(seat, tag);
            sp.stopRiding();
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set((Entity)sp, Optional.empty());
            for (Map.Entry<ResourceKey<Level>, DimensionalCarriageEntity> other : Carriage.this.entities.entrySet()) {
                Vec3 loc;
                DimensionalCarriageEntity otherDce = other.getValue();
                if (otherDce == this || sp.level().dimension().equals(other.getKey())) continue;
                Vec3 vec3 = loc = otherDce.pivot == null ? otherDce.positionAnchor : otherDce.pivot.getLocation();
                if (loc == null) continue;
                ServerLevel level = sLevel.getServer().getLevel(other.getKey());
                sp.teleportTo(level, loc.x, loc.y, loc.z, Set.of(), sp.getYRot(), sp.getXRot(), true);
                sp.setPortalCooldown();
                AllAdvancements.TRAIN_PORTAL.trigger(sp);
            }
        }

        public void updateRenderedCutoff() {
            Entity entity = (Entity)this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Contraption contraption = cce.getContraption();
            if (!(contraption instanceof CarriageContraption)) {
                return;
            }
            CarriageContraption cc = (CarriageContraption)contraption;
            cc.portalCutoffMin = this.minAllowedLocalCoord();
            cc.portalCutoffMax = this.maxAllowedLocalCoord();
            if (!entity.level().isClientSide()) {
                return;
            }
            AllClientHandle.INSTANCE.invalidateCarriage(cce);
        }

        private void createEntity(Level level, boolean loadPassengers) {
            if (this.positionAnchor != null) {
                Carriage.this.serialisedEntity.put("Pos", (Tag)VecHelper.writeNBT(this.positionAnchor));
            }
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "Carriage", Create.LOGGER);){
                ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)Carriage.this.serialisedEntity);
                Entity entity = EntityType.create((ValueInput)view, (Level)level, (EntitySpawnReason)EntitySpawnReason.LOAD).orElse(null);
                if (!(entity instanceof CarriageContraptionEntity)) {
                    Carriage.this.train.invalid = true;
                    return;
                }
                CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
                entity.snapTo(this.positionAnchor);
                this.entity = new WeakReference<CarriageContraptionEntity>(cce);
                cce.setCarriage(Carriage.this);
                cce.syncCarriage();
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    sl.addFreshEntity(entity);
                }
                this.updatePassengerLoadout();
            }
        }

        private void removeAndSaveEntity(CarriageContraptionEntity entity, boolean portal) {
            Contraption contraption = entity.getContraption();
            if (contraption != null) {
                Map<UUID, Integer> mapping = contraption.getSeatMapping();
                for (Entity passenger : entity.getPassengers()) {
                    if (!mapping.containsKey(passenger.getUUID())) continue;
                    Integer seat = mapping.get(passenger.getUUID());
                    if (passenger instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)passenger;
                        this.dismountPlayer(sp.level(), sp, seat, portal);
                        continue;
                    }
                    try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(passenger.problemPath(), Create.LOGGER);){
                        TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)entity.registryAccess());
                        passenger.saveAsPassenger((ValueOutput)view);
                        Carriage.this.serialisedPassengers.put(seat, view.buildResult());
                    }
                }
            }
            for (Entity passenger : entity.getPassengers()) {
                if (passenger instanceof Player) continue;
                passenger.discard();
            }
            Carriage.this.serialize(entity);
            entity.discard();
            this.entity.clear();
        }

        public void alignEntity(CarriageContraptionEntity entity) {
            if (this.rotationAnchors.either(Objects::isNull)) {
                return;
            }
            Vec3 positionVec = (Vec3)this.rotationAnchors.getFirst();
            Vec3 coupledVec = (Vec3)this.rotationAnchors.getSecond();
            double diffX = positionVec.x - coupledVec.x;
            double diffY = positionVec.y - coupledVec.y;
            double diffZ = positionVec.z - coupledVec.z;
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
            if (!entity.level().isClientSide()) {
                Vec3 lookahead = this.positionAnchor.add(this.positionAnchor.subtract(entity.position()).normalize().scale(16.0));
                for (Entity e : entity.getPassengers()) {
                    if (!(e instanceof Player) || e.distanceToSqr((Entity)entity) > 1024.0) continue;
                    if (CarriageEntityHandler.isActiveChunk(entity.level(), BlockPos.containing((Position)lookahead))) break;
                    Carriage.this.train.carriageWaitingForChunks = Carriage.this.id;
                    return;
                }
                if (Carriage.this.train.carriageWaitingForChunks == Carriage.this.id) {
                    Carriage.this.train.carriageWaitingForChunks = -1;
                }
                entity.setServerSidePrevPosition();
            }
            entity.setPos(this.positionAnchor);
            entity.yaw = (float)(Mth.atan2((double)diffZ, (double)diffX) * 180.0 / Math.PI) + 180.0f;
            entity.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI) * -1.0f;
            if (!entity.firstPositionUpdate) {
                return;
            }
            entity.xo = entity.getX();
            entity.yo = entity.getY();
            entity.zo = entity.getZ();
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
        }
    }
}

