/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CarriageBogey {
    public static final StreamCodec<RegistryFriendlyByteBuf, CarriageBogey> STREAM_CODEC = StreamCodec.composite(AbstractBogeyBlock.STREAM_CODEC, bogey -> bogey.type, (StreamCodec)ByteBufCodecs.BOOL, bogey -> bogey.upsideDown, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, bogey -> bogey.bogeyData, CarriageBogey::new);
    public static final Random RANDOM = new Random();
    public static final String UPSIDE_DOWN_KEY = "UpsideDown";
    public Carriage carriage;
    public boolean isLeading;
    public CompoundTag bogeyData;
    public AbstractBogeyBlock<?> type;
    boolean upsideDown;
    Couple<TravellingPoint> points;
    public LerpedFloat wheelAngle;
    public LerpedFloat yaw;
    public LerpedFloat pitch;
    public Couple<Vec3> couplingAnchors;
    int derailAngle;

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, CompoundTag bogeyData) {
        this(type, upsideDown, bogeyData, new TravellingPoint(), new TravellingPoint());
    }

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, CompoundTag bogeyData, TravellingPoint point, TravellingPoint point2) {
        this.type = type;
        point.upsideDown = this.upsideDown = type.canBeUpsideDown() && upsideDown;
        point2.upsideDown = this.upsideDown;
        if (bogeyData == null || bogeyData.isEmpty()) {
            bogeyData = this.createBogeyData();
        }
        bogeyData.putBoolean(UPSIDE_DOWN_KEY, upsideDown);
        this.bogeyData = bogeyData;
        this.points = Couple.create(point, point2);
        this.wheelAngle = LerpedFloat.angular();
        this.yaw = LerpedFloat.angular();
        this.pitch = LerpedFloat.angular();
        this.derailAngle = RANDOM.nextInt(60) - 30;
        this.couplingAnchors = Couple.create(null, null);
    }

    public ResourceKey<Level> getDimension() {
        TravellingPoint leading = this.leading();
        TravellingPoint trailing = this.trailing();
        if (leading.edge == null || trailing.edge == null) {
            return null;
        }
        if (leading.edge.isInterDimensional() || trailing.edge.isInterDimensional()) {
            return null;
        }
        ResourceKey<Level> dimension1 = leading.node1.getLocation().dimension;
        ResourceKey<Level> dimension2 = trailing.node1.getLocation().dimension;
        if (dimension1.equals(dimension2)) {
            return dimension1;
        }
        return null;
    }

    public void updateAngles(CarriageContraptionEntity entity, double distanceMoved) {
        double angleDiff = 360.0 * distanceMoved / (Math.PI * 2 * this.type.getWheelRadius());
        float xRot = 0.0f;
        float yRot = 0.0f;
        if (this.leading().edge == null || this.carriage.train.derailed) {
            yRot = -90.0f + entity.yaw - (float)this.derailAngle;
        } else if (!entity.level().dimension().equals(this.getDimension())) {
            yRot = -90.0f + entity.yaw;
            xRot = 0.0f;
        } else {
            Vec3 positionVec = this.leading().getPosition(this.carriage.train.graph);
            Vec3 coupledVec = this.trailing().getPosition(this.carriage.train.graph);
            double diffX = positionVec.x - coupledVec.x;
            double diffY = positionVec.y - coupledVec.y;
            double diffZ = positionVec.z - coupledVec.z;
            yRot = AngleHelper.deg(Mth.atan2((double)diffZ, (double)diffX)) + 90.0f;
            xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
        }
        double newWheelAngle = ((double)this.wheelAngle.getValue() - angleDiff) % 360.0;
        for (boolean twice : Iterate.trueAndFalse) {
            if (twice && !entity.firstPositionUpdate) continue;
            this.wheelAngle.setValue(newWheelAngle);
            this.pitch.setValue(xRot);
            this.yaw.setValue(-yRot);
        }
    }

    public TravellingPoint leading() {
        TravellingPoint point = (TravellingPoint)this.points.getFirst();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public TravellingPoint trailing() {
        TravellingPoint point = (TravellingPoint)this.points.getSecond();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public double getStress() {
        if (this.getDimension() == null) {
            return 0.0;
        }
        if (this.carriage.train.derailed) {
            return 0.0;
        }
        return this.type.getWheelPointSpacing() - this.leading().getPosition(this.carriage.train.graph).distanceTo(this.trailing().getPosition(this.carriage.train.graph));
    }

    @Nullable
    public Vec3 getAnchorPosition() {
        return this.getAnchorPosition(false);
    }

    @Nullable
    public Vec3 getAnchorPosition(boolean flipUpsideDown) {
        if (this.leading().edge == null) {
            return null;
        }
        return ((TravellingPoint)this.points.getFirst()).getPosition(this.carriage.train.graph, flipUpsideDown).add(((TravellingPoint)this.points.getSecond()).getPosition(this.carriage.train.graph, flipUpsideDown)).scale(0.5);
    }

    public void updateCouplingAnchor(Vec3 entityPos, float entityXRot, float entityYRot, int bogeySpacing, float yaw, float pitch, boolean leading) {
        boolean selfUpsideDown = this.isUpsideDown();
        boolean leadingUpsideDown = this.carriage.leadingBogey().isUpsideDown();
        Vec3 thisOffset = this.type.getConnectorAnchorOffset(selfUpsideDown);
        thisOffset = thisOffset.multiply(1.0, 1.0, leading ? -1.0 : 1.0);
        thisOffset = VecHelper.rotate(thisOffset, pitch, Direction.Axis.X);
        thisOffset = VecHelper.rotate(thisOffset, yaw, Direction.Axis.Y);
        thisOffset = VecHelper.rotate(thisOffset, -entityYRot - 90.0f, Direction.Axis.Y);
        thisOffset = VecHelper.rotate(thisOffset, entityXRot, Direction.Axis.X);
        thisOffset = VecHelper.rotate(thisOffset, -180.0, Direction.Axis.Y);
        thisOffset = thisOffset.add(0.0, 0.0, leading ? 0.0 : (double)(-bogeySpacing));
        thisOffset = VecHelper.rotate(thisOffset, 180.0, Direction.Axis.Y);
        thisOffset = VecHelper.rotate(thisOffset, -entityXRot, Direction.Axis.X);
        thisOffset = VecHelper.rotate(thisOffset, entityYRot + 90.0f, Direction.Axis.Y);
        if (selfUpsideDown != leadingUpsideDown) {
            thisOffset = thisOffset.add(0.0, selfUpsideDown ? -2.0 : 2.0, 0.0);
        }
        this.couplingAnchors.set(leading, entityPos.add(thisOffset));
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        view.store("Type", CreateCodecs.BLOCK_CODEC, this.type);
        ValueOutput.ValueOutputList list = view.childrenList("Points");
        ((TravellingPoint)this.points.getFirst()).write(list.addChild(), dimensions);
        ((TravellingPoint)this.points.getSecond()).write(list.addChild(), dimensions);
        view.putBoolean(UPSIDE_DOWN_KEY, this.upsideDown);
        this.bogeyData.putBoolean(UPSIDE_DOWN_KEY, this.upsideDown);
        this.bogeyData.store("BogeyStyle", Identifier.CODEC, (Object)this.getStyle().id);
        view.store("BogeyData", CompoundTag.CODEC, (Object)this.bogeyData);
    }

    public static <T> DataResult<T> encode(CarriageBogey input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Type", input.type, CreateCodecs.BLOCK_CODEC);
        ListBuilder list = ops.listBuilder();
        list.add(TravellingPoint.encode((TravellingPoint)input.points.getFirst(), ops, empty, dimensions));
        list.add(TravellingPoint.encode((TravellingPoint)input.points.getSecond(), ops, empty, dimensions));
        map.add("Points", list.build(empty));
        map.add(UPSIDE_DOWN_KEY, ops.createBoolean(input.upsideDown));
        input.bogeyData.putBoolean(UPSIDE_DOWN_KEY, input.upsideDown);
        input.bogeyData.store("BogeyStyle", Identifier.CODEC, (Object)input.getStyle().id);
        map.add("BogeyData", (Object)input.bogeyData, (Encoder)CompoundTag.CODEC);
        return map.build(empty);
    }

    public static CarriageBogey read(ValueInput view, TrackGraph graph, DimensionPalette dimensions) {
        AbstractBogeyBlock type = (AbstractBogeyBlock)view.read("Type", CreateCodecs.BLOCK_CODEC).orElseThrow();
        boolean upsideDown = view.getBooleanOr(UPSIDE_DOWN_KEY, false);
        Iterator iterator = view.childrenListOrEmpty("Points").iterator();
        TravellingPoint point1 = TravellingPoint.read((ValueInput)iterator.next(), graph, dimensions);
        TravellingPoint point2 = TravellingPoint.read((ValueInput)iterator.next(), graph, dimensions);
        CompoundTag data = (CompoundTag)view.read("BogeyData", CompoundTag.CODEC).orElseThrow();
        return new CarriageBogey(type, upsideDown, data, point1, point2);
    }

    public static <T> CarriageBogey decode(DynamicOps<T> ops, T input, TrackGraph graph, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        AbstractBogeyBlock type = (AbstractBogeyBlock)CreateCodecs.BLOCK_CODEC.parse(ops, map.get("Type")).getOrThrow();
        boolean upsideDown = (Boolean)ops.getBooleanValue(map.get(UPSIDE_DOWN_KEY)).getOrThrow();
        Iterator iterator = ((Stream)ops.getStream(map.get("Points")).getOrThrow()).iterator();
        TravellingPoint point1 = TravellingPoint.decode(ops, iterator.next(), graph, dimensions);
        TravellingPoint point2 = TravellingPoint.decode(ops, iterator.next(), graph, dimensions);
        CompoundTag data = (CompoundTag)CompoundTag.CODEC.parse(ops, map.get("BogeyData")).getOrThrow();
        return new CarriageBogey(type, upsideDown, data, point1, point2);
    }

    public BogeyStyle getStyle() {
        Optional location = this.bogeyData.read("BogeyStyle", Identifier.CODEC);
        if (location.isEmpty()) {
            return AllBogeyStyles.STANDARD;
        }
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(location.get());
        return style != null ? style : AllBogeyStyles.STANDARD;
    }

    public BogeySize getSize() {
        return this.type.getSize();
    }

    private CompoundTag createBogeyData() {
        BogeyStyle style = this.type != null ? this.type.getDefaultStyle() : AllBogeyStyles.STANDARD;
        CompoundTag nbt = style.defaultData != null ? style.defaultData : new CompoundTag();
        nbt.store("BogeyStyle", Identifier.CODEC, (Object)style.id);
        nbt.putBoolean(UPSIDE_DOWN_KEY, this.isUpsideDown());
        return nbt;
    }

    void setLeading() {
        this.isLeading = true;
    }

    public boolean isUpsideDown() {
        return this.type.canBeUpsideDown() && this.upsideDown;
    }
}

