/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DimensionPalette
implements Codec<ResourceKey<Level>> {
    public static final Codec<DimensionPalette> CODEC = ResourceKey.codec((ResourceKey)Registries.DIMENSION).listOf().xmap(DimensionPalette::new, DimensionPalette::getGatheredDims);
    public static final StreamCodec<ByteBuf, DimensionPalette> PACKET_CODEC = ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION).apply(ByteBufCodecs.list()).map(DimensionPalette::new, DimensionPalette::getGatheredDims);
    private final List<ResourceKey<Level>> gatheredDims;

    public DimensionPalette() {
        this.gatheredDims = new ArrayList<ResourceKey<Level>>();
    }

    public DimensionPalette(List<ResourceKey<Level>> gatheredDims) {
        this.gatheredDims = gatheredDims;
    }

    private List<ResourceKey<Level>> getGatheredDims() {
        return this.gatheredDims;
    }

    public int encode(ResourceKey<Level> dimension) {
        int indexOf = this.gatheredDims.indexOf(dimension);
        if (indexOf == -1) {
            indexOf = this.gatheredDims.size();
            this.gatheredDims.add(dimension);
        }
        return indexOf;
    }

    public ResourceKey<Level> decode(int index) {
        if (this.gatheredDims.size() <= index || index < 0) {
            return Level.OVERWORLD;
        }
        return this.gatheredDims.get(index);
    }

    public <T> DataResult<Pair<ResourceKey<Level>, T>> decode(DynamicOps<T> ops, T input) {
        return Codec.INT.decode(ops, input).map(p -> p.mapFirst(this::decode));
    }

    public <T> DataResult<T> encode(ResourceKey<Level> input, DynamicOps<T> ops, T prefix) {
        return Codec.INT.encode((Object)this.encode(input), ops, prefix);
    }
}

