/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TrackEdgeIntersection {
    public double location;
    public Couple<TrackNodeLocation> target;
    public double targetLocation;
    public UUID groupId;
    public UUID id = UUID.randomUUID();

    public boolean isNear(double location) {
        return Math.abs(location - this.location) < 0.03125;
    }

    public boolean targets(TrackNodeLocation target1, TrackNodeLocation target2) {
        return target1.equals(this.target.getFirst()) && target2.equals(this.target.getSecond()) || target1.equals(this.target.getSecond()) && target2.equals(this.target.getFirst());
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        view.store("Id", UUIDUtil.CODEC, (Object)this.id);
        if (this.groupId != null) {
            view.store("GroupId", UUIDUtil.CODEC, (Object)this.groupId);
        }
        view.putDouble("Location", this.location);
        view.putDouble("TargetLocation", this.targetLocation);
        ValueOutput.ValueOutputList edge = view.childrenList("TargetEdge");
        ((TrackNodeLocation)((Object)this.target.getFirst())).write(edge.addChild(), dimensions);
        ((TrackNodeLocation)((Object)this.target.getSecond())).write(edge.addChild(), dimensions);
    }

    public static <T> DataResult<T> encode(TrackEdgeIntersection input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder builder = ops.mapBuilder();
        builder.add("Id", (Object)input.id, (Encoder)UUIDUtil.CODEC);
        if (input.groupId != null) {
            builder.add("GroupId", (Object)input.groupId, (Encoder)UUIDUtil.CODEC);
        }
        builder.add("Location", ops.createDouble(input.location));
        builder.add("TargetLocation", ops.createDouble(input.targetLocation));
        ListBuilder edge = ops.listBuilder();
        edge.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)input.target.getFirst()), ops, empty, dimensions));
        edge.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)input.target.getSecond()), ops, empty, dimensions));
        builder.add("TargetEdge", edge.build(empty));
        return builder.build(empty);
    }

    public static TrackEdgeIntersection read(ValueInput view, DimensionPalette dimensions) {
        TrackEdgeIntersection intersection = new TrackEdgeIntersection();
        intersection.id = (UUID)view.read("Id", UUIDUtil.CODEC).orElseThrow();
        view.read("GroupId", UUIDUtil.CODEC).ifPresent(id -> {
            intersection.groupId = id;
        });
        intersection.location = view.getDoubleOr("Location", 0.0);
        intersection.targetLocation = view.getDoubleOr("TargetLocation", 0.0);
        Iterator edge = view.childrenListOrEmpty("TargetEdge").iterator();
        intersection.target = Couple.create(TrackNodeLocation.read((ValueInput)edge.next(), dimensions), TrackNodeLocation.read((ValueInput)edge.next(), dimensions));
        return intersection;
    }

    public static <T> TrackEdgeIntersection decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        TrackEdgeIntersection intersection = new TrackEdgeIntersection();
        intersection.id = (UUID)((Pair)UUIDUtil.CODEC.decode(ops, map.get("Id")).getOrThrow()).getFirst();
        UUIDUtil.CODEC.decode(ops, map.get("GroupId")).result().map(Pair::getFirst).ifPresent(id -> {
            intersection.groupId = id;
        });
        intersection.location = ops.getNumberValue(map.get("Location"), (Number)0).intValue();
        intersection.targetLocation = ops.getNumberValue(map.get("TargetLocation"), (Number)0).intValue();
        intersection.target = Couple.create(null, null);
        ((Consumer)ops.getList(map.get("TargetEdge")).getOrThrow()).accept(item -> {
            TrackNodeLocation location = TrackNodeLocation.decode(ops, item, dimensions);
            if (intersection.target.getFirst() == null) {
                intersection.target.setFirst(location);
            } else {
                intersection.target.setSecond(location);
            }
        });
        return intersection;
    }
}

