/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class TrackNodeLocation
extends Vec3i {
    private static final Codec<TrackNodeLocation> POS_CODEC = Codec.INT_STREAM.comapFlatMap(stream -> Util.fixedSize((IntStream)stream, (int)3).map(coordinates -> new TrackNodeLocation(coordinates[0], coordinates[1], coordinates[2])), vec -> IntStream.of(vec.getX(), vec.getY(), vec.getZ()));
    public static final StreamCodec<ByteBuf, TrackNodeLocation> POS_PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Vec3i::getX, (StreamCodec)ByteBufCodecs.VAR_INT, Vec3i::getY, (StreamCodec)ByteBufCodecs.VAR_INT, Vec3i::getZ, TrackNodeLocation::new);
    public ResourceKey<Level> dimension;
    public int yOffsetPixels;

    private TrackNodeLocation(int x, int y, int z) {
        super(x, y, z);
    }

    public TrackNodeLocation(Vec3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public TrackNodeLocation(double x, double y, double z) {
        super(Mth.floor((double)Math.round(x * 2.0)), Mth.floor((double)y) * 2, Mth.floor((double)Math.round(z * 2.0)));
    }

    public TrackNodeLocation in(Level level) {
        return this.in((ResourceKey<Level>)level.dimension());
    }

    public TrackNodeLocation in(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        return this;
    }

    private static TrackNodeLocation fromPackedPos(BlockPos bufferPos) {
        return new TrackNodeLocation(bufferPos);
    }

    private TrackNodeLocation(BlockPos readBlockPos) {
        super(readBlockPos.getX(), readBlockPos.getY(), readBlockPos.getZ());
    }

    public Vec3 getLocation() {
        return new Vec3((double)this.getX() / 2.0, (double)this.getY() / 2.0 + (double)this.yOffsetPixels / 16.0, (double)this.getZ() / 2.0);
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object pOther) {
        if (!this.equalsIgnoreDim(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (!Objects.equals(tnl.dimension, this.dimension)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsIgnoreDim(Object pOther) {
        if (!super.equals(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (tnl.yOffsetPixels != this.yOffsetPixels) return false;
        return true;
    }

    public int hashCode() {
        return (this.getY() + ((this.getZ() + this.yOffsetPixels * 31) * 31 + this.dimension.hashCode()) * 31) * 31 + this.getX();
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        view.store("Pos", POS_CODEC, (Object)this);
        if (dimensions != null) {
            view.store("D", (Codec)dimensions, this.dimension);
        }
        if (this.yOffsetPixels != 0) {
            view.putInt("YO", this.yOffsetPixels);
        }
    }

    public static <T> DataResult<T> encode(TrackNodeLocation input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder builder = ops.mapBuilder();
        builder.add("Pos", (Object)input, POS_CODEC);
        if (dimensions != null) {
            builder.add("D", input.dimension, (Encoder)dimensions);
        }
        if (input.yOffsetPixels != 0) {
            builder.add("YO", ops.createInt(input.yOffsetPixels));
        }
        return builder.build(empty);
    }

    public static TrackNodeLocation read(ValueInput view, DimensionPalette dimensions) {
        TrackNodeLocation location = (TrackNodeLocation)((Object)view.read("Pos", POS_CODEC).orElseThrow());
        if (dimensions != null) {
            location.dimension = view.read("D", (Codec)dimensions).orElse(null);
        }
        location.yOffsetPixels = view.getIntOr("YO", 0);
        return location;
    }

    public static <T> TrackNodeLocation decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        TrackNodeLocation location = (TrackNodeLocation)((Object)((Pair)POS_CODEC.decode(ops, map.get("Pos")).getOrThrow()).getFirst());
        if (dimensions != null) {
            location.dimension = dimensions.parse(ops, map.get("D")).result().orElse(null);
        }
        location.yOffsetPixels = Optional.ofNullable(map.get("YO")).map(value -> ((Number)ops.getNumberValue(value).getOrThrow()).intValue()).orElse(0);
        return location;
    }

    public void send(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        buffer.writeVarInt(this.getX());
        buffer.writeShort(this.getY());
        buffer.writeVarInt(this.getZ());
        buffer.writeVarInt(this.yOffsetPixels);
        buffer.writeVarInt(dimensions.encode(this.dimension));
    }

    public static TrackNodeLocation receive(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        TrackNodeLocation location = new TrackNodeLocation(buffer.readVarInt(), buffer.readShort(), buffer.readVarInt());
        location.yOffsetPixels = buffer.readVarInt();
        location.dimension = dimensions.decode(buffer.readVarInt());
        return location;
    }

    public Collection<BlockPos> allAdjacent() {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        Vec3 vec3 = this.getLocation().subtract(0.0, (double)this.yOffsetPixels / 16.0, 0.0);
        double step = 0.125;
        for (int x : Iterate.positiveAndNegative) {
            for (int y : Iterate.positiveAndNegative) {
                for (int z : Iterate.positiveAndNegative) {
                    set.add(BlockPos.containing((Position)vec3.add((double)x * step, (double)y * step, (double)z * step)));
                }
            }
        }
        return set;
    }

    public static class DiscoveredLocation
    extends TrackNodeLocation {
        BezierConnection turn = null;
        boolean forceNode = false;
        Vec3 direction;
        Vec3 normal;
        TrackMaterial materialA;
        TrackMaterial materialB;

        public DiscoveredLocation(Level level, double x, double y, double z) {
            super(x, y, z);
            this.in(level);
        }

        public DiscoveredLocation(ResourceKey<Level> dimension, Vec3 vec) {
            super(vec);
            this.in(dimension);
        }

        public DiscoveredLocation(Level level, Vec3 vec) {
            this((ResourceKey<Level>)level.dimension(), vec);
        }

        public DiscoveredLocation materialA(TrackMaterial material) {
            this.materialA = material;
            return this;
        }

        public DiscoveredLocation materialB(TrackMaterial material) {
            this.materialB = material;
            return this;
        }

        public DiscoveredLocation materials(TrackMaterial materialA, TrackMaterial materialB) {
            this.materialA = materialA;
            this.materialB = materialB;
            return this;
        }

        public DiscoveredLocation viaTurn(BezierConnection turn) {
            this.turn = turn;
            if (turn != null) {
                this.forceNode();
            }
            return this;
        }

        public DiscoveredLocation forceNode() {
            this.forceNode = true;
            return this;
        }

        public DiscoveredLocation withNormal(Vec3 normal) {
            this.normal = normal;
            return this;
        }

        public DiscoveredLocation withYOffset(int yOffsetPixels) {
            this.yOffsetPixels = yOffsetPixels;
            return this;
        }

        public DiscoveredLocation withDirection(Vec3 direction) {
            this.direction = direction == null ? null : direction.normalize();
            return this;
        }

        public boolean connectedViaTurn() {
            return this.turn != null;
        }

        public BezierConnection getTurn() {
            return this.turn;
        }

        public boolean shouldForceNode() {
            return this.forceNode;
        }

        public boolean differentMaterials() {
            return this.materialA != this.materialB;
        }

        public boolean notInLineWith(Vec3 direction) {
            return this.direction != null && Math.max(direction.dot(this.direction), direction.dot(this.direction.scale(-1.0))) < 0.875;
        }

        public Vec3 getDirection() {
            return this.direction;
        }
    }
}

