/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;

public class PlayerPassengerCondition
extends ScheduleWaitCondition {
    public PlayerPassengerCondition(Identifier id) {
        super(id);
    }

    public int getTarget() {
        return this.intData("Count");
    }

    public boolean canOvershoot() {
        return this.intData("Exact") != 0;
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        int prev = context.getIntOr("PrevPlayerCount", 0);
        int present = train.countPlayerPassengers();
        int target = this.getTarget();
        context.putInt("PrevPlayerCount", present);
        if (prev != present) {
            this.requestStatusToUpdate(context);
        }
        return this.canOvershoot() ? present >= target : present == target;
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        return Component.translatable((String)"create.schedule.condition.player_count.status", (Object[])new Object[]{train.countPlayerPassengers(), this.getTarget()});
    }
}

