/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.station;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.world.Container;

public class GlobalPackagePort {
    public static final Codec<GlobalPackagePort> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("address").forGetter(i -> i.address), (App)ItemStackHandler.CODEC.fieldOf("offlineBuffer").forGetter(i -> i.offlineBuffer), (App)Codec.BOOL.fieldOf("primed").forGetter(i -> i.primed), (App)Codec.BOOL.fieldOf("restoring").forGetter(i -> i.restoring)).apply((Applicative)instance, GlobalPackagePort::new));
    public String address;
    public ItemStackHandler offlineBuffer;
    public boolean primed = false;
    private boolean restoring = false;

    public GlobalPackagePort() {
        this("", new ItemStackHandler(18), false, false);
    }

    private GlobalPackagePort(String address, ItemStackHandler offlineBuffer, boolean primed, boolean restoring) {
        this.address = address;
        this.offlineBuffer = offlineBuffer;
        this.primed = primed;
    }

    public void restoreOfflineBuffer(Container inventory) {
        if (!this.primed) {
            return;
        }
        this.restoring = true;
        int size = this.offlineBuffer.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            inventory.setItem(slot, this.offlineBuffer.getItem(slot));
        }
        this.restoring = false;
        this.primed = false;
    }

    public void saveOfflineBuffer(Container inventory) {
        if (this.restoring) {
            return;
        }
        int size = inventory.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            this.offlineBuffer.setItem(slot, inventory.getItem(slot));
        }
        Create.RAILWAYS.markTracksDirty();
    }
}

