/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.google.common.base.Predicates;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllTrackMaterials;
import com.zurrtum.create.api.contraption.train.PortalTrackProvider;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.decoration.girder.GirderBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.content.trains.track.TrackPropagator;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;

public class TrackBlock
extends Block
implements IBE<TrackBlockEntity>,
IWrenchable,
ITrackBlock,
SpecialBlockItemRequirement,
ProperWaterloggedBlock {
    public static final EnumProperty<TrackShape> SHAPE = EnumProperty.create((String)"shape", TrackShape.class);
    public static final BooleanProperty HAS_BE = BooleanProperty.create((String)"turn");
    protected final TrackMaterial material;

    public TrackBlock(BlockBehaviour.Properties p_49795_, TrackMaterial material) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)TrackShape.ZO))).setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.material = material;
    }

    public static TrackBlock andesite(BlockBehaviour.Properties settings) {
        return new TrackBlock(settings, AllTrackMaterials.ANDESITE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.createBlockStateDefinition(p_49915_.add(new Property[]{SHAPE, HAS_BE, WATERLOGGED}));
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState stateForPlacement = this.withWater(super.getStateForPlacement(ctx), ctx);
        if (ctx.getPlayer() == null) {
            return stateForPlacement;
        }
        Vec3 lookAngle = ctx.getPlayer().getLookAngle();
        if (Mth.equal((double)(lookAngle = lookAngle.multiply(1.0, 0.0, 1.0)).length(), (double)0.0)) {
            lookAngle = VecHelper.rotate(new Vec3(0.0, 0.0, 1.0), -ctx.getPlayer().getYRot(), Direction.Axis.Y);
        }
        lookAngle = lookAngle.normalize();
        TrackShape best = TrackShape.ZO;
        double bestValue = 3.4028234663852886E38;
        for (TrackShape shape : TrackShape.values()) {
            Vec3 axis;
            double distance;
            if (shape.isJunction() || shape.isPortal() || (distance = Math.min((axis = shape.getAxes().getFirst()).distanceToSqr(lookAngle), axis.normalize().scale(-1.0).distanceToSqr(lookAngle))) > bestValue) continue;
            bestValue = distance;
            best = shape;
        }
        Level level = ctx.getLevel();
        Vec3 bestAxis = best.getAxes().getFirst();
        if (bestAxis.lengthSqr() == 1.0) {
            for (boolean neg : Iterate.trueAndFalse) {
                BlockPos offset = ctx.getClickedPos().offset((Vec3i)BlockPos.containing((Position)bestAxis.scale(neg ? -1.0 : 1.0)));
                if (!level.getBlockState(offset).isFaceSturdy((BlockGetter)level, offset, Direction.UP) || level.getBlockState(offset.above()).isFaceSturdy((BlockGetter)level, offset, Direction.DOWN)) continue;
                if (best == TrackShape.XO) {
                    TrackShape trackShape = best = neg ? TrackShape.AW : TrackShape.AE;
                }
                if (best != TrackShape.ZO) continue;
                best = neg ? TrackShape.AN : TrackShape.AS;
            }
        }
        return (BlockState)stateForPlacement.setValue(SHAPE, (Comparable)((Object)best));
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        if (pLevel.isClientSide()) {
            return pState;
        }
        if (!pPlayer.isCreative()) {
            return pState;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> {
            be.cancelDrops = true;
            be.removeInboundConnections(true);
        });
        return pState;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.is((Block)this)) {
            if (pState.setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(true)) == pOldState.setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(true))) {
                return;
            }
            TrackPropagator.onRailRemoved((LevelAccessor)pLevel, pPos, pState);
        }
        if (pLevel.isClientSide()) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.getBlockTicks();
        if (!blockTicks.hasScheduledTick(pPos, (Object)this)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
        this.updateGirders(pState, pLevel, pPos, (LevelTickAccess<Block>)blockTicks);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, TrackBlockEntity::validateConnections);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource p_60465_) {
        TrackPropagator.onRailAdded((LevelAccessor)level, pos, state);
        this.withBlockEntityDo((BlockGetter)level, pos, tbe -> tbe.tilt.undoSmoothing());
        if (!((TrackShape)((Object)state.getValue(SHAPE))).isPortal()) {
            this.connectToPortal(level, pos, state);
        }
    }

    protected void connectToPortal(ServerLevel level, BlockPos pos, BlockState state) {
        Direction.Axis portalTest;
        TrackShape shape = (TrackShape)((Object)state.getValue(SHAPE));
        Object object = shape == TrackShape.XO ? Direction.Axis.X : (portalTest = shape == TrackShape.ZO ? Direction.Axis.Z : null);
        if (portalTest == null) {
            return;
        }
        boolean pop = false;
        String fail = null;
        BlockPos failPos = null;
        for (Direction d : Iterate.directionsInAxis(portalTest)) {
            BlockFace otherTrack;
            BlockPos otherTrackPos;
            BlockPos portalPos = pos.relative(d);
            BlockState portalState = level.getBlockState(portalPos);
            if (!PortalTrackProvider.isSupportedPortal(portalState)) continue;
            pop = true;
            PortalTrackProvider.Exit otherSide = PortalTrackProvider.getOtherSide(level, new BlockFace(pos, d));
            if (otherSide == null) {
                fail = "missing";
                continue;
            }
            ServerLevel otherLevel = otherSide.level();
            BlockState existing = otherLevel.getBlockState(otherTrackPos = (otherTrack = otherSide.face()).getPos());
            if (!existing.canBeReplaced()) {
                fail = "blocked";
                failPos = otherTrackPos;
                continue;
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)((Object)TrackShape.asPortal(d)))).setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)be;
                tbe.bind((ResourceKey<Level>)otherLevel.dimension(), otherTrackPos);
            }
            BlockState otherState = ProperWaterloggedBlock.withWater((LevelReader)otherLevel, (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)((Object)TrackShape.asPortal(otherTrack.getFace())))).setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(true)), otherTrackPos);
            otherLevel.setBlock(otherTrackPos, otherState, 3);
            BlockEntity otherBE = otherLevel.getBlockEntity(otherTrackPos);
            if (otherBE instanceof TrackBlockEntity) {
                TrackBlockEntity tbe = (TrackBlockEntity)otherBE;
                tbe.bind((ResourceKey<Level>)level.dimension(), pos);
            }
            pop = false;
        }
        if (!pop) {
            return;
        }
        level.destroyBlock(pos, true);
        if (fail == null) {
            return;
        }
        Player player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0, (Predicate)Predicates.alwaysTrue());
        if (player == null) {
            return;
        }
        player.displayClientMessage((Component)Component.literal((String)"<!> ").append((Component)Component.translatable((String)"create.portal_track.failed")).withStyle(ChatFormatting.GOLD), false);
        MutableComponent component = failPos != null ? Component.translatable((String)("create.portal_track." + fail), (Object[])new Object[]{failPos.getX(), failPos.getY(), failPos.getZ()}) : Component.translatable((String)("create.portal_track." + fail));
        player.displayClientMessage((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY).append((Component)component.withColor(16765876)), false);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickView, BlockPos pCurrentPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource random) {
        this.updateWater(level, tickView, state, pCurrentPos);
        TrackShape shape = (TrackShape)((Object)state.getValue(SHAPE));
        if (!shape.isPortal()) {
            return state;
        }
        for (Direction d : Iterate.horizontalDirections) {
            BlockPos portalPos;
            BlockState portalState;
            if (TrackShape.asPortal(d) != state.getValue(SHAPE) || pDirection != d || PortalTrackProvider.isSupportedPortal(portalState = level.getBlockState(portalPos = pCurrentPos.relative(d)))) continue;
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @Override
    public int getYOffsetAt(BlockGetter world, BlockPos pos, BlockState state, Vec3 end) {
        return this.getBlockEntityOptional(world, pos).map(tbe -> tbe.tilt.getYOffsetForAxisEnd(end)).orElse(0);
    }

    @Override
    public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(BlockGetter worldIn, BlockPos pos, BlockState state, boolean linear, TrackNodeLocation connectedTo) {
        Collection<TrackNodeLocation.DiscoveredLocation> list;
        BlockGetter world;
        if (connectedTo != null && worldIn instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)worldIn;
            v0 = sl.getServer().getLevel(connectedTo.dimension);
        } else {
            v0 = world = worldIn;
        }
        if (this.getTrackAxes(world, pos, state).size() > 1) {
            Vec3 center = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
            TrackShape shape = (TrackShape)((Object)state.getValue(SHAPE));
            list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
            for (Vec3 axis2 : this.getTrackAxes(world, pos, state)) {
                for (boolean fromCenter : Iterate.trueAndFalse) {
                    ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> axis2.scale(b != false ? 0.0 : (fromCenter ? -d.doubleValue() : d)).add(center), b -> shape.getNormal(), b -> {
                        ResourceKey resourceKey;
                        if (world instanceof Level) {
                            Level l = (Level)world;
                            resourceKey = l.dimension();
                        } else {
                            resourceKey = Level.OVERWORLD;
                        }
                        return resourceKey;
                    }, v -> 0, axis2, null, (b, v) -> ITrackBlock.getMaterialSimple(world, v));
                }
            }
        } else {
            list = ITrackBlock.super.getConnected(world, pos, state, linear, connectedTo);
        }
        if (!((Boolean)state.getValue((Property)HAS_BE)).booleanValue()) {
            return list;
        }
        if (linear) {
            return list;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof TrackBlockEntity)) {
            return list;
        }
        TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
        Map<BlockPos, BezierConnection> connections = trackBE.getConnections();
        connections.forEach((connectedPos, bc) -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> d == 1.0 ? Vec3.atLowerCornerOf((Vec3i)((Vec3i)bc.bePositions.get((boolean)b))) : bc.starts.get((boolean)b), bc.normals::get, b -> {
            ResourceKey resourceKey;
            if (world instanceof Level) {
                Level l = (Level)world;
                resourceKey = l.dimension();
            } else {
                resourceKey = Level.OVERWORLD;
            }
            return resourceKey;
        }, bc::yOffsetAt, null, bc, (b, v) -> ITrackBlock.getMaterialSimple(world, v, bc.getMaterial())));
        if (trackBE.boundLocation == null || !(world instanceof ServerLevel)) {
            return list;
        }
        ServerLevel level = (ServerLevel)world;
        ResourceKey<Level> otherDim = trackBE.boundLocation.getFirst();
        ServerLevel otherLevel = level.getServer().getLevel(otherDim);
        if (otherLevel == null) {
            return list;
        }
        BlockPos boundPos = trackBE.boundLocation.getSecond();
        BlockState boundState = otherLevel.getBlockState(boundPos);
        if (!boundState.is(AllBlockTags.TRACKS)) {
            return list;
        }
        Vec3 center = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
        Vec3 boundCenter = Vec3.atBottomCenterOf((Vec3i)boundPos).add(0.0, this.getElevationAtCenter((BlockGetter)otherLevel, boundPos, boundState), 0.0);
        TrackShape shape = (TrackShape)((Object)state.getValue(SHAPE));
        TrackShape boundShape = (TrackShape)((Object)boundState.getValue(SHAPE));
        Vec3 boundAxis = this.getTrackAxes((BlockGetter)otherLevel, boundPos, boundState).getFirst();
        this.getTrackAxes(world, pos, state).forEach(axis -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> (b != false ? axis : boundAxis).scale(d.doubleValue()).add(b != false ? center : boundCenter), b -> (b != false ? shape : boundShape).getNormal(), b -> b != false ? level.dimension() : otherLevel.dimension(), v -> 0, axis, null, (b, v) -> ITrackBlock.getMaterialSimple((BlockGetter)(b != false ? level : otherLevel), v)));
        return list;
    }

    public void affectNeighborsAfterRemoval(BlockState pState, ServerLevel pLevel, BlockPos pPos, boolean pIsMoving) {
        TrackPropagator.onRailRemoved((LevelAccessor)pLevel, pPos, pState);
        if (!pLevel.isClientSide()) {
            this.updateGirders(pState, (Level)pLevel, pPos, (LevelTickAccess<Block>)pLevel.getBlockTicks());
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        for (Map.Entry<BlockPos, BoundingBox> entry : StationBlockEntity.assemblyAreas.get((LevelAccessor)level).entrySet()) {
            StationBlockEntity station;
            BlockEntity blockEntity;
            if (!entry.getValue().isInside((Vec3i)pos) || !((blockEntity = level.getBlockEntity(entry.getKey())) instanceof StationBlockEntity) || !(station = (StationBlockEntity)blockEntity).trackClicked(player, hand, this, state, pos)) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    private void updateGirders(BlockState pState, Level pLevel, BlockPos pPos, LevelTickAccess<Block> blockTicks) {
        for (Vec3 vec3 : this.getTrackAxes((BlockGetter)pLevel, pPos, pState)) {
            if (vec3.length() > 1.0 || vec3.y != 0.0) continue;
            for (int side : Iterate.positiveAndNegative) {
                GirderBlock girderBlock;
                BlockPos girderPos = pPos.below().offset((Vec3i)BlockPos.containing((double)(vec3.z * (double)side), (double)0.0, (double)(vec3.x * (double)side)));
                BlockState girderState = pLevel.getBlockState(girderPos);
                Block block = girderState.getBlock();
                if (!(block instanceof GirderBlock) || blockTicks.hasScheduledTick(girderPos, (Object)(girderBlock = (GirderBlock)block))) continue;
                pLevel.scheduleTick(girderPos, (Block)girderBlock, 1);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.below()).getBlock() != this;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.getFullShape(state);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter pLevel, BlockPos pPos) {
        return this.getFullShape(state);
    }

    private VoxelShape getFullShape(BlockState state) {
        return switch ((TrackShape)((Object)state.getValue(SHAPE))) {
            case TrackShape.AE -> AllShapes.TRACK_ASC.get(Direction.EAST);
            case TrackShape.AW -> AllShapes.TRACK_ASC.get(Direction.WEST);
            case TrackShape.AN -> AllShapes.TRACK_ASC.get(Direction.NORTH);
            case TrackShape.AS -> AllShapes.TRACK_ASC.get(Direction.SOUTH);
            case TrackShape.CR_D -> AllShapes.TRACK_CROSS_DIAG;
            case TrackShape.CR_NDX -> AllShapes.TRACK_CROSS_ORTHO_DIAG.get(Direction.SOUTH);
            case TrackShape.CR_NDZ -> AllShapes.TRACK_CROSS_DIAG_ORTHO.get(Direction.SOUTH);
            case TrackShape.CR_O -> AllShapes.TRACK_CROSS;
            case TrackShape.CR_PDX -> AllShapes.TRACK_CROSS_DIAG_ORTHO.get(Direction.EAST);
            case TrackShape.CR_PDZ -> AllShapes.TRACK_CROSS_ORTHO_DIAG.get(Direction.EAST);
            case TrackShape.ND -> AllShapes.TRACK_DIAG.get(Direction.SOUTH);
            case TrackShape.PD -> AllShapes.TRACK_DIAG.get(Direction.EAST);
            case TrackShape.XO -> AllShapes.TRACK_ORTHO.get(Direction.EAST);
            case TrackShape.ZO -> AllShapes.TRACK_ORTHO.get(Direction.SOUTH);
            case TrackShape.TE -> AllShapes.TRACK_ORTHO_LONG.get(Direction.EAST);
            case TrackShape.TW -> AllShapes.TRACK_ORTHO_LONG.get(Direction.WEST);
            case TrackShape.TS -> AllShapes.TRACK_ORTHO_LONG.get(Direction.SOUTH);
            case TrackShape.TN -> AllShapes.TRACK_ORTHO_LONG.get(Direction.NORTH);
            default -> AllShapes.TRACK_FALLBACK;
        };
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((TrackShape)((Object)pState.getValue(SHAPE))) {
            case TrackShape.AE, TrackShape.AW, TrackShape.AN, TrackShape.AS -> Shapes.empty();
            default -> AllShapes.TRACK_COLLISION;
        };
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState state) {
        if (!((Boolean)state.getValue((Property)HAS_BE)).booleanValue()) {
            return null;
        }
        return AllBlockEntityTypes.TRACK.create(p_153215_, state);
    }

    @Override
    public Class<TrackBlockEntity> getBlockEntityClass() {
        return TrackBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends TrackBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.TRACK;
    }

    @Override
    public Vec3 getUpNormal(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TrackShape)((Object)state.getValue(SHAPE))).getNormal();
    }

    @Override
    public List<Vec3> getTrackAxes(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TrackShape)((Object)state.getValue(SHAPE))).getAxes();
    }

    @Override
    public Vec3 getCurveStart(BlockGetter world, BlockPos pos, BlockState state, Vec3 axis) {
        boolean vertical = axis.y != 0.0;
        return VecHelper.getCenterOf((Vec3i)pos).add(0.0, (double)(vertical ? 0.0f : -0.5f), 0.0).add(axis.scale(0.5));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (!level.isClientSide() && !player.isCreative() && ((Boolean)state.getValue((Property)HAS_BE)).booleanValue() && (blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
            trackBE.cancelDrops = true;
            trackBE.connections.values().forEach(bc -> bc.addItemsToPlayer(player));
        }
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public BlockState overlay(BlockGetter world, BlockPos pos, BlockState existing, BlockState placed) {
        if (placed.getBlock() != this) {
            return existing;
        }
        TrackShape existingShape = (TrackShape)((Object)existing.getValue(SHAPE));
        TrackShape placedShape = (TrackShape)((Object)placed.getValue(SHAPE));
        TrackShape combinedShape = null;
        for (boolean flip : Iterate.trueAndFalse) {
            TrackShape s2;
            TrackShape s1 = flip ? existingShape : placedShape;
            TrackShape trackShape = s2 = flip ? placedShape : existingShape;
            if (s1 == TrackShape.XO && s2 == TrackShape.ZO) {
                combinedShape = TrackShape.CR_O;
            }
            if (s1 == TrackShape.PD && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_D;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDX;
            }
            if (s1 == TrackShape.ZO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDZ;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_NDX;
            }
            if (s1 != TrackShape.ZO || s2 != TrackShape.ND) continue;
            combinedShape = TrackShape.CR_NDZ;
        }
        if (combinedShape != null) {
            existing = (BlockState)existing.setValue(SHAPE, combinedShape);
        }
        return existing;
    }

    public BlockState rotate(BlockState state, Rotation pRotation) {
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.getValue(SHAPE))).rotate(pRotation)));
    }

    public BlockState mirror(BlockState state, Mirror pMirror) {
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.getValue(SHAPE))).mirror(pMirror)));
    }

    @Override
    public BlockState getBogeyAnchor(BlockGetter world, BlockPos pos, BlockState state) {
        return (BlockState)AllBlocks.SMALL_BOGEY.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)(state.getValue(SHAPE) == TrackShape.XO ? Direction.Axis.X : Direction.Axis.Z));
    }

    @Override
    public boolean trackEquals(BlockState state1, BlockState state2) {
        return state1.getBlock() == this && state2.getBlock() == this && state1.setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(false)) == state2.setValue((Property)HAS_BE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        int sameTypeTrackAmount = 1;
        Object2IntArrayMap otherTrackAmounts = new Object2IntArrayMap();
        int girderAmount = 0;
        if (be instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)be;
            for (BezierConnection bezierConnection : track.getConnections().values()) {
                if (!bezierConnection.isPrimary()) continue;
                TrackMaterial material = bezierConnection.getMaterial();
                if (material == this.getMaterial()) {
                    sameTypeTrackAmount += bezierConnection.getTrackItemCost();
                } else {
                    otherTrackAmounts.put((Object)material, otherTrackAmounts.getOrDefault((Object)material, 0) + 1);
                }
                girderAmount += bezierConnection.getGirderItemCost();
            }
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        while (sameTypeTrackAmount > 0) {
            stacks.add(new ItemStack((ItemLike)state.getBlock(), Math.min(sameTypeTrackAmount, 64)));
            sameTypeTrackAmount -= 64;
        }
        for (TrackMaterial material : otherTrackAmounts.keySet()) {
            for (int amt = otherTrackAmounts.getOrDefault((Object)material, 0); amt > 0; amt -= 64) {
                stacks.add(new ItemStack((ItemLike)material, Math.min(amt, 64)));
            }
        }
        while (girderAmount > 0) {
            stacks.add(new ItemStack((ItemLike)AllItems.METAL_GIRDER, Math.min(girderAmount, 64)));
            girderAmount -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Override
    public TrackMaterial getMaterial() {
        return this.material;
    }
}

