/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphHelper;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TrackTargetingBehaviour<T extends TrackEdgePoint>
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<TrackTargetingBehaviour<?>> TYPE = new BehaviourType();
    private BlockPos targetTrack;
    private BezierTrackPointLocation targetBezier;
    private Direction.AxisDirection targetDirection;
    private UUID id;
    private Vec3 prevDirection;
    private Vec3 rotatedDirection;
    private CompoundTag migrationData;
    private EdgePointType<T> edgePointType;
    private T edgePoint;
    private boolean orthogonal;

    public TrackTargetingBehaviour(SmartBlockEntity be, EdgePointType<T> edgePointType) {
        super(be);
        this.edgePointType = edgePointType;
        this.targetDirection = Direction.AxisDirection.POSITIVE;
        this.targetTrack = BlockPos.ZERO;
        this.id = UUID.randomUUID();
        this.migrationData = null;
        this.orthogonal = false;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.store("Id", UUIDUtil.CODEC, (Object)this.id);
        view.store("TargetTrack", BlockPos.CODEC, (Object)this.targetTrack);
        view.putBoolean("Ortho", this.orthogonal);
        view.putBoolean("TargetDirection", this.targetDirection == Direction.AxisDirection.POSITIVE);
        if (this.rotatedDirection != null) {
            view.store("RotatedAxis", Vec3.CODEC, (Object)this.rotatedDirection);
        }
        if (this.prevDirection != null) {
            view.store("PrevAxis", Vec3.CODEC, (Object)this.prevDirection);
        }
        if (this.migrationData != null && !clientPacket) {
            view.store("Migrate", CompoundTag.CODEC, (Object)this.migrationData);
        }
        if (this.targetBezier != null) {
            ValueOutput bezier = view.child("Bezier");
            bezier.putInt("Segment", this.targetBezier.segment());
            bezier.store("Key", BlockPos.CODEC, (Object)this.targetBezier.curveTarget().subtract((Vec3i)this.getPos()));
        }
        super.write(view, clientPacket);
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.id = view.read("Id", UUIDUtil.CODEC).orElseGet(UUID::randomUUID);
        this.targetTrack = view.read("TargetTrack", BlockPos.CODEC).orElse(BlockPos.ZERO);
        this.targetDirection = view.getBooleanOr("TargetDirection", false) ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.orthogonal = view.getBooleanOr("Ortho", false);
        view.read("RotatedAxis", Vec3.CODEC).ifPresent(rotated -> {
            this.rotatedDirection = rotated;
        });
        view.read("PrevAxis", Vec3.CODEC).ifPresent(prev -> {
            this.prevDirection = prev;
        });
        view.read("Migrate", CompoundTag.CODEC).ifPresent(migration -> {
            this.migrationData = migration;
        });
        if (clientPacket) {
            this.edgePoint = null;
        }
        view.child("Bezier").ifPresent(bezier -> {
            BlockPos key = bezier.read("Key", BlockPos.CODEC).orElse(BlockPos.ZERO);
            this.targetBezier = new BezierTrackPointLocation(key.offset((Vec3i)this.getPos()), bezier.getIntOr("Segment", 0));
        });
        super.read(view, clientPacket);
    }

    @Nullable
    public T getEdgePoint() {
        return this.edgePoint;
    }

    public void invalidateEdgePoint(CompoundTag migrationData) {
        this.migrationData = migrationData;
        this.edgePoint = null;
        this.blockEntity.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.edgePoint == null) {
            this.edgePoint = this.createEdgePoint();
        }
    }

    public T createEdgePoint() {
        Level level = this.getLevel();
        boolean isClientSide = level.isClientSide();
        if (this.migrationData == null || isClientSide) {
            for (TrackGraph trackGraph : Create.RAILWAYS.sided((LevelAccessor)level).trackNetworks.values()) {
                T point = trackGraph.getPoint(this.edgePointType, this.id);
                if (point == null) continue;
                return point;
            }
        }
        if (isClientSide) {
            return null;
        }
        if (!this.hasValidTrack()) {
            return null;
        }
        TrackGraphLocation loc = this.determineGraphLocation();
        if (loc == null) {
            return null;
        }
        TrackGraph graph = loc.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return null;
        }
        T point = this.edgePointType.create();
        boolean front = this.getTargetDirection() == Direction.AxisDirection.POSITIVE;
        this.prevDirection = edge.getDirectionAt(loc.position).scale(front ? -1.0 : 1.0);
        if (this.rotatedDirection != null) {
            double dot = this.prevDirection.dot(this.rotatedDirection);
            if (dot < (double)-0.85f) {
                this.rotatedDirection = null;
                this.targetDirection = this.targetDirection.opposite();
                return null;
            }
            this.rotatedDirection = null;
        }
        double length = edge.getLength();
        CompoundTag data = this.migrationData;
        this.migrationData = null;
        this.orthogonal = this.targetBezier == null;
        Vec3 direction = edge.getDirection(true);
        int nonZeroComponents = 0;
        for (Direction.Axis axis : Iterate.axes) {
            nonZeroComponents += direction.get(axis) != 0.0 ? 1 : 0;
        }
        this.orthogonal &= nonZeroComponents <= 1;
        EdgeData signalData = edge.getEdgeData();
        if (signalData.hasPoints()) {
            for (EdgePointType<?> otherType : EdgePointType.TYPES.values()) {
                Object otherPoint = signalData.get(otherType, loc.position);
                if (otherPoint == null) continue;
                if (otherType != this.edgePointType) {
                    if (((TrackEdgePoint)otherPoint).canCoexistWith(this.edgePointType, front)) continue;
                    return null;
                }
                if (!((TrackEdgePoint)otherPoint).canMerge()) {
                    return null;
                }
                ((TrackEdgePoint)otherPoint).blockEntityAdded(this.blockEntity, front);
                this.id = ((TrackEdgePoint)otherPoint).getId();
                this.blockEntity.notifyUpdate();
                return (T)otherPoint;
            }
        }
        if (data != null) {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.blockEntity.problemPath(), Create.LOGGER);){
                ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)data);
                DimensionPalette dimensions = (DimensionPalette)view.read("DimensionPalette", DimensionPalette.CODEC).orElseThrow();
                ((TrackEdgePoint)point).read(view, true, dimensions);
            }
        }
        ((TrackEdgePoint)point).setId(this.id);
        boolean reverseEdge = front || point instanceof SingleBlockEntityEdgePoint;
        ((TrackEdgePoint)point).setLocation((Couple<TrackNodeLocation>)(reverseEdge ? loc.edge : loc.edge.swap()), reverseEdge ? loc.position : length - loc.position);
        ((TrackEdgePoint)point).blockEntityAdded(this.blockEntity, front);
        loc.graph.addPoint(level.getServer(), this.edgePointType, point);
        this.blockEntity.sendData();
        return point;
    }

    @Override
    public void destroy() {
        Level world;
        super.destroy();
        if (this.edgePoint != null && !(world = this.getLevel()).isClientSide()) {
            ((TrackEdgePoint)this.edgePoint).blockEntityRemoved(world.getServer(), this.getPos(), this.getTargetDirection() == Direction.AxisDirection.POSITIVE);
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isOnCurve() {
        return this.targetBezier != null;
    }

    public boolean isOrthogonal() {
        return this.orthogonal;
    }

    public boolean hasValidTrack() {
        return this.getTrackBlockState().getBlock() instanceof ITrackBlock;
    }

    public ITrackBlock getTrack() {
        return (ITrackBlock)this.getTrackBlockState().getBlock();
    }

    public BlockState getTrackBlockState() {
        return this.getLevel().getBlockState(this.getGlobalPosition());
    }

    public BlockPos getGlobalPosition() {
        return this.targetTrack.offset((Vec3i)this.blockEntity.getBlockPos());
    }

    public BlockPos getPositionForMapMarker() {
        BlockEntity blockEntity;
        BlockPos target = this.targetTrack.offset((Vec3i)this.blockEntity.getBlockPos());
        if (this.targetBezier != null && (blockEntity = this.getLevel().getBlockEntity(target)) instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            BezierConnection bc = tbe.getConnections().get(this.targetBezier.curveTarget());
            if (bc == null) {
                return target;
            }
            double length = Mth.floor((double)(bc.getLength() * 2.0));
            int seg = this.targetBezier.segment() + 1;
            double t = (double)seg / length;
            return BlockPos.containing((Position)bc.getPosition(t));
        }
        return target;
    }

    public Direction.AxisDirection getTargetDirection() {
        return this.targetDirection;
    }

    public BezierTrackPointLocation getTargetBezier() {
        return this.targetBezier;
    }

    public TrackGraphLocation determineGraphLocation() {
        Level level = this.getLevel();
        BlockPos pos = this.getGlobalPosition();
        BlockState state = this.getTrackBlockState();
        ITrackBlock track = this.getTrack();
        List<Vec3> trackAxes = track.getTrackAxes((BlockGetter)level, pos, state);
        Direction.AxisDirection targetDirection = this.getTargetDirection();
        return this.targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, this.targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.getFirst());
    }

    public void transform(BlockEntity be, StructureTransform transform) {
        this.id = UUID.randomUUID();
        this.targetTrack = transform.applyWithoutOffset(this.targetTrack);
        if (this.prevDirection != null) {
            this.rotatedDirection = transform.applyWithoutOffsetUncentered(this.prevDirection);
        }
        if (this.targetBezier != null) {
            this.targetBezier = new BezierTrackPointLocation(transform.applyWithoutOffset(this.targetBezier.curveTarget().subtract((Vec3i)this.getPos())).offset((Vec3i)this.getPos()), this.targetBezier.segment());
        }
        this.blockEntity.notifyUpdate();
    }

    public static enum RenderedTrackOverlayType {
        STATION,
        SIGNAL,
        DUAL_SIGNAL,
        OBSERVER;

    }
}

