/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.advancement;

import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class AdvancementBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<AdvancementBehaviour> TYPE = new BehaviourType();
    private UUID playerId;
    private final Set<CreateTrigger> advancements;

    public AdvancementBehaviour(SmartBlockEntity be, ServerPlayer player, CreateTrigger ... advancements) {
        super(be);
        this.advancements = new HashSet<CreateTrigger>(List.of(advancements));
        this.playerId = player.getUUID();
        this.removeAwarded(player);
        this.blockEntity.setChanged();
    }

    public boolean isOwnerPresent() {
        return this.playerId != null;
    }

    @Override
    public void initialize() {
        ServerPlayer player = this.getPlayer();
        if (player != null) {
            this.removeAwarded(player);
        }
    }

    private void removeAwarded(ServerPlayer player) {
        if (this.advancements.isEmpty()) {
            return;
        }
        ServerAdvancementManager loader = player.level().getServer().getAdvancements();
        PlayerAdvancements advancementTracker = player.getAdvancements();
        this.advancements.removeIf(trigger -> {
            Set<CriterionTrigger.Listener<CreateTrigger.Conditions>> containers = trigger.listeners.get(advancementTracker);
            if (containers != null) {
                return containers.stream().allMatch(container -> advancementTracker.getOrStartProgress(container.advancement()).isDone());
            }
            AdvancementHolder advancement = loader.get(trigger.id);
            if (advancement == null) {
                return true;
            }
            return advancementTracker.getOrStartProgress(advancement).isDone();
        });
        if (this.advancements.isEmpty()) {
            this.playerId = null;
            this.blockEntity.setChanged();
        }
    }

    public void awardPlayerIfNear(CreateTrigger advancement, int maxDistance) {
        ServerPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.getPos())) > (double)(maxDistance * maxDistance)) {
            return;
        }
        this.award(advancement, player);
    }

    public void awardPlayer(CreateTrigger advancement) {
        ServerPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.award(advancement, player);
    }

    private void award(CreateTrigger advancement, ServerPlayer player) {
        if (this.advancements.contains(advancement)) {
            advancement.trigger(player);
            this.removeAwarded(player);
        }
    }

    private ServerPlayer getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        return (ServerPlayer)this.getLevel().getPlayerByUUID(this.playerId);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (this.playerId != null) {
            view.store("Owner", UUIDUtil.CODEC, (Object)this.playerId);
        }
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.playerId = view.read("Owner", UUIDUtil.CODEC).orElse(null);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void tryAward(BlockGetter reader, BlockPos pos, CreateTrigger advancement) {
        AdvancementBehaviour behaviour = BlockEntityBehaviour.get(reader, pos, TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public static void setPlacedBy(Level worldIn, BlockPos pos, LivingEntity placer) {
        if (worldIn.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity blockEntity2 = (SmartBlockEntity)blockEntity;
        if (placer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)placer;
            if (FakePlayerHandler.has((Entity)player)) {
                return;
            }
            blockEntity2.addAdvancementBehaviour(player);
        }
    }
}

