/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zurrtum.create.Create;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class RecipeFinder {
    private static final Cache<Object, List<RecipeHolder<?>>> CACHED_SEARCHES = CacheBuilder.newBuilder().build();
    public static final ResourceManagerReloadListener LISTENER = resourceManager -> CACHED_SEARCHES.invalidateAll();

    public static List<RecipeHolder<?>> get(@Nullable Object cacheKey, ServerLevel level, Predicate<RecipeHolder<?>> conditions) {
        if (cacheKey == null) {
            return RecipeFinder.startSearch(level, conditions);
        }
        try {
            return (List)CACHED_SEARCHES.get(cacheKey, () -> RecipeFinder.startSearch(level, conditions));
        }
        catch (ExecutionException e) {
            Create.LOGGER.error("Encountered a exception while searching for recipes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<RecipeHolder<?>> startSearch(ServerLevel level, Predicate<? super RecipeHolder<?>> conditions) {
        ArrayList recipes = new ArrayList();
        for (RecipeHolder r : level.recipeAccess().getRecipes()) {
            if (!conditions.test(r)) continue;
            recipes.add(r);
        }
        return recipes;
    }
}

