/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.impl.contraption;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.ContraptionMovementSetting;
import com.zurrtum.create.content.contraptions.actors.AttachedActorBlock;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.zurrtum.create.content.contraptions.bearing.ClockworkBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.ClockworkBearingBlockEntity;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.zurrtum.create.content.contraptions.bearing.SailBlock;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import com.zurrtum.create.content.kinetics.fan.NozzleBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlock;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlock;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class BlockMovementChecksImpl {
    private static final List<BlockMovementChecks.MovementNecessaryCheck> MOVEMENT_NECESSARY_CHECKS = new ArrayList<BlockMovementChecks.MovementNecessaryCheck>();
    private static final List<BlockMovementChecks.MovementAllowedCheck> MOVEMENT_ALLOWED_CHECKS = new ArrayList<BlockMovementChecks.MovementAllowedCheck>();
    private static final List<BlockMovementChecks.BrittleCheck> BRITTLE_CHECKS = new ArrayList<BlockMovementChecks.BrittleCheck>();
    private static final List<BlockMovementChecks.AttachedCheck> ATTACHED_CHECKS = new ArrayList<BlockMovementChecks.AttachedCheck>();
    private static final List<BlockMovementChecks.NotSupportiveCheck> NOT_SUPPORTIVE_CHECKS = new ArrayList<BlockMovementChecks.NotSupportiveCheck>();

    public static synchronized void registerMovementNecessaryCheck(BlockMovementChecks.MovementNecessaryCheck check) {
        MOVEMENT_NECESSARY_CHECKS.addFirst(check);
    }

    public static synchronized void registerMovementAllowedCheck(BlockMovementChecks.MovementAllowedCheck check) {
        MOVEMENT_ALLOWED_CHECKS.addFirst(check);
    }

    public static synchronized void registerBrittleCheck(BlockMovementChecks.BrittleCheck check) {
        BRITTLE_CHECKS.addFirst(check);
    }

    public static synchronized void registerAttachedCheck(BlockMovementChecks.AttachedCheck check) {
        ATTACHED_CHECKS.addFirst(check);
    }

    public static synchronized void registerNotSupportiveCheck(BlockMovementChecks.NotSupportiveCheck check) {
        NOT_SUPPORTIVE_CHECKS.addFirst(check);
    }

    public static boolean isMovementNecessary(BlockState state, Level world, BlockPos pos) {
        for (BlockMovementChecks.MovementNecessaryCheck check : MOVEMENT_NECESSARY_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isMovementNecessary(state, world, pos);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isMovementNecessaryFallback(state, world, pos);
    }

    public static boolean isMovementAllowed(BlockState state, Level world, BlockPos pos) {
        for (BlockMovementChecks.MovementAllowedCheck check : MOVEMENT_ALLOWED_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isMovementAllowed(state, world, pos);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isMovementAllowedFallback(state, world, pos);
    }

    public static boolean isBrittle(BlockState state) {
        for (BlockMovementChecks.BrittleCheck check : BRITTLE_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isBrittle(state);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isBrittleFallback(state);
    }

    public static boolean isBlockAttachedTowards(BlockState state, Level world, BlockPos pos, Direction direction) {
        for (BlockMovementChecks.AttachedCheck check : ATTACHED_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isBlockAttachedTowards(state, world, pos, direction);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isBlockAttachedTowardsFallback(state, world, pos, direction);
    }

    public static boolean isNotSupportive(BlockState state, Direction facing) {
        for (BlockMovementChecks.NotSupportiveCheck check : NOT_SUPPORTIVE_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isNotSupportive(state, facing);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isNotSupportiveFallback(state, facing);
    }

    private static boolean isMovementNecessaryFallback(BlockState state, Level world, BlockPos pos) {
        if (BlockMovementChecks.isBrittle(state)) {
            return true;
        }
        if (state.is(AllBlockTags.MOVABLE_EMPTY_COLLIDER)) {
            return true;
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return false;
        }
        return !state.canBeReplaced();
    }

    private static boolean isMovementAllowedFallback(BlockState state, Level world, BlockPos pos) {
        BlockEntity be;
        Block block = state.getBlock();
        if (block instanceof AbstractChassisBlock) {
            return true;
        }
        if (state.getDestroySpeed((BlockGetter)world, pos) == -1.0f) {
            return false;
        }
        if (state.is(AllBlockTags.RELOCATION_NOT_SUPPORTED)) {
            return false;
        }
        if (state.is(AllBlockTags.NON_MOVABLE)) {
            return false;
        }
        if (ContraptionMovementSetting.get(state) == ContraptionMovementSetting.UNMOVABLE) {
            return false;
        }
        if (block instanceof MechanicalPistonBlock && state.getValue(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.MOVING) {
            return true;
        }
        if (block instanceof MechanicalBearingBlock && (be = world.getBlockEntity(pos)) instanceof MechanicalBearingBlockEntity) {
            return !((MechanicalBearingBlockEntity)be).isRunning();
        }
        if (block instanceof ClockworkBearingBlock && (be = world.getBlockEntity(pos)) instanceof ClockworkBearingBlockEntity) {
            ClockworkBearingBlockEntity cbe = (ClockworkBearingBlockEntity)be;
            return !cbe.isRunning();
        }
        if (block instanceof PulleyBlock && (be = world.getBlockEntity(pos)) instanceof PulleyBlockEntity) {
            PulleyBlockEntity pulley = (PulleyBlockEntity)be;
            return !pulley.running;
        }
        if (state.is((Block)AllBlocks.BELT)) {
            return true;
        }
        if (state.getBlock() instanceof GrindstoneBlock) {
            return true;
        }
        if (state.getBlock() instanceof ITrackBlock) {
            return false;
        }
        if (state.getBlock() instanceof StationBlock) {
            return false;
        }
        return state.getPistonPushReaction() != PushReaction.BLOCK;
    }

    private static boolean isBrittleFallback(BlockState state) {
        Block block = state.getBlock();
        if (state.hasProperty((Property)BlockStateProperties.HANGING)) {
            return true;
        }
        if (block instanceof LadderBlock) {
            return true;
        }
        if (block instanceof BaseTorchBlock) {
            return true;
        }
        if (block instanceof SignBlock) {
            return true;
        }
        if (block instanceof BasePressurePlateBlock) {
            return true;
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock && !(block instanceof GrindstoneBlock)) {
            return true;
        }
        if (block instanceof CartAssemblerBlock) {
            return false;
        }
        if (block instanceof BaseRailBlock) {
            return true;
        }
        if (block instanceof DiodeBlock) {
            return true;
        }
        if (block instanceof RedStoneWireBlock) {
            return true;
        }
        if (block instanceof WoolCarpetBlock) {
            return true;
        }
        if (block instanceof WhistleBlock) {
            return true;
        }
        if (block instanceof WhistleExtenderBlock) {
            return true;
        }
        if (block instanceof BeltFunnelBlock) {
            return true;
        }
        return state.is(AllBlockTags.BRITTLE);
    }

    private static boolean isBlockAttachedTowardsFallback(BlockState state, Level world, BlockPos pos, Direction direction) {
        Block block = state.getBlock();
        if (block instanceof LadderBlock) {
            return state.getValue((Property)LadderBlock.FACING) == direction.getOpposite();
        }
        if (block instanceof WallTorchBlock) {
            return state.getValue((Property)WallTorchBlock.FACING) == direction.getOpposite();
        }
        if (block instanceof WallSignBlock) {
            return state.getValue((Property)WallSignBlock.FACING) == direction.getOpposite();
        }
        if (block instanceof StandingSignBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof BasePressurePlateBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DoorBlock) {
            if (state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER && direction == Direction.UP) {
                return true;
            }
            return direction == Direction.DOWN;
        }
        if (block instanceof BedBlock) {
            Direction facing = (Direction)state.getValue((Property)BedBlock.FACING);
            if (state.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                facing = facing.getOpposite();
            }
            return direction == facing;
        }
        if (block instanceof RedstoneLinkBlock) {
            return direction.getOpposite() == state.getValue((Property)RedstoneLinkBlock.FACING);
        }
        if (block instanceof FlowerPotBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DiodeBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedStoneWireBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof WoolCarpetBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneWallTorchBlock) {
            return state.getValue((Property)RedstoneWallTorchBlock.FACING) == direction.getOpposite();
        }
        if (block instanceof BaseTorchBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock) {
            AttachFace attachFace = (AttachFace)state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE);
            if (attachFace == AttachFace.CEILING) {
                return direction == Direction.UP;
            }
            if (attachFace == AttachFace.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachFace == AttachFace.WALL) {
                return direction.getOpposite() == state.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACING);
            }
        }
        if (state.hasProperty((Property)BlockStateProperties.HANGING)) {
            return direction == ((Boolean)state.getValue((Property)BlockStateProperties.HANGING) != false ? Direction.UP : Direction.DOWN);
        }
        if (block instanceof BaseRailBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof AttachedActorBlock) {
            return direction == ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
        }
        if (block instanceof HandCrankBlock) {
            return direction == ((Direction)state.getValue((Property)HandCrankBlock.FACING)).getOpposite();
        }
        if (block instanceof NozzleBlock) {
            return direction == ((Direction)state.getValue((Property)NozzleBlock.FACING)).getOpposite();
        }
        if (block instanceof BellBlock) {
            BellAttachType attachment = (BellAttachType)state.getValue((Property)BlockStateProperties.BELL_ATTACHMENT);
            if (attachment == BellAttachType.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachment == BellAttachType.CEILING) {
                return direction == Direction.UP;
            }
            return direction == state.getValue((Property)HorizontalDirectionalBlock.FACING);
        }
        if (state.getBlock() instanceof SailBlock) {
            return direction.getAxis() != ((Direction)state.getValue((Property)SailBlock.FACING)).getAxis();
        }
        if (state.getBlock() instanceof FluidTankBlock) {
            return ConnectivityHandler.isConnected((BlockGetter)world, pos, pos.relative(direction));
        }
        if (state.getBlock() instanceof ItemVaultBlock) {
            return ConnectivityHandler.isConnected((BlockGetter)world, pos, pos.relative(direction));
        }
        if (state.is((Block)AllBlocks.STICKER) && ((Boolean)state.getValue((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return direction == state.getValue((Property)StickerBlock.FACING) && !BlockMovementChecks.isNotSupportive(world.getBlockState(pos.relative(direction)), direction.getOpposite());
        }
        if (block instanceof WhistleBlock) {
            return direction == ((Boolean)state.getValue((Property)WhistleBlock.WALL) != false ? (Direction)state.getValue(WhistleBlock.FACING) : Direction.DOWN);
        }
        if (block instanceof WhistleExtenderBlock) {
            return direction == Direction.DOWN;
        }
        return false;
    }

    private static boolean isNotSupportiveFallback(BlockState state, Direction facing) {
        if (state.is((Block)AllBlocks.MECHANICAL_DRILL)) {
            return state.getValue((Property)BlockStateProperties.FACING) == facing;
        }
        if (state.is((Block)AllBlocks.MECHANICAL_BEARING)) {
            return state.getValue((Property)BlockStateProperties.FACING) == facing;
        }
        if (state.is((Block)AllBlocks.CART_ASSEMBLER)) {
            return facing == Direction.DOWN;
        }
        if (state.is((Block)AllBlocks.MECHANICAL_SAW)) {
            return state.getValue((Property)BlockStateProperties.FACING) == facing;
        }
        if (state.is((Block)AllBlocks.PORTABLE_STORAGE_INTERFACE)) {
            return state.getValue((Property)PortableStorageInterfaceBlock.FACING) == facing;
        }
        if (state.getBlock() instanceof AttachedActorBlock) {
            return state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == facing;
        }
        if (state.is((Block)AllBlocks.ROPE_PULLEY)) {
            return facing == Direction.DOWN;
        }
        if (state.getBlock() instanceof WoolCarpetBlock) {
            return facing == Direction.UP;
        }
        if (state.getBlock() instanceof SailBlock) {
            return facing.getAxis() == ((Direction)state.getValue((Property)SailBlock.FACING)).getAxis();
        }
        if (state.is((Block)AllBlocks.PISTON_EXTENSION_POLE)) {
            return facing.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getAxis();
        }
        if (state.is((Block)AllBlocks.MECHANICAL_PISTON_HEAD)) {
            return facing.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getAxis();
        }
        if (state.is((Block)AllBlocks.STICKER) && !((Boolean)state.getValue((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return facing == state.getValue((Property)StickerBlock.FACING);
        }
        if (state.getBlock() instanceof SlidingDoorBlock) {
            return false;
        }
        return BlockMovementChecks.isBrittle(state);
    }
}

