/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.impl.unpacking;

import com.zurrtum.create.AllUnpackingHandlers;
import com.zurrtum.create.api.packager.unpacking.UnpackingHandler;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CrafterUnpackingHandler
implements UnpackingHandler {
    @Override
    public boolean unpack(Level level, BlockPos pos, BlockState state, Direction side, List<ItemStack> items, @Nullable PackageOrderWithCrafts orderContext, boolean simulate) {
        if (!PackageOrderWithCrafts.hasCraftingInformation(orderContext)) {
            return AllUnpackingHandlers.DEFAULT.unpack(level, pos, state, side, items, null, simulate);
        }
        List<BigItemStack> craftingContext = orderContext.getCraftingInformation();
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof MechanicalCrafterBlockEntity)) {
            return false;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)be;
        ConnectedInputHandler.ConnectedInput input = crafter.getInput();
        MechanicalCrafterBlockEntity.CrafterItemHandler[] inventories = input.getInventories(level, pos);
        int size = inventories.length;
        if (size == 0) {
            return false;
        }
        int max = Math.min(size, craftingContext.size());
        block0: for (int i = 0; i < max; ++i) {
            MechanicalCrafterBlockEntity.CrafterItemHandler inventory;
            BigItemStack targetStack = craftingContext.get(i);
            if (targetStack.stack.isEmpty() || !(inventory = inventories[i]).getStack().isEmpty()) continue;
            for (ItemStack stack : items) {
                int insert;
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetStack.stack) || (insert = simulate ? inventory.countSpace(stack, 1) : inventory.insert(stack, 1)) != 1) continue;
                stack.shrink(1);
                continue block0;
            }
        }
        for (ItemStack item : items) {
            if (item.isEmpty()) continue;
            return false;
        }
        if (!simulate) {
            crafter.checkCompletedRecipe(true);
        }
        return true;
    }
}

