/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum PlacementPatterns implements StringRepresentable
{
    Solid,
    Checkered,
    InverseCheckered,
    Chance25,
    Chance50,
    Chance75;

    public static final Codec<PlacementPatterns> CODEC;
    public static final StreamCodec<ByteBuf, PlacementPatterns> STREAM_CODEC;
    public final String translationKey = this.name().toLowerCase(Locale.ROOT);

    public static void applyPattern(List<BlockPos> blocksIn, ItemStack stack, RandomSource random) {
        PlacementPatterns pattern = (PlacementPatterns)((Object)stack.getOrDefault(AllDataComponents.PLACEMENT_PATTERN, (Object)Solid));
        Object filter = Predicates.alwaysFalse();
        switch (pattern.ordinal()) {
            case 3: {
                filter = pos -> random.nextBoolean() || random.nextBoolean();
                break;
            }
            case 4: {
                filter = pos -> random.nextBoolean();
                break;
            }
            case 5: {
                filter = pos -> random.nextBoolean() && random.nextBoolean();
                break;
            }
            case 1: {
                filter = pos -> (pos.getX() + pos.getY() + pos.getZ()) % 2 == 0;
                break;
            }
            case 2: {
                filter = pos -> (pos.getX() + pos.getY() + pos.getZ()) % 2 != 0;
                break;
            }
        }
        blocksIn.removeIf((Predicate<BlockPos>)filter);
    }

    @NotNull
    public String getSerializedName() {
        return this.translationKey;
    }

    static {
        CODEC = StringRepresentable.fromEnum(PlacementPatterns::values);
        STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(PlacementPatterns.class);
    }
}

