/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.items;

import com.google.common.collect.MapMaker;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.items.SidedInventoryWrapper;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface ItemInventoryProvider<T extends SmartBlockEntity>
extends WorldlyContainerHolder {
    public static final Map<Container, WorldlyContainer> WRAPPERS = new MapMaker().weakValues().makeMap();

    default public WorldlyContainer getContainer(BlockState state, LevelAccessor world, BlockPos pos) {
        Container inventory = this.getInventory(state, world, pos, null, null);
        if (inventory == null) {
            return null;
        }
        if (inventory instanceof WorldlyContainer) {
            WorldlyContainer sidedInventory = (WorldlyContainer)inventory;
            return sidedInventory;
        }
        return WRAPPERS.computeIfAbsent(inventory, SidedInventoryWrapper::new);
    }

    default public Container getInventory(@Nullable BlockState state, LevelAccessor world, BlockPos pos, @Nullable BlockEntity blockEntity, Direction context) {
        Class<T> expectedClass;
        if (blockEntity == null) {
            if (state == null) {
                state = world.getBlockState(pos);
            }
            if (state.hasBlockEntity()) {
                blockEntity = world.getBlockEntity(pos);
            }
            if (blockEntity == null) {
                return null;
            }
        } else if (state == null) {
            state = blockEntity.getBlockState();
        }
        if (!(expectedClass = this.getBlockEntityClass()).isInstance(blockEntity)) {
            return null;
        }
        return this.getInventory(world, pos, state, (SmartBlockEntity)blockEntity, context);
    }

    public Class<T> getBlockEntityClass();

    public Container getInventory(LevelAccessor var1, BlockPos var2, BlockState var3, T var4, Direction var5);
}

