/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.transfer;

import com.zurrtum.create.infrastructure.items.ItemInventory;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryWrapper<T extends Storage<ItemVariant>, S extends StorageView<ItemVariant>>
implements ItemInventory {
    protected T storage;
    protected int capacity;

    public InventoryWrapper(T storage) {
        this.storage = storage;
        this.init();
    }

    public static Container of(Storage<ItemVariant> storage) {
        InventoryWrapper inventory;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            inventory = new Slotted((SlottedStorage<ItemVariant>)slottedStorage);
        } else {
            inventory = new Direct(storage);
        }
        if (storage.supportsInsertion() && storage.supportsExtraction()) {
            return inventory;
        }
        return new Filter(inventory);
    }

    @Override
    public void clearContent() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                view.extract((Object)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
            }
            transaction.commit();
        }
    }

    public int count(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount);
    }

    public int count(ItemStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long extract = this.storage.extract((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)maxAmount, (TransactionContext)transaction);
            transaction.abort();
            int n = (int)extract;
            return n;
        }
    }

    public ItemStack count(Predicate<ItemStack> predicate) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                ItemStack itemStack = this.directCopy(stack, (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack count(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                ItemStack itemStack = this.directCopy(stack, (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public int countAll(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        long count = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (!predicate.test(((ItemVariantImpl)variant).getCachedStack()) || (count += view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction)) < (long)maxAmount) continue;
                transaction.abort();
                int n = maxAmount;
                return n;
            }
            transaction.abort();
        }
        return (int)count;
    }

    public ItemStack countAny() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                ItemStack itemStack = this.directCopy(stack, (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack countAny(int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.abort();
                ItemStack itemStack = this.directCopy(stack, (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public int countSpace(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount);
    }

    public int countSpace(ItemStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)maxAmount, (TransactionContext)transaction);
            transaction.abort();
            int n = (int)insert;
            return n;
        }
    }

    public boolean countSpace(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int count;
            ItemStack stack = stacks.getFirst();
            return this.countSpace(stack, count = stack.getCount()) == count;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int count;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            return this.countSpace(stack, count = entry.getIntValue()) == count;
        }
        try (Transaction transaction = Transaction.openOuter();){
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)count, (TransactionContext)transaction);
                if (insert >= (long)count) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            } while (iterator.hasNext());
            transaction.abort();
            boolean bl = true;
            return bl;
        }
    }

    public int countSpace(ItemStack stack, int maxAmount, int start, int end) {
        return this.countSpace(stack, maxAmount);
    }

    public boolean countSpace(List<ItemStack> stacks, int start, int end) {
        return this.countSpace(stacks);
    }

    public int extract(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount);
    }

    public int extract(ItemStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long extract = this.storage.extract((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)extract;
            return n;
        }
    }

    public ItemStack extract(Predicate<ItemStack> predicate) {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                ItemStack itemStack = this.directCopy(stack, (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                ItemStack itemStack = this.directCopy(stack, (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public List<ItemStack> extract(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int extract;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (extract = this.extract(stacks.getFirst(), count))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int extract;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (extract = this.extract(stack, count))) {
                return List.of();
            }
            if (extract == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - extract));
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean dirty = false;
            IdentityHashMap<ItemStack, ItemVariant> cache = new IdentityHashMap<ItemStack, ItemVariant>();
            block8: for (StorageView view : this.storage.nonEmptyViews()) {
                ObjectBidirectionalIterator iterator = entries.fastIterator();
                do {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    ItemStack stack = (ItemStack)entry.getKey();
                    int count = entry.getIntValue();
                    ItemVariant variant = cache.computeIfAbsent(stack, ItemVariant::of);
                    long extract = view.extract((Object)variant, (long)count, (TransactionContext)transaction);
                    if (extract == 0L) continue;
                    if (extract == (long)count) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            transaction.commit();
                            List<ItemStack> list = List.of();
                            return list;
                        }
                    } else {
                        entry.setValue(count - (int)extract);
                    }
                    dirty = true;
                    continue block8;
                } while (iterator.hasNext());
            }
            if (dirty) {
                ArrayList<ItemStack> result = new ArrayList<ItemStack>();
                for (Object2IntMap.Entry entry : entries) {
                    ItemStack stack = (ItemStack)entry.getKey();
                    int count = entry.getIntValue();
                    if (stack.getCount() == count) {
                        result.add(stack);
                        continue;
                    }
                    result.add(this.directCopy(stack, count));
                }
                transaction.commit();
                Object object = result;
                return object;
            }
            List<ItemStack> list = stacks;
            return list;
        }
    }

    public ItemStack extractAny() {
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant;
                long extract = view.extract((Object)(variant = (ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                ItemStack itemStack = this.directCopy(((ItemVariantImpl)variant).getCachedStack(), (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractAny(int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                long extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction);
                if (extract == 0L) continue;
                transaction.commit();
                ItemStack itemStack = this.directCopy(((ItemVariantImpl)variant).getCachedStack(), (int)extract);
                return itemStack;
            }
            transaction.abort();
        }
        return ItemStack.EMPTY;
    }

    public int extractAll(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return 0;
        }
        long remaining = maxAmount;
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (!predicate.test(((ItemVariantImpl)variant).getCachedStack())) continue;
                long extract = view.extract((Object)variant, remaining, (TransactionContext)transaction);
                if (extract == remaining) {
                    transaction.commit();
                    int n = maxAmount;
                    return n;
                }
                remaining -= extract;
            }
            transaction.commit();
        }
        return (int)((long)maxAmount - remaining);
    }

    public int forceInsert(ItemStack stack) {
        return this.insert(stack);
    }

    public int forceInsert(ItemStack stack, int maxAmount) {
        return this.insert(stack, maxAmount);
    }

    public boolean forcePreciseInsert(ItemStack stack) {
        return this.preciseInsert(stack);
    }

    public boolean forcePreciseInsert(ItemStack stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount);
    }

    public int getMaxStackSize() {
        return this.capacity;
    }

    protected abstract S getSlotView(int var1);

    public ItemStack getItem(int slot) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        S view = this.getSlotView(slot);
        if (view == null) {
            return ItemStack.EMPTY;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        return new ItemStack(variant.getRegistryEntry(), (int)view.getAmount(), variant.getComponents());
    }

    protected void init() {
        int max = 0;
        for (StorageView view : this.storage) {
            long capacity = view.getCapacity();
            if ((long)max <= capacity) continue;
            max = (int)capacity;
        }
        this.capacity = max;
    }

    protected abstract void insert(S var1, ItemVariant var2, int var3, Transaction var4);

    public int insert(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount);
    }

    public int insert(ItemStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)insert;
            return n;
        }
    }

    public List<ItemStack> insert(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            ItemStack stack = stacks.getFirst();
            int count = stack.getCount();
            if (count == (insert = this.insert(stacks.getFirst(), count))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            if (count == (insert = this.insert(stack, count))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(this.directCopy(stack, count - insert));
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean dirty = false;
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)count, (TransactionContext)transaction);
                if (insert == (long)count) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        transaction.commit();
                        List<ItemStack> list = List.of();
                        return list;
                    }
                    dirty = true;
                    continue;
                }
                if (insert == 0L) continue;
                entry.setValue(count - (int)insert);
                dirty = true;
            } while (iterator.hasNext());
            if (dirty) {
                ArrayList<ItemStack> result = new ArrayList<ItemStack>();
                for (Object2IntMap.Entry entry : entries) {
                    ItemStack stack = (ItemStack)entry.getKey();
                    int count = entry.getIntValue();
                    if (stack.getCount() == count) {
                        result.add(stack);
                        continue;
                    }
                    result.add(this.directCopy(stack, count));
                }
                transaction.commit();
                Object object = result;
                return object;
            }
            List<ItemStack> list = stacks;
            return list;
        }
    }

    public int insert(ItemStack stack, int maxAmount, int start, int end) {
        return this.insert(stack, maxAmount);
    }

    public List<ItemStack> insert(List<ItemStack> stacks, int start, int end) {
        return this.insert(stacks);
    }

    public int insertExist(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insertExist(stack, maxAmount);
    }

    public int insertExist(ItemStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)maxAmount, (TransactionContext)transaction);
            transaction.commit();
            int n = (int)insert;
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        java.util.Iterator iterator = this.storage.nonEmptyViews().iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return false;
        }
        return true;
    }

    @NotNull
    public java.util.Iterator<ItemStack> iterator() {
        return this.storage.supportsExtraction() ? new Iterator((Storage<ItemVariant>)this.storage) : Collections.emptyIterator();
    }

    public boolean preciseExtract(ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int amount = stack.getCount();
            long extract = this.storage.extract((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)amount, (TransactionContext)transaction);
            if (extract < (long)amount) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount) {
        if (maxAmount == 0) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : this.storage.nonEmptyViews()) {
                long extract;
                ItemVariant variant = (ItemVariant)view.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack) || (extract = this.storage.extract((Object)variant, (long)maxAmount, (TransactionContext)transaction)) == 0L) continue;
                if (extract == (long)maxAmount) {
                    transaction.commit();
                    ItemStack itemStack = this.directCopy(stack, maxAmount);
                    return itemStack;
                }
                transaction.abort();
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean preciseInsert(ItemStack stack) {
        int maxAmount = stack.getCount();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount);
    }

    public boolean preciseInsert(ItemStack stack, int maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)maxAmount, (TransactionContext)transaction);
            if (insert < (long)maxAmount) {
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public boolean preciseInsert(List<ItemStack> stacks) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst());
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
        for (ItemStack stack : stacks) {
            map.merge((Object)stack, stack.getCount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((ItemStack)entry.getKey(), entry.getIntValue());
        }
        try (Transaction transaction = Transaction.openOuter();){
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), (long)count, (TransactionContext)transaction);
                if (insert >= (long)count) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            } while (iterator.hasNext());
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        S view = this.getSlotView(slot);
        if (view == null) {
            return ItemStack.EMPTY;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        long amount = view.getAmount();
        if (variant.isBlank() || amount == 0L) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            amount = view.extract((Object)variant, amount, (TransactionContext)transaction);
            transaction.commit();
        }
        return new ItemStack(variant.getRegistryEntry(), (int)amount, variant.getComponents());
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        S view = this.getSlotView(slot);
        if (view == null) {
            return ItemStack.EMPTY;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        if (variant.isBlank() || view.getAmount() == 0L) {
            return ItemStack.EMPTY;
        }
        try (Transaction transaction = Transaction.openOuter();){
            amount = (int)view.extract((Object)variant, (long)amount, (TransactionContext)transaction);
            transaction.commit();
        }
        return new ItemStack(variant.getRegistryEntry(), amount, variant.getComponents());
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= this.getContainerSize()) {
            return;
        }
        S view = this.getSlotView(slot);
        if (view == null) {
            return;
        }
        ItemVariant variant = (ItemVariant)view.getResource();
        try (Transaction transaction = Transaction.openOuter();){
            if (variant.isBlank() || view.getAmount() == 0L) {
                if (stack.isEmpty()) {
                    return;
                }
                this.insert(view, ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), stack.getCount(), transaction);
            } else if (variant.matches(stack)) {
                int targetCount;
                int amount = stack.getCount();
                if (amount == (targetCount = (int)view.getAmount())) {
                    return;
                }
                int change = targetCount - amount;
                if (amount < targetCount) {
                    this.insert(view, variant, change, transaction);
                } else {
                    view.extract((Object)variant, (long)change, (TransactionContext)transaction);
                }
            } else {
                view.extract((Object)variant, view.getAmount(), (TransactionContext)transaction);
                this.insert(view, ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch()), stack.getCount(), transaction);
            }
            transaction.commit();
        }
    }

    public boolean update(Predicate<ItemStack> predicate, Function<ItemStack, ItemStack> update) {
        for (StorageView view : this.storage.nonEmptyViews()) {
            ItemVariant variant = (ItemVariant)view.getResource();
            ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
            if (!predicate.test(stack)) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                long amount = view.getAmount();
                ItemStack replace = update.apply(new ItemStack(variant.getRegistryEntry(), (int)amount, variant.getComponents()));
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)replace)) {
                    int count = replace.getCount();
                    if ((long)count == amount) {
                        boolean bl = true;
                        return bl;
                    }
                    long change = (long)count < amount ? view.extract((Object)variant, amount - (long)count, (TransactionContext)transaction) : this.storage.insert((Object)variant, (long)count - amount, (TransactionContext)transaction);
                    if (change == 0L) continue;
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
                long extract = view.extract((Object)variant, amount, (TransactionContext)transaction);
                if (extract != 0L) {
                    if (replace.isEmpty()) {
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    long insert = this.storage.insert((Object)ItemVariant.of((ItemLike)replace.getItem(), (DataComponentPatch)replace.getComponentsPatch()), (long)replace.getCount(), (TransactionContext)transaction);
                    if (insert != 0L) {
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                }
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        return false;
    }

    public Stream<ItemStack> stream() {
        return this.storage.supportsExtraction() ? ItemInventory.super.stream() : Stream.empty();
    }

    protected static class Slotted
    extends InventoryWrapper<SlottedStorage<ItemVariant>, SingleSlotStorage<ItemVariant>> {
        public Slotted(SlottedStorage<ItemVariant> storage) {
            super(storage);
        }

        @Override
        protected SingleSlotStorage<ItemVariant> getSlotView(int slot) {
            return ((SlottedStorage)this.storage).getSlot(slot);
        }

        @Override
        protected void insert(SingleSlotStorage<ItemVariant> view, ItemVariant variant, int amount, Transaction transaction) {
            view.insert((Object)variant, (long)amount, (TransactionContext)transaction);
        }

        @Override
        public int insertExist(ItemStack stack) {
            if (stack.isEmpty()) {
                return 0;
            }
            try (Transaction transaction = Transaction.openOuter();){
                ArrayList<SingleSlotStorage> emptys = new ArrayList<SingleSlotStorage>();
                ItemVariant variant = ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch());
                int maxAmount = stack.getCount();
                long remaining = maxAmount;
                int size = ((SlottedStorage)this.storage).getSlotCount();
                for (int i = 0; i < size; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    if (target.getAmount() == 0L || target.isResourceBlank()) {
                        emptys.add(target);
                        continue;
                    }
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                for (SingleSlotStorage target : emptys) {
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.commit();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public int countSpace(ItemStack stack, int maxAmount, int start, int end) {
            try (Transaction transaction = Transaction.openOuter();){
                ItemVariant variant = ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch());
                long remaining = maxAmount;
                for (int i = start; i <= end; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.abort();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.abort();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public boolean countSpace(List<ItemStack> stacks, int start, int end) {
            int listSize = stacks.size();
            if (listSize == 0) {
                return true;
            }
            if (listSize == 1) {
                int count;
                ItemStack stack = stacks.getFirst();
                return this.countSpace(stack, count = stack.getCount(), start, end) == count;
            }
            Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
            for (ItemStack stack : stacks) {
                map.merge((Object)stack, stack.getCount(), Integer::sum);
            }
            Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
            if (entries.size() == 1) {
                int count;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
                ItemStack stack = (ItemStack)entry.getKey();
                return this.countSpace(stack, count = entry.getIntValue(), start, end) == count;
            }
            try (Transaction transaction = Transaction.openOuter();){
                ObjectBidirectionalIterator iterator = entries.fastIterator();
                do {
                    SingleSlotStorage target;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    ItemStack stack = (ItemStack)entry.getKey();
                    int count = entry.getIntValue();
                    ItemVariant variant = ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch());
                    long remaining = count;
                    for (int i = start; i <= end && (remaining -= (target = ((SlottedStorage)this.storage).getSlot(i)).insert((Object)variant, remaining, (TransactionContext)transaction)) != 0L; ++i) {
                    }
                    if (remaining == 0L) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue;
                        transaction.abort();
                        boolean bl = true;
                        return bl;
                    }
                    if (remaining == (long)count) continue;
                    entry.setValue((int)remaining);
                } while (iterator.hasNext());
                transaction.abort();
                boolean bl = false;
                return bl;
            }
        }

        @Override
        public int insert(ItemStack stack, int maxAmount, int start, int end) {
            try (Transaction transaction = Transaction.openOuter();){
                ItemVariant variant = ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch());
                long remaining = maxAmount;
                for (int i = start; i <= end; ++i) {
                    SingleSlotStorage target = ((SlottedStorage)this.storage).getSlot(i);
                    long insert = target.insert((Object)variant, remaining, (TransactionContext)transaction);
                    if (insert == remaining) {
                        transaction.commit();
                        int n = maxAmount;
                        return n;
                    }
                    remaining -= insert;
                }
                transaction.commit();
                int n = maxAmount - (int)remaining;
                return n;
            }
        }

        @Override
        public List<ItemStack> insert(List<ItemStack> stacks) {
            int listSize = stacks.size();
            if (listSize == 0) {
                return stacks;
            }
            if (listSize == 1) {
                int insert;
                ItemStack stack = stacks.getFirst();
                int count = stack.getCount();
                if (count == (insert = this.insert(stacks.getFirst(), count))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
            for (ItemStack stack : stacks) {
                map.merge((Object)stack, stack.getCount(), Integer::sum);
            }
            Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
            if (entries.size() == 1) {
                int insert;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (count == (insert = this.insert(stack, count))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            try (Transaction transaction = Transaction.openOuter();){
                boolean dirty = false;
                IdentityHashMap<ItemStack, ItemVariant> cache = new IdentityHashMap<ItemStack, ItemVariant>();
                int size = ((SlottedStorage)this.storage).getSlotCount();
                block8: for (int i = 0; i < size; ++i) {
                    SingleSlotStorage slot = ((SlottedStorage)this.storage).getSlot(i);
                    ObjectBidirectionalIterator iterator = entries.fastIterator();
                    do {
                        Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                        ItemStack stack = (ItemStack)entry.getKey();
                        int count = entry.getIntValue();
                        ItemVariant variant = cache.computeIfAbsent(stack, ItemVariant::of);
                        long insert = slot.insert((Object)variant, (long)count, (TransactionContext)transaction);
                        if (insert == 0L) continue;
                        if (insert == (long)count) {
                            iterator.remove();
                            if (entries.isEmpty()) {
                                transaction.commit();
                                List<ItemStack> list = List.of();
                                return list;
                            }
                        } else {
                            entry.setValue(count - (int)insert);
                        }
                        dirty = true;
                        continue block8;
                    } while (iterator.hasNext());
                }
                if (dirty) {
                    ArrayList<ItemStack> result = new ArrayList<ItemStack>();
                    for (Object2IntMap.Entry entry : entries) {
                        ItemStack stack = (ItemStack)entry.getKey();
                        int count = entry.getIntValue();
                        if (stack.getCount() == count) {
                            result.add(stack);
                            continue;
                        }
                        result.add(this.directCopy(stack, count));
                    }
                    transaction.commit();
                    Object object = result;
                    return object;
                }
                List<ItemStack> list = stacks;
                return list;
            }
        }

        @Override
        public List<ItemStack> insert(List<ItemStack> stacks, int start, int end) {
            int listSize = stacks.size();
            if (listSize == 0) {
                return stacks;
            }
            if (listSize == 1) {
                int insert;
                ItemStack stack = stacks.getFirst();
                int count = stack.getCount();
                if (count == (insert = this.insert(stacks.getFirst(), count, start, end))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(ITEM_STACK_HASH_STRATEGY);
            for (ItemStack stack : stacks) {
                map.merge((Object)stack, stack.getCount(), Integer::sum);
            }
            Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
            if (entries.size() == 1) {
                int insert;
                Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
                ItemStack stack = (ItemStack)entry.getKey();
                int count = entry.getIntValue();
                if (count == (insert = this.insert(stack, count, start, end))) {
                    return List.of();
                }
                if (insert == 0) {
                    return stacks;
                }
                return List.of(this.directCopy(stack, count - insert));
            }
            try (Transaction transaction = Transaction.openOuter();){
                boolean dirty = false;
                ObjectBidirectionalIterator iterator = entries.fastIterator();
                do {
                    SingleSlotStorage target;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    ItemStack stack = (ItemStack)entry.getKey();
                    int count = entry.getIntValue();
                    ItemVariant variant = ItemVariant.of((ItemLike)stack.getItem(), (DataComponentPatch)stack.getComponentsPatch());
                    long remaining = count;
                    for (int i = start; i <= end && (remaining -= (target = ((SlottedStorage)this.storage).getSlot(i)).insert((Object)variant, remaining, (TransactionContext)transaction)) != 0L; ++i) {
                    }
                    if (remaining == 0L) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            transaction.commit();
                            List<ItemStack> list = List.of();
                            return list;
                        }
                        dirty = true;
                        continue;
                    }
                    if (remaining == (long)count) continue;
                    entry.setValue((int)remaining);
                    dirty = true;
                } while (iterator.hasNext());
                if (dirty) {
                    ArrayList<ItemStack> result = new ArrayList<ItemStack>();
                    for (Object2IntMap.Entry entry : entries) {
                        ItemStack stack = (ItemStack)entry.getKey();
                        int count = entry.getIntValue();
                        if (stack.getCount() == count) {
                            result.add(stack);
                            continue;
                        }
                        result.add(this.directCopy(stack, count));
                    }
                    transaction.commit();
                    Object object = result;
                    return object;
                }
                List<ItemStack> list = stacks;
                return list;
            }
        }

        @Override
        public boolean update(Predicate<ItemStack> predicate, Function<ItemStack, ItemStack> update) {
            int size = ((SlottedStorage)this.storage).getSlotCount();
            for (int i = 0; i < size; ++i) {
                SingleSlotStorage slot = ((SlottedStorage)this.storage).getSlot(i);
                ItemVariant variant = (ItemVariant)slot.getResource();
                ItemStack stack = ((ItemVariantImpl)variant).getCachedStack();
                if (!predicate.test(stack)) continue;
                try (Transaction transaction = Transaction.openOuter();){
                    long amount = slot.getAmount();
                    ItemStack replace = update.apply(new ItemStack(variant.getRegistryEntry(), (int)amount, variant.getComponents()));
                    if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)replace)) {
                        int count = replace.getCount();
                        if ((long)count == amount) {
                            boolean bl = true;
                            return bl;
                        }
                        long change = (long)count < amount ? slot.extract((Object)variant, amount - (long)count, (TransactionContext)transaction) : slot.insert((Object)variant, (long)count - amount, (TransactionContext)transaction);
                        if (change == 0L) continue;
                        transaction.commit();
                        boolean bl = true;
                        return bl;
                    }
                    long extract = slot.extract((Object)variant, amount, (TransactionContext)transaction);
                    if (extract != 0L) {
                        if (replace.isEmpty()) {
                            transaction.commit();
                            boolean bl = true;
                            return bl;
                        }
                        long insert = slot.insert((Object)ItemVariant.of((ItemLike)replace.getItem(), (DataComponentPatch)replace.getComponentsPatch()), (long)replace.getCount(), (TransactionContext)transaction);
                        if (insert != 0L) {
                            transaction.commit();
                            boolean bl = true;
                            return bl;
                        }
                    }
                    transaction.abort();
                    boolean bl = false;
                    return bl;
                }
            }
            return false;
        }

        public int getContainerSize() {
            return ((SlottedStorage)this.storage).getSlotCount();
        }
    }

    protected static class Direct
    extends InventoryWrapper<Storage<ItemVariant>, StorageView<ItemVariant>> {
        private int size;

        public Direct(Storage<ItemVariant> storage) {
            super(storage);
        }

        @Override
        protected StorageView<ItemVariant> getSlotView(int slot) {
            int current = 0;
            for (StorageView view : this.storage) {
                if (current == slot) {
                    return view;
                }
                ++current;
            }
            return null;
        }

        @Override
        protected void init() {
            int count = 0;
            int max = 0;
            for (StorageView view : this.storage) {
                long capacity = view.getCapacity();
                if ((long)max < capacity) {
                    max = (int)capacity;
                }
                ++count;
            }
            this.size = count;
            this.capacity = max;
        }

        @Override
        protected void insert(StorageView<ItemVariant> view, ItemVariant variant, int amount, Transaction transaction) {
            this.storage.insert((Object)variant, (long)amount, (TransactionContext)transaction);
        }

        public int getContainerSize() {
            return this.size;
        }
    }

    public static class Filter
    implements SidedItemInventory {
        private final int[] slots;
        private final boolean canInsert;
        private final boolean canExtract;
        private final InventoryWrapper<?, ?> inventory;

        public Filter(InventoryWrapper<?, ?> inventory) {
            this.inventory = inventory;
            this.slots = SlotRangeCache.get(inventory.getContainerSize());
            this.canInsert = inventory.storage.supportsInsertion();
            this.canExtract = inventory.storage.supportsExtraction();
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
            return this.canExtract;
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
            return this.canInsert;
        }

        @Override
        public void clearContent() {
            if (!this.canExtract) {
                return;
            }
            this.inventory.clearContent();
        }

        public int count(ItemStack stack, Direction side) {
            return this.count(stack);
        }

        public int count(ItemStack stack) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.count(stack);
        }

        public int count(ItemStack stack, int maxAmount, Direction side) {
            return this.count(stack, maxAmount);
        }

        public int count(ItemStack stack, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.count(stack, maxAmount);
        }

        public ItemStack count(Predicate<ItemStack> predicate, Direction side) {
            return this.count(predicate);
        }

        public ItemStack count(Predicate<ItemStack> predicate) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.count(predicate);
        }

        public ItemStack count(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
            return this.count(predicate, maxAmount);
        }

        public ItemStack count(Predicate<ItemStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.count(predicate, maxAmount);
        }

        public int countAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
            return this.countAll(predicate, maxAmount);
        }

        public int countAll(Predicate<ItemStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.countAll(predicate, maxAmount);
        }

        public ItemStack countAny(Direction side) {
            return this.countAny();
        }

        public ItemStack countAny() {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.countAny();
        }

        public ItemStack countAny(int maxAmount, Direction side) {
            return this.countAny(maxAmount);
        }

        public ItemStack countAny(int maxAmount) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.countAny(maxAmount);
        }

        public int countSpace(ItemStack stack, Direction side) {
            return this.countSpace(stack);
        }

        public int countSpace(ItemStack stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.countSpace(stack);
        }

        public int countSpace(ItemStack stack, int maxAmount, Direction side) {
            return this.countSpace(stack, maxAmount);
        }

        public int countSpace(ItemStack stack, int maxAmount) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.countSpace(stack, maxAmount);
        }

        public boolean countSpace(List<ItemStack> stacks, Direction side) {
            return this.countSpace(stacks);
        }

        public boolean countSpace(List<ItemStack> stacks) {
            if (!this.canInsert) {
                return false;
            }
            return this.inventory.countSpace(stacks);
        }

        public int extract(ItemStack stack, Direction side) {
            return this.extract(stack);
        }

        public int extract(ItemStack stack) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extract(stack);
        }

        public int extract(ItemStack stack, int maxAmount, Direction side) {
            return this.extract(stack, maxAmount);
        }

        public int extract(ItemStack stack, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extract(stack, maxAmount);
        }

        public ItemStack extract(Predicate<ItemStack> predicate, Direction side) {
            return this.extract(predicate);
        }

        public ItemStack extract(Predicate<ItemStack> predicate) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.extract(predicate);
        }

        public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
            return this.extract(predicate, maxAmount);
        }

        public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.extract(predicate, maxAmount);
        }

        public List<ItemStack> extract(List<ItemStack> stacks, Direction side) {
            return this.extract(stacks);
        }

        public List<ItemStack> extract(List<ItemStack> stacks) {
            if (!this.canExtract) {
                return stacks;
            }
            return this.inventory.extract(stacks);
        }

        public int extractAll(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
            return this.extractAll(predicate, maxAmount);
        }

        public int extractAll(Predicate<ItemStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return 0;
            }
            return this.inventory.extractAll(predicate, maxAmount);
        }

        public ItemStack extractAny(Direction side) {
            return this.extractAny();
        }

        public ItemStack extractAny() {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.extractAny();
        }

        public ItemStack extractAny(int maxAmount, Direction side) {
            return this.extractAny(maxAmount);
        }

        public ItemStack extractAny(int maxAmount) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.extractAny(maxAmount);
        }

        public int forceInsert(ItemStack stack) {
            return this.inventory.forceInsert(stack);
        }

        public int forceInsert(ItemStack stack, int maxAmount) {
            return this.inventory.forceInsert(stack, maxAmount);
        }

        public boolean forcePreciseInsert(ItemStack stack) {
            return this.inventory.forcePreciseInsert(stack);
        }

        public boolean forcePreciseInsert(ItemStack stack, int maxAmount) {
            return this.inventory.forcePreciseInsert(stack, maxAmount);
        }

        public int[] getSlotsForFace(Direction side) {
            return this.slots;
        }

        public int getMaxStackSize() {
            return this.inventory.getMaxStackSize();
        }

        public ItemStack getItem(int slot) {
            return this.inventory.getItem(slot);
        }

        public int insert(ItemStack stack, Direction side) {
            return this.insert(stack);
        }

        public int insert(ItemStack stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack);
        }

        public int insert(ItemStack stack, int maxAmount, Direction side) {
            return this.insert(stack, maxAmount);
        }

        public int insert(ItemStack stack, int maxAmount) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack, maxAmount);
        }

        public int insert(ItemStack stack, int maxAmount, int start, int end, Direction side) {
            return this.insert(stack, maxAmount);
        }

        public int insert(ItemStack stack, int maxAmount, int start, int end) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insert(stack, maxAmount, start, end);
        }

        public List<ItemStack> insert(List<ItemStack> stacks, Direction side) {
            return this.insert(stacks);
        }

        public List<ItemStack> insert(List<ItemStack> stacks) {
            if (!this.canInsert) {
                return stacks;
            }
            return this.inventory.insert(stacks);
        }

        public List<ItemStack> insert(List<ItemStack> stacks, int start, int end, Direction side) {
            return this.insert(stacks, start, end);
        }

        public List<ItemStack> insert(List<ItemStack> stacks, int start, int end) {
            if (!this.canInsert) {
                return stacks;
            }
            return this.inventory.insert(stacks, start, end);
        }

        public int insertExist(ItemStack stack, Direction side) {
            return this.insertExist(stack);
        }

        public int insertExist(ItemStack stack) {
            if (!this.canInsert) {
                return 0;
            }
            return this.inventory.insertExist(stack);
        }

        public int insertExist(ItemStack stack, int maxAmount, Direction side) {
            if (!this.canInsert) {
                return 0;
            }
            return this.insertExist(stack, maxAmount);
        }

        public int insertExist(ItemStack stack, int maxAmount) {
            return this.inventory.insertExist(stack, maxAmount);
        }

        @Override
        public boolean isEmpty() {
            return this.inventory.isEmpty();
        }

        @NotNull
        public java.util.Iterator<ItemStack> iterator() {
            return this.inventory.iterator();
        }

        @NotNull
        public java.util.Iterator<ItemStack> iterator(Direction side) {
            return this.inventory.iterator();
        }

        public boolean preciseExtract(ItemStack stack, Direction side) {
            return this.preciseExtract(stack);
        }

        public boolean preciseExtract(ItemStack stack) {
            if (!this.canExtract) {
                return stack.isEmpty();
            }
            return this.inventory.preciseExtract(stack);
        }

        public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount, Direction side) {
            return this.preciseExtract(predicate, maxAmount);
        }

        public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.preciseExtract(predicate, maxAmount);
        }

        public boolean preciseInsert(ItemStack stack, Direction side) {
            return this.preciseInsert(stack);
        }

        public boolean preciseInsert(ItemStack stack) {
            if (!this.canInsert) {
                return stack.isEmpty();
            }
            return this.inventory.preciseInsert(stack);
        }

        public boolean preciseInsert(ItemStack stack, int maxAmount, Direction side) {
            return this.preciseInsert(stack, maxAmount);
        }

        public boolean preciseInsert(ItemStack stack, int maxAmount) {
            if (!this.canInsert) {
                return stack.isEmpty();
            }
            return this.inventory.preciseInsert(stack, maxAmount);
        }

        public boolean preciseInsert(List<ItemStack> stacks, Direction side) {
            return this.preciseInsert(stacks);
        }

        public boolean preciseInsert(List<ItemStack> stacks) {
            if (!this.canInsert) {
                return false;
            }
            return this.inventory.preciseInsert(stacks);
        }

        @Override
        public ItemStack removeItemNoUpdate(int slot) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.removeItemNoUpdate(slot);
        }

        @Override
        public ItemStack removeItem(int slot, int amount) {
            if (!this.canExtract) {
                return ItemStack.EMPTY;
            }
            return this.inventory.removeItem(slot, amount);
        }

        public void setItem(int slot, ItemStack stack) {
            this.inventory.setItem(slot, stack);
        }

        public int getContainerSize() {
            return this.inventory.getContainerSize();
        }

        public Stream<ItemStack> stream() {
            return this.inventory.stream();
        }

        public Stream<ItemStack> stream(Direction side) {
            return this.inventory.stream();
        }
    }

    static class Iterator
    implements java.util.Iterator<ItemStack> {
        private final java.util.Iterator<StorageView<ItemVariant>> iterator;

        public Iterator(Storage<ItemVariant> storage) {
            this.iterator = storage.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ItemStack next() {
            StorageView<ItemVariant> view = this.iterator.next();
            if (view.getAmount() == 0L || view.isResourceBlank()) {
                return ItemStack.EMPTY;
            }
            ItemVariant variant = (ItemVariant)view.getResource();
            return new ItemStack(variant.getRegistryEntry(), (int)view.getAmount(), variant.getComponents());
        }
    }
}

