/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.burner;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BlazeBurnerBlockEntity
extends SmartBlockEntity {
    public static final int MAX_HEAT_CAPACITY = 10000;
    public static final int INSERTION_THRESHOLD = 500;
    public LerpedFloat headAnimation;
    public boolean stockKeeper = false;
    public boolean isCreative = false;
    public boolean goggles = false;
    public boolean hat;
    protected FuelType activeFuel = FuelType.NONE;
    protected int remainingBurnTime = 0;
    public LerpedFloat headAngle;

    public BlazeBurnerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.HEATER, pos, state);
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((AngleHelper.horizontalAngle((class_2350)state.method_61767((class_2769)BlazeBurnerBlock.field_11177, (Comparable)class_2350.field_11035)) + 180.0f) % 360.0f);
    }

    public FuelType getActiveFuel() {
        return this.activeFuel;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            AllClientHandle.INSTANCE.tickBlazeBurnerAnimation(this);
            if (!this.isVirtual()) {
                this.spawnParticles(this.getHeatLevelFromBlock(), 1.0);
            }
            return;
        }
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
        if (this.activeFuel == FuelType.NORMAL) {
            this.updateBlockState();
        }
        if (this.remainingBurnTime > 0) {
            return;
        }
        if (this.activeFuel == FuelType.SPECIAL) {
            this.activeFuel = FuelType.NORMAL;
            this.remainingBurnTime = 5000;
        } else {
            this.activeFuel = FuelType.NONE;
        }
        this.updateBlockState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.stockKeeper = BlazeBurnerBlockEntity.getStockTicker((class_1936)this.field_11863, this.field_11867) != null;
    }

    @Nullable
    public static StockTickerBlockEntity getStockTicker(class_1936 level, class_2338 pos) {
        for (class_2350 direction : Iterate.horizontalDirections) {
            class_2586 class_25862;
            class_1937 l;
            if (level instanceof class_1937 && !(l = (class_1937)level).method_8477(pos)) {
                return null;
            }
            class_2680 blockState = level.method_8320(pos.method_10093(direction));
            if (!blockState.method_27852((class_2248)AllBlocks.STOCK_TICKER) || !((class_25862 = level.method_8321(pos.method_10093(direction))) instanceof StockTickerBlockEntity)) continue;
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)class_25862;
            return stbe;
        }
        return null;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (!this.isCreative) {
            view.method_71465("fuelLevel", this.activeFuel.ordinal());
            view.method_71465("burnTimeRemaining", this.remainingBurnTime);
        } else {
            view.method_71472("isCreative", true);
        }
        if (this.goggles) {
            view.method_71472("Goggles", true);
        }
        if (this.hat) {
            view.method_71472("TrainHat", true);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.activeFuel = FuelType.values()[view.method_71424("fuelLevel", 0)];
        this.remainingBurnTime = view.method_71424("burnTimeRemaining", 0);
        this.isCreative = view.method_71433("isCreative", false);
        this.goggles = view.method_71433("Goggles", false);
        this.hat = view.method_71433("TrainHat", false);
        super.read(view, clientPacket);
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf(this.method_11010());
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelForRender() {
        BlazeBurnerBlock.HeatLevel heatLevel = this.getHeatLevelFromBlock();
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && this.stockKeeper) {
            return BlazeBurnerBlock.HeatLevel.FADING;
        }
        return heatLevel;
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState == heat) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)heat)));
        this.notifyUpdate();
    }

    protected boolean tryUpdateFuel(class_1799 itemStack, boolean forceOverflow, boolean simulate) {
        int newBurnTime;
        if (this.isCreative) {
            return false;
        }
        FuelType newFuel = FuelType.NONE;
        if (itemStack.method_41409().method_40220(AllItemTags.BLAZE_BURNER_FUEL_SPECIAL)) {
            newBurnTime = 3200;
            newFuel = FuelType.SPECIAL;
        } else {
            newBurnTime = this.field_11863.method_61269().method_61755(itemStack);
            if (newBurnTime > 0) {
                newFuel = FuelType.NORMAL;
            } else if (itemStack.method_41409().method_40220(AllItemTags.BLAZE_BURNER_FUEL_REGULAR)) {
                newBurnTime = 1600;
                newFuel = FuelType.NORMAL;
            }
        }
        if (newFuel == FuelType.NONE) {
            return false;
        }
        if (newFuel.ordinal() < this.activeFuel.ordinal()) {
            return false;
        }
        if (newFuel == this.activeFuel) {
            if (this.remainingBurnTime <= 500) {
                newBurnTime += this.remainingBurnTime;
            } else if (forceOverflow && newFuel == FuelType.NORMAL) {
                newBurnTime = this.remainingBurnTime < 10000 ? Math.min(this.remainingBurnTime + newBurnTime, 10000) : this.remainingBurnTime;
            } else {
                return false;
            }
        }
        if (simulate) {
            return true;
        }
        this.activeFuel = newFuel;
        this.remainingBurnTime = newBurnTime;
        if (this.field_11863.method_8608()) {
            this.spawnParticleBurst(this.activeFuel == FuelType.SPECIAL);
            return true;
        }
        BlazeBurnerBlock.HeatLevel prev = this.getHeatLevelFromBlock();
        this.playSound();
        this.updateBlockState();
        if (prev != this.getHeatLevelFromBlock()) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14991, class_3419.field_15245, 0.125f + this.field_11863.field_9229.method_43057() * 0.125f, 1.15f - this.field_11863.field_9229.method_43057() * 0.25f);
        }
        return true;
    }

    protected void applyCreativeFuel() {
        this.activeFuel = FuelType.NONE;
        this.remainingBurnTime = 0;
        this.isCreative = true;
        BlazeBurnerBlock.HeatLevel next = this.getHeatLevelFromBlock().nextActiveLevel();
        if (this.field_11863.method_8608()) {
            this.spawnParticleBurst(next.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING));
            return;
        }
        this.playSound();
        if (next == BlazeBurnerBlock.HeatLevel.FADING) {
            next = next.nextActiveLevel();
        }
        this.setBlockHeat(next);
    }

    public boolean isCreativeFuel(class_1799 stack) {
        return stack.method_31574(AllItems.CREATIVE_BLAZE_CAKE);
    }

    public boolean isValidBlockAbove() {
        if (this.isVirtual()) {
            return false;
        }
        class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10084());
        return BasinBlock.isBasin((class_4538)this.field_11863, this.field_11867.method_10084()) || blockState.method_26204() instanceof FluidTankBlock;
    }

    protected void playSound() {
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14970, class_3419.field_15245, 0.125f + this.field_11863.field_9229.method_43057() * 0.125f, 0.75f - this.field_11863.field_9229.method_43057() * 0.25f);
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        switch (this.activeFuel.ordinal()) {
            case 2: {
                level = BlazeBurnerBlock.HeatLevel.SEETHING;
                break;
            }
            case 1: {
                boolean lowPercent = (double)this.remainingBurnTime / 10000.0 < 0.0125;
                level = lowPercent ? BlazeBurnerBlock.HeatLevel.FADING : BlazeBurnerBlock.HeatLevel.KINDLED;
            }
        }
        return level;
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.field_11863 == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        class_5819 r = this.field_11863.method_8409();
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_243 v = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, 0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.method_43048(4) != 0) {
            return;
        }
        boolean empty = this.field_11863.method_8320(this.field_11867.method_10084()).method_26220((class_1922)this.field_11863, this.field_11867.method_10084()).method_1110();
        if (empty || r.method_43048(8) == 0) {
            this.field_11863.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : r.method_43058() * (double)0.0125f;
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, 0.5f).method_18805(1.0, 0.25, 1.0).method_1029().method_1021((empty ? 0.25 : 0.5) + r.method_43058() * 0.125)).method_1031(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_22246, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_11240, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        }
    }

    public void spawnParticleBurst(boolean soulFlame) {
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_5819 r = this.field_11863.field_9229;
        for (int i = 0; i < 20; ++i) {
            class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, r, 0.5f).method_18805(1.0, 0.25, 1.0).method_1029();
            class_243 v = c.method_1019(offset.method_1021(0.5 + r.method_43058() * 0.125)).method_1031(0.0, 0.125, 0.0);
            class_243 m = offset.method_1021(0.03125);
            this.field_11863.method_8406((class_2394)(soulFlame ? class_2398.field_22246 : class_2398.field_11240), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    public static enum FuelType {
        NONE,
        NORMAL,
        SPECIAL;

    }
}

