/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.display;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_8824;

public class FlapDisplaySection {
    static final Map<String, String[]> LOADED_FLAP_CYCLES = new HashMap<String, String[]>();
    public static final float MONOSPACE = 7.0f;
    public static final float WIDE_MONOSPACE = 9.0f;
    float size;
    boolean singleFlap;
    public boolean hasGap;
    boolean rightAligned;
    public boolean wideFlaps;
    boolean sendTransition;
    String cycle;
    class_2561 component;
    public String[] cyclingOptions;
    public boolean[] spinning;
    public int spinningTicks;
    public String text;

    public FlapDisplaySection(float width, String cycle, boolean singleFlap, boolean hasGap) {
        this.size = width;
        this.cycle = cycle;
        this.hasGap = hasGap;
        this.singleFlap = singleFlap;
        this.spinning = new boolean[singleFlap ? 1 : Math.max(0, (int)(width / 7.0f))];
        this.text = Strings.repeat((String)" ", (int)this.spinning.length);
        this.component = null;
    }

    public FlapDisplaySection rightAligned() {
        this.rightAligned = true;
        return this;
    }

    public FlapDisplaySection wideFlaps() {
        this.wideFlaps = true;
        return this;
    }

    public void setText(class_2561 component) {
        this.component = component;
        this.sendTransition = true;
    }

    public void refresh(boolean transition) {
        if (this.component == null) {
            return;
        }
        Object newText = this.component.getString();
        if (!this.singleFlap) {
            if (this.rightAligned) {
                newText = ((String)newText).trim();
            }
            newText = ((String)newText).toUpperCase(Locale.ROOT);
            newText = ((String)newText).substring(0, Math.min(this.spinning.length, ((String)newText).length()));
            String whitespace = Strings.repeat((String)" ", (int)(this.spinning.length - ((String)newText).length()));
            Object object = newText = this.rightAligned ? whitespace + (String)newText : (String)newText + whitespace;
            if (!this.text.isEmpty()) {
                for (int i = 0; i < this.spinning.length; ++i) {
                    int n = i;
                    this.spinning[n] = this.spinning[n] | (transition && this.text.charAt(i) != ((String)newText).charAt(i));
                }
            }
        } else if (!this.text.isEmpty()) {
            this.spinning[0] = this.spinning[0] | (transition && !((String)newText).equals(this.text));
        }
        this.text = newText;
        this.spinningTicks = 0;
    }

    public int tick(boolean instant, class_5819 random) {
        if (this.cyclingOptions == null) {
            return 0;
        }
        int max = Math.max(4, (int)((float)this.cyclingOptions.length * 1.75f));
        if (this.spinningTicks > max) {
            return 0;
        }
        ++this.spinningTicks;
        if (this.spinningTicks <= max && this.spinningTicks < 2) {
            return this.spinningTicks == 1 ? 0 : this.spinning.length;
        }
        int spinningFlaps = 0;
        for (int i = 0; i < this.spinning.length; ++i) {
            int increasingChance = class_3532.method_15340((int)(8 - this.spinningTicks), (int)1, (int)10);
            boolean continueSpin = !instant && random.method_43048(increasingChance * max / 4) != 0;
            boolean bl = max > 5 || this.spinningTicks < 2;
            int n = i;
            this.spinning[n] = this.spinning[n] & (continueSpin &= bl);
            if (i > 0 && random.method_43048(3) > 0) {
                int n2 = i - 1;
                this.spinning[n2] = this.spinning[n2] & continueSpin;
            }
            if (i < this.spinning.length - 1 && random.method_43048(3) > 0) {
                int n3 = i + 1;
                this.spinning[n3] = this.spinning[n3] & continueSpin;
            }
            if (this.spinningTicks > max) {
                this.spinning[i] = false;
            }
            if (!this.spinning[i]) continue;
            ++spinningFlaps;
        }
        return spinningFlaps;
    }

    public float getSize() {
        return this.size;
    }

    public void write(class_11372 view) {
        view.method_71464("Width", this.size);
        view.method_71469("Cycle", this.cycle);
        if (this.rightAligned) {
            view.method_71472("RightAligned", true);
        }
        if (this.singleFlap) {
            view.method_71472("SingleFlap", true);
        }
        if (this.hasGap) {
            view.method_71472("Gap", true);
        }
        if (this.wideFlaps) {
            view.method_71472("Wide", true);
        }
        if (this.component != null) {
            view.method_71468("Text", class_8824.field_46597, (Object)this.component);
        }
        if (this.sendTransition) {
            view.method_71472("Transition", true);
        }
        this.sendTransition = false;
    }

    public static FlapDisplaySection load(class_11368 view) {
        float width = view.method_71423("Width", 0.0f);
        String cycle = view.method_71428("Cycle", "");
        boolean singleFlap = view.method_71433("SingleFlap", false);
        boolean hasGap = view.method_71433("Gap", false);
        FlapDisplaySection section = new FlapDisplaySection(width, cycle, singleFlap, hasGap);
        section.cyclingOptions = FlapDisplaySection.getFlapCycle(cycle);
        section.rightAligned = view.method_71433("RightAligned", false);
        section.wideFlaps = view.method_71433("Wide", false);
        view.method_71426("Text", class_8824.field_46597).ifPresent(text -> {
            section.component = text;
            section.refresh(view.method_71433("Transition", false));
        });
        return section;
    }

    public void update(class_11368 view) {
        view.method_71426("Text", class_8824.field_46597).ifPresent(text -> {
            this.component = text;
        });
        if (this.cyclingOptions == null) {
            this.cyclingOptions = FlapDisplaySection.getFlapCycle(this.cycle);
        }
        this.refresh(view.method_71433("Transition", false));
    }

    public boolean renderCharsIndividually() {
        return !this.singleFlap;
    }

    public class_2561 getText() {
        return this.component;
    }

    public static String[] getFlapCycle(String key) {
        return LOADED_FLAP_CYCLES.computeIfAbsent(key, k -> class_2561.method_43471((String)("create.flap_display.cycles." + key)).getString().split(";"));
    }
}

