package com.zurrtum.create.catnip.math;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_9139;

public class BlockFace extends Pair<class_2338, class_2350> {
    public static Codec<BlockFace> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_2338.field_25064.fieldOf("pos")
            .forGetter(BlockFace::getPos), class_2350.field_29502.fieldOf("direction").forGetter(BlockFace::getFace)
    ).apply(instance, BlockFace::new));

    public static class_9139<class_2540, BlockFace> STREAM_CODEC = class_9139.method_56435(
        class_2338.field_48404,
        BlockFace::getPos,
        class_2350.field_48450,
        BlockFace::getFace,
        BlockFace::new
    );

    public BlockFace(class_2338 first, class_2350 second) {
        super(first, second);
    }

    public boolean isEquivalent(BlockFace other) {
        if (equals(other))
            return true;
        return getConnectedPos().equals(other.getPos()) && getPos().equals(other.getConnectedPos());
    }

    public class_2338 getPos() {
        return getFirst();
    }

    public class_2350 getFace() {
        return getSecond();
    }

    public class_2350 getOppositeFace() {
        return getSecond().method_10153();
    }

    public BlockFace getOpposite() {
        return new BlockFace(getConnectedPos(), getOppositeFace());
    }

    public class_2338 getConnectedPos() {
        return getPos().method_10093(getFace());
    }

    public class_2487 serializeNBT() {
        class_2487 compoundNBT = new class_2487();
        compoundNBT.method_67494("Pos", class_2338.field_25064, getPos());
        NBTHelper.writeEnum(compoundNBT, "Face", getFace());
        return compoundNBT;
    }

    public static BlockFace fromNBT(class_2487 compound) {
        return new BlockFace(NBTHelper.readBlockPos(compound, "Pos"), NBTHelper.readEnum(compound, "Face", class_2350.class));
    }

}
