package com.zurrtum.create.client;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.zurrtum.create.*;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.contraptions.ContraptionColliderClient;
import com.zurrtum.create.client.content.contraptions.actors.trainControls.ControlsHandler;
import com.zurrtum.create.client.content.contraptions.elevator.ElevatorContactScreen;
import com.zurrtum.create.client.content.contraptions.glue.SuperGlueSelectionHandler;
import com.zurrtum.create.client.content.contraptions.minecart.CouplingHandlerClient;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.client.content.equipment.clipboard.ClipboardScreen;
import com.zurrtum.create.client.content.equipment.symmetryWand.SymmetryHandlerClient;
import com.zurrtum.create.client.content.equipment.symmetryWand.SymmetryWandScreen;
import com.zurrtum.create.client.content.equipment.zapper.ShootableGadgetRenderHandler;
import com.zurrtum.create.client.content.equipment.zapper.ZapperRenderHandler.LaserBeam;
import com.zurrtum.create.client.content.equipment.zapper.terrainzapper.WorldshaperScreen;
import com.zurrtum.create.client.content.fluids.FluidFX;
import com.zurrtum.create.client.content.kinetics.fan.AirCurrentClient;
import com.zurrtum.create.client.content.kinetics.mechanicalArm.ArmInteractionPointHandler;
import com.zurrtum.create.client.content.kinetics.steamEngine.SteamEngineRenderer;
import com.zurrtum.create.client.content.kinetics.transmission.sequencer.SequencedGearshiftScreen;
import com.zurrtum.create.client.content.logistics.AddressEditBoxHelper;
import com.zurrtum.create.client.content.logistics.depot.EjectorTargetHandler;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelScreen;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelSlotPositioning;
import com.zurrtum.create.client.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerMovementRenderBehaviour;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerRenderer;
import com.zurrtum.create.client.content.redstone.displayLink.DisplayLinkScreen;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler;
import com.zurrtum.create.client.content.redstone.thresholdSwitch.ThresholdSwitchScreen;
import com.zurrtum.create.client.content.schematics.client.SchematicEditScreen;
import com.zurrtum.create.client.content.trains.TrainHUD;
import com.zurrtum.create.client.content.trains.station.AssemblyScreen;
import com.zurrtum.create.client.content.trains.station.StationScreen;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.api.backend.BackendManager;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.impl.Flywheel;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.render.PlayerSkyhookRenderer;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.client.foundation.utility.ServerSpeedProvider;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.contraptions.gantry.GantryContraptionEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.trains.GlobalRailwayManager;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.graph.*;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.debugInfo.DebugInformation;
import com.zurrtum.create.infrastructure.debugInfo.element.DebugInfoSection;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.packet.c2s.TrackGraphRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.*;
import com.zurrtum.create.infrastructure.particle.AirFlowParticleData;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2600;
import net.minecraft.class_2680;
import net.minecraft.class_2792;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9129;
import net.minecraft.class_9323;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

import static com.zurrtum.create.Create.LOGGER;

public class AllHandle extends AllClientHandle<class_634> {

    public static void register() {
        AllClientHandle.INSTANCE = new AllHandle();
    }

    @Override
    protected void forceMainThread(class_634 listener, S2CPacket packet) {
        class_2600.method_11074(packet, listener, listener.field_45588.method_74186());
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean shiftDown() {
        return AllKeys.hasShiftDown();
    }

    @Override
    public void onSymmetryEffect(class_634 listener, SymmetryEffectPacket packet) {
        class_310 client = listener.field_45588;
        class_2338 mirror = packet.mirror();
        if (client.field_1724.method_73189().method_1022(class_243.method_24954(mirror)) > 100)
            return;
        for (class_2338 to : packet.positions())
            SymmetryHandlerClient.drawEffect(client, mirror, to);
    }

    @Override
    public void onLogisticalStockResponse(class_634 listener, LogisticalStockResponsePacket packet) {
        if (listener.field_3699.method_8321(packet.pos()) instanceof StockTickerBlockEntity stbe) {
            stbe.receiveStockPacket(packet.items(), packet.lastPacket());
        }
    }

    @Override
    public void onTrainEditReturn(class_634 clientPlayNetworkHandler, TrainEditReturnPacket packet) {
        Train train = Create.RAILWAYS.trains.get(packet.id());
        if (train == null)
            return;
        if (!packet.name().isBlank()) {
            train.name = class_2561.method_43470(packet.name());
        }
        train.icon = TrainIconType.byId(packet.iconType());
        train.mapColorIndex = packet.mapColor();
    }

    @Override
    public void onTrainHUDControlUpdate(class_634 listener, TrainHUDControlUpdatePacket packet) {
        Train train = Create.RAILWAYS.trains.get(packet.trainId());
        if (train == null)
            return;

        if (packet.throttle() != null) {
            train.throttle = packet.throttle();
        }

        train.speed = packet.speed();
        train.fuelTicks = packet.fuelTicks();
    }

    @Override
    public void onTrainHonkReturn(class_634 listener, HonkReturnPacket packet) {
        Train train = Create.RAILWAYS.trains.get(packet.trainId());
        if (train == null)
            return;

        if (packet.isHonk())
            train.honkTicks = train.honkTicks == 0 ? 20 : 13;
        else
            train.honkTicks = train.honkTicks > 5 ? 6 : 0;
    }

    @Override
    public void onElevatorFloorList(class_634 listener, ElevatorFloorListPacket packet) {
        class_1297 entityByID = listener.field_3699.method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity ace))
            return;
        if (!(ace.getContraption() instanceof ElevatorContraption ec))
            return;

        ec.namesList = packet.floors();
        ec.syncControlDisplays();
    }

    @Override
    public void onContraptionColliderLock(class_634 listener, ContraptionColliderLockPacket packet) {
        ContraptionColliderClient.lockPacketReceived(packet.contraption(), packet.sender(), packet.offset());
    }

    @Override
    public void onWiFiEffect(class_634 listener, WiFiEffectPacket packet) {
        class_2586 blockEntity = listener.field_3699.method_8321(packet.pos());
        if (blockEntity instanceof PackagerLinkBlockEntity plbe)
            plbe.playEffect();
        if (blockEntity instanceof StockTickerBlockEntity plbe)
            plbe.playEffect();
    }

    @Override
    public void onControlsStopControlling(class_634 listener) {
        ControlsHandler.stopControlling(listener.field_45588.field_1724);
    }

    @Override
    public void onServerSpeed(class_634 listener, ServerSpeedPacket packet) {
        if (!ServerSpeedProvider.initialized) {
            ServerSpeedProvider.initialized = true;
            ServerSpeedProvider.clientTimer = 0;
            return;
        }
        float target = ((float) packet.speed()) / Math.max(ServerSpeedProvider.clientTimer, 1);
        ServerSpeedProvider.modifier.chase(Math.min(target, 1), .25, LerpedFloat.Chaser.EXP);
        // Set this to -1 because packets are processed before ticks.
        // ServerSpeedProvider#clientTick will increment it to 0 at the end of this tick.
        // Setting it to 0 causes consistent desync, as the client ends up counting too many ticks.
        ServerSpeedProvider.clientTimer = -1;
    }

    private <T extends ShootableGadgetRenderHandler> void onShootGadget(
        class_634 listener,
        class_243 location,
        class_1268 hand,
        boolean self,
        T handler,
        Consumer<T> handleAdditional
    ) {
        class_1297 renderViewEntity = listener.field_45588.method_1560();
        if (renderViewEntity == null)
            return;
        if (renderViewEntity.method_73189().method_1022(location) > 100)
            return;

        handleAdditional.accept(handler);
        if (self)
            handler.shoot(hand, location);
        else
            handler.playSound(hand, location);
    }

    @Override
    public void onZapperBeam(class_634 listener, ZapperBeamPacket packet) {
        onShootGadget(
            listener, packet.location(), packet.hand(), packet.self(), Create.ZAPPER_RENDER_HANDLER, handler -> {
                handler.addBeam(listener.field_45588, new LaserBeam(packet.location(), packet.target()));
            }
        );
    }

    @Override
    public void onPotatoCannon(class_634 listener, PotatoCannonPacket packet) {
        onShootGadget(
            listener, packet.location(), packet.hand(), packet.self(), Create.POTATO_CANNON_RENDER_HANDLER, handler -> {
                handler.beforeShoot(packet.pitch(), packet.location(), packet.motion(), packet.item());
            }
        );
    }

    @Override
    public void onContraptionStall(class_634 listener, ContraptionStallPacket packet) {
        if (listener.field_3699.method_8469(packet.entityId()) instanceof AbstractContraptionEntity ce) {
            ce.handleStallInformation(packet.x(), packet.y(), packet.z(), packet.angle());
        }
    }

    @Override
    public void onContraptionDisassembly(class_634 listener, ContraptionDisassemblyPacket packet) {
        if (listener.field_3699.method_8469(packet.entityId()) instanceof AbstractContraptionEntity ce) {
            ce.moveCollidedEntitiesOnDisassembly(packet.transform());
        }
    }

    @Override
    public void onContraptionBlockChanged(class_634 listener, ContraptionBlockChangedPacket packet) {
        if (listener.field_3699.method_8469(packet.entityId()) instanceof AbstractContraptionEntity ce) {
            Contraption contraption = ce.getContraption();
            if (contraption == null) {
                return;
            }
            Map<class_2338, class_3499.class_3501> blocks = contraption.getBlocks();
            class_2338 localPos = packet.localPos();
            if (!blocks.containsKey(localPos)) {
                return;
            }
            class_3499.class_3501 info = blocks.get(localPos);
            class_2680 newState = packet.newState();
            blocks.put(localPos, new class_3499.class_3501(info.comp_1341(), newState, info.comp_1343()));
            if (info.comp_1342() != newState && !(newState.method_26204() instanceof SlidingDoorBlock)) {
                ClientContraption.resetClientContraption(contraption);
            }
            contraption.invalidateColliders();
        }
    }

    @Override
    public void onGlueEffect(class_634 listener, GlueEffectPacket packet) {
        class_746 player = listener.field_45588.field_1724;
        if (!player.method_24515().method_19771(packet.pos(), 100))
            return;
        SuperGlueSelectionHandler.spawnParticles(player.method_73183(), packet.pos(), packet.direction(), packet.fullBlock());
    }

    @Override
    public void onContraptionSeatMapping(class_634 listener, ContraptionSeatMappingPacket packet) {
        class_746 player = listener.field_45588.field_1724;
        class_1297 entityByID = player.method_73183().method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity contraptionEntity))
            return;

        if (packet.dismountedId() == player.method_5628()) {
            class_243 transformedVector = contraptionEntity.getPassengerPosition(player, 1);
            if (transformedVector != null)
                AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set(player, Optional.of(transformedVector));
        }

        contraptionEntity.getContraption().setSeatMapping(new HashMap<>(packet.mapping()));
    }

    @Override
    public void onLimbSwingUpdate(class_634 listener, LimbSwingUpdatePacket packet) {
        class_638 world = listener.method_2890();
        class_1297 entity = world.method_8469(packet.entityId());
        if (!(entity instanceof class_1657 player))
            return;
        AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set(player, 0);
        AllSynchedDatas.OVERRIDE_LIMB_SWING.set(player, packet.limbSwing());
        class_243 position = packet.position();
        player.method_66246(position, player.method_36454(), player.method_36455());
    }

    @Override
    public void onFluidSplash(class_634 listener, FluidSplashPacket packet) {
        class_2338 pos = packet.pos();
        if (listener.field_45588.field_1724.method_73189().method_1022(new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260())) > 100) {
            return;
        }
        FluidFX.splash(pos, packet.fluid());
    }

    @Override
    public void onMountedStorageSync(class_634 listener, MountedStorageSyncPacket packet) {
        class_1297 entity = listener.field_3699.method_8469(packet.contraptionId());
        if (!(entity instanceof AbstractContraptionEntity contraption))
            return;

        contraption.getContraption().getStorage().handleSync(packet, contraption);
    }

    @Override
    public void onGantryContraptionUpdate(class_634 listener, GantryContraptionUpdatePacket packet) {
        class_1297 entity = listener.field_3699.method_8469(packet.entityID());
        if (!(entity instanceof GantryContraptionEntity ce)) {
            return;
        }
        ce.axisMotion = packet.motion();
        ce.clientOffsetDiff = packet.coord() - ce.getAxisCoord();
        ce.sequencedOffsetLimit = packet.sequenceLimit();
    }

    @Override
    public void onHighlight(class_634 listener, HighlightPacket packet) {
        if (!listener.field_3699.method_8477(packet.pos())) {
            return;
        }

        Outliner.getInstance().showAABB("highlightCommand", class_259.method_1077().method_1107().method_996(packet.pos()), 200).lineWidth(1 / 32f)
            .colored(0xEeEeEe)
            // .colored(0x243B50)
            .withFaceTexture(AllSpecialTextures.SELECTION);
    }

    @Override
    public void onTunnelFlap(class_634 listener, TunnelFlapPacket packet) {
        if (listener.field_3699.method_8321(packet.pos()) instanceof BeltTunnelBlockEntity blockEntity) {
            packet.flaps().forEach(flap -> {
                blockEntity.flap(flap.getFirst(), flap.getSecond());
            });
        }
    }

    @Override
    public void onFunnelFlap(class_634 listener, FunnelFlapPacket packet) {
        if (listener.field_3699.method_8321(packet.pos()) instanceof FunnelBlockEntity blockEntity) {
            blockEntity.flap(packet.inwards());
        }
    }

    @Override
    public void onSoulPulseEffect(class_634 listener, SoulPulseEffectPacket packet) {
        Create.SOUL_PULSE_EFFECT_HANDLER.addPulse(new SoulPulseEffect(packet.pos(), packet.distance(), packet.canOverlap()));
    }

    @Override
    public void onSignalEdgeGroup(class_634 listener, SignalEdgeGroupPacket packet) {
        Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
        List<UUID> ids = packet.ids();
        for (int i = 0; i < ids.size(); i++) {
            UUID id = ids.get(i);
            if (!packet.add()) {
                signalEdgeGroups.remove(id);
                continue;
            }

            SignalEdgeGroup group = new SignalEdgeGroup(id);
            signalEdgeGroups.put(id, group);
            if (i < packet.colors().size())
                group.color = packet.colors().get(i);
        }
    }

    @Override
    public void onRemoveTrain(class_634 listener, RemoveTrainPacket packet) {
        Create.RAILWAYS.trains.remove(packet.id());
    }

    @Override
    public void onRemoveBlockEntity(class_634 listener, RemoveBlockEntityPacket packet) {
        if (listener.field_3699.method_8321(packet.pos()) instanceof SyncedBlockEntity be) {
            if (!be.method_11002()) {
                be.method_11012();
                return;
            }

            be.method_10997().method_8544(packet.pos());
        }
    }

    @Override
    public void onTrainPrompt(class_634 listener, TrainPromptPacket packet) {
        TrainHUD.currentPrompt = packet.text();
        TrainHUD.currentPromptShadow = packet.shadow();
        TrainHUD.promptKeepAlive = 30;
    }

    @Override
    public void onContraptionRelocation(class_634 listener, ContraptionRelocationPacket packet) {
        if (listener.field_3699.method_8469(packet.entityId()) instanceof OrientedContraptionEntity oce) {
            oce.nonDamageTicks = 10;
        }
    }

    @Override
    public void onTrackGraphRollCall(class_634 listener, TrackGraphRollCallPacket packet) {
        GlobalRailwayManager manager = Create.RAILWAYS;
        Set<UUID> unusedIds = new HashSet<>(manager.trackNetworks.keySet());
        List<Integer> failedIds = new ArrayList<>();
        Map<Integer, UUID> idByNetId = new HashMap<>();
        manager.trackNetworks.forEach((uuid, g) -> idByNetId.put(g.netId, uuid));

        for (TrackGraphRollCallPacket.Entry entry : packet.entries()) {
            UUID uuid = idByNetId.get(entry.netId());
            if (uuid == null) {
                failedIds.add(entry.netId());
                continue;
            }
            unusedIds.remove(uuid);
            TrackGraph trackGraph = manager.trackNetworks.get(uuid);
            if (trackGraph.getChecksum() == entry.checksum())
                continue;
            LOGGER.warn("Track network: {} failed its checksum; Requesting refresh", uuid.toString().substring(0, 6));
            failedIds.add(entry.netId());
        }

        for (Integer failed : failedIds)
            listener.method_52787(new TrackGraphRequestPacket(failed));
        for (UUID unused : unusedIds)
            manager.trackNetworks.remove(unused);
    }

    @Override
    public void onArmPlacementRequest(class_634 listener, ArmPlacementRequestPacket packet) {
        ArmInteractionPointHandler.flushSettings(listener.field_45588.field_1724, packet.pos());
    }

    @Override
    public void onEjectorPlacementRequest(class_634 listener, EjectorPlacementRequestPacket packet) {
        EjectorTargetHandler.flushSettings(listener, packet.pos());
    }

    @Override
    public void onPackagePortPlacementRequest(class_634 listener, PackagePortPlacementRequestPacket packet) {
        PackagePortTargetSelectionHandler.flushSettings(listener.field_45588.field_1724, packet.pos());
    }

    @Override
    public void onContraptionDisableActor(class_634 listener, ContraptionDisableActorPacket packet) {
        class_1297 entityByID = listener.field_3699.method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity ace))
            return;

        Contraption contraption = ace.getContraption();
        List<class_1799> disabledActors = contraption.getDisabledActors();
        class_1799 filter = packet.filter();
        if (filter.method_7960())
            disabledActors.clear();

        if (!packet.enable()) {
            disabledActors.add(filter);
            contraption.setActorsActive(filter, false);
            return;
        }

        disabledActors.removeIf(next -> ContraptionControlsMovement.isSameFilter(next, filter) || next.method_7960());

        contraption.setActorsActive(filter, true);
    }

    @Override
    public void onAttachedComputer(class_634 listener, AttachedComputerPacket packet) {
        //TODO
        //        if (listener.world.getBlockEntity(packet.pos()) instanceof SmartBlockEntity be) {
        //            sbe.getBehaviour(AbstractComputerBehaviour.TYPE).setHasAttachedComputer(packet.hasAttachedComputer());
        //        }
    }

    @Override
    public void onServerDebugInfo(class_634 listener, ServerDebugInfoPacket packet) {
        StringBuilder output = new StringBuilder();
        List<DebugInfoSection> clientInfo = DebugInformation.getClientInfo();

        ServerDebugInfoPacket.printInfo("Client", listener.field_45588.field_1724, clientInfo, output);
        output.append("\n\n");
        output.append(packet.serverInfo());

        String text = output.toString();
        listener.field_45588.field_1774.method_1455(text);
        listener.field_45588.field_1724.method_7353(
            class_2561.method_43471("create.command.debuginfo.saved_to_clipboard")
                .method_54663(DyeHelper.getDyeColors(class_1767.field_7961).getFirst()), false
        );
    }

    @Override
    public void onPackageDestroy(class_634 listener, PackageDestroyPacket packet) {
        class_638 world = listener.field_3699;
        class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, world.method_8409(), .125f);
        class_243 pos = packet.location().method_1019(motion.method_1021(4));
        world.method_8406(new class_2392(class_2398.field_11218, packet.box()), pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
    }

    @Override
    public void onFactoryPanelEffect(class_634 listener, FactoryPanelEffectPacket packet) {
        class_638 world = listener.field_3699;
        class_2680 blockState = world.method_8320(packet.fromPos().pos());
        if (!blockState.method_27852(AllBlocks.FACTORY_GAUGE))
            return;
        ServerFactoryPanelBehaviour panelBehaviour = ServerFactoryPanelBehaviour.at(world, packet.toPos());
        if (panelBehaviour != null) {
            panelBehaviour.bulb.setValue(1);
            FactoryPanelConnection connection = panelBehaviour.targetedBy.get(packet.fromPos());
            if (connection != null)
                connection.success = packet.success();
        }
    }

    @Override
    public void onRedstoneRequesterEffect(class_634 listener, RedstoneRequesterEffectPacket packet) {
        if (listener.field_3699.method_8321(packet.pos()) instanceof RedstoneRequesterBlockEntity plbe) {
            plbe.playEffect(packet.success());
        }
    }

    @Override
    public void onClientboundChainConveyorRiding(class_634 listener, ClientboundChainConveyorRidingPacket packet) {
        PlayerSkyhookRenderer.updatePlayerList(packet.uuids());
    }

    @Override
    public void onShopUpdate(class_634 listener, ShopUpdatePacket packet) {
        if (listener.field_3699.method_8321(packet.pos()) instanceof TableClothBlockEntity blockEntity) {
            if (!blockEntity.method_11002()) {
                return;
            }

            blockEntity.invalidateItemsForRender();
        }
    }

    @Override
    public void onTrackGraphSync(class_634 listener, TrackGraphSyncPacket packet) {
        GlobalRailwayManager manager = Create.RAILWAYS;
        TrackGraph graph = manager.getOrCreateGraph(packet.graphId, packet.netId);
        manager.version++;

        if (packet.packetDeletesGraph) {
            manager.removeGraph(graph);
            return;
        }

        if (packet.fullWipe) {
            manager.removeGraph(graph);
            graph = Create.RAILWAYS.sided(null).getOrCreateGraph(packet.graphId, packet.netId);
        }

        for (int nodeId : packet.removedNodes) {
            TrackNode node = graph.getNode(nodeId);
            if (node != null)
                graph.removeNode(null, node.getLocation());
        }

        for (Map.Entry<Integer, Pair<TrackNodeLocation, class_243>> entry : packet.addedNodes.entrySet()) {
            Integer nodeId = entry.getKey();
            Pair<TrackNodeLocation, class_243> nodeLocation = entry.getValue();
            graph.loadNode(nodeLocation.getFirst(), nodeId, nodeLocation.getSecond());
        }

        for (Pair<Pair<Couple<Integer>, TrackMaterial>, BezierConnection> pair : packet.addedEdges) {
            Couple<TrackNode> nodes = pair.getFirst().getFirst().map(graph::getNode);
            TrackNode node1 = nodes.getFirst();
            TrackNode node2 = nodes.getSecond();
            if (node1 != null && node2 != null)
                graph.putConnection(node1, node2, new TrackEdge(node1, node2, pair.getSecond(), pair.getFirst().getSecond()));
        }

        for (TrackEdgePoint edgePoint : packet.addedEdgePoints)
            graph.edgePoints.put(edgePoint.getType(), edgePoint);

        for (UUID uuid : packet.removedEdgePoints)
            for (EdgePointType<?> type : EdgePointType.TYPES.values())
                graph.edgePoints.remove(type, uuid);

        handleEdgeData(packet.updatedEdgeData, graph);

        if (!packet.splitSubGraphs.isEmpty())
            graph.findDisconnectedGraphs(null, packet.splitSubGraphs).forEach(manager::putGraph);
    }

    private void handleEdgeData(Map<Couple<Integer>, Pair<Integer, List<UUID>>> updatedEdgeData, TrackGraph graph) {
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : updatedEdgeData.entrySet()) {
            List<UUID> idList = entry.getValue().getSecond();
            int groupType = entry.getValue().getFirst();

            Couple<TrackNode> nodes = entry.getKey().map(graph::getNode);
            if (nodes.either(Objects::isNull))
                continue;
            TrackEdge edge = graph.getConnectionsFrom(nodes.getFirst()).get(nodes.getSecond());
            if (edge == null)
                continue;

            EdgeData edgeData = new EdgeData(edge);
            if (groupType == TrackGraphSyncPacket.NULL_GROUP)
                edgeData.setSingleSignalGroup(null, null, null);
            else if (groupType == TrackGraphSyncPacket.PASSIVE_GROUP)
                edgeData.setSingleSignalGroup(null, null, EdgeData.passiveGroup);
            else
                edgeData.setSingleSignalGroup(null, null, idList.getFirst());

            List<TrackEdgePoint> points = edgeData.getPoints();
            edge.edgeData = edgeData;

            for (int i = groupType == TrackGraphSyncPacket.GROUP ? 1 : 0; i < idList.size(); i++) {
                UUID uuid = idList.get(i);
                for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
                    TrackEdgePoint point = graph.edgePoints.get(type, uuid);
                    if (point == null)
                        continue;
                    points.add(point);
                    break;
                }
            }
        }
    }

    @Override
    public void onAddTrain(class_634 listener, AddTrainPacket packet) {
        Train train = packet.train();
        Create.RAILWAYS.trains.put(train.id, train);
    }

    @Override
    public void onOpenScreen(class_634 listener, OpenScreenPacket packet) {
        class_9129 extraData = new class_9129(Unpooled.wrappedBuffer(packet.data()), listener.method_29091());
        AllMenuScreens.open(listener.field_45588, packet.type(), packet.id(), packet.name(), extraData);
        extraData.release();
    }

    @Override
    public void onBlueprintPreview(class_634 listener, BlueprintPreviewPacket packet) {
        BlueprintOverlayRenderer.updatePreview(packet.available(), packet.missing(), packet.result());
    }

    @Override
    public void buildDebugInfo() {
        DebugInfoSection.builder("Graphics").put("Flywheel Version", DebugInformation.getVersionOfMod(Flywheel.MOD_ID))
            .put("Flywheel Backend", () -> Backend.REGISTRY.getIdOrThrow(BackendManager.currentBackend()).toString())
            .put("OpenGL Renderer", GlStateManager._getString(GL11.GL_RENDERER)).put("OpenGL Version", GlStateManager._getString(GL11.GL_VERSION))
            .put("Graphics Mode", () -> class_310.method_1551().field_1690.method_42534().method_41753().name().toLowerCase(Locale.ROOT))
            .buildTo(DebugInformation::registerClientInfo);
    }

    @Override
    public class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public void queueUpdate(class_2586 entity) {
        VisualizationHelper.queueUpdate(entity);
    }

    @Override
    public void addAirFlowParticle(class_1937 world, class_2338 airCurrentPos, double x, double y, double z) {
        if (world.field_9229.method_43057() < AllConfigs.client().fanParticleDensity.get())
            world.method_8406(new AirFlowParticleData(airCurrentPos), x, y, z, 0, 0, 0);
    }

    @Override
    public void enableClientPlayerSound(class_1297 entity, float clamp) {
        AirCurrentClient.enableClientPlayerSound(entity, clamp);
    }

    @Override
    public void addBehaviours(SmartBlockEntity blockEntity, ArrayList<BlockEntityBehaviour<?>> behaviours) {
        AllBlockEntityBehaviours.addBehaviours(blockEntity, behaviours);
    }

    @Override
    public void addBehaviours(class_1297 entity, ArrayList<EntityBehaviour<?>> behaviours) {
        AllEntityBehaviours.addBehaviours(entity, behaviours);
    }

    @Override
    public void showWaterBounds(class_2351 axis, class_1750 context) {
        class_2338 pos = context.method_8037();
        class_243 contract = class_243.method_24954(class_2350.method_10156(class_2352.field_11056, axis).method_62675());
        Outliner.getInstance().showAABB(Pair.of("waterwheel", pos), new class_238(pos).method_1014(1).method_35580(contract.field_1352, contract.field_1351, contract.field_1350))
            .colored(0xFF_ff5d6c);
        CreateLang.translate("large_water_wheel.not_enough_space").color(0xFF_ff5d6c).sendStatus(context.method_8036());
    }

    @Override
    public float getServerSpeed() {
        return ServerSpeedProvider.get();
    }

    @Override
    public void resetClientContraption(Contraption contraption) {
        ClientContraption.resetClientContraption(contraption);
    }

    @Override
    public void invalidateClientContraptionChildren(Contraption contraption) {
        ClientContraption.invalidateClientContraptionChildren(contraption);
    }

    @Override
    @Nullable
    public class_2586 getBlockEntityClientSide(Contraption contraption, class_2338 localPos) {
        return ClientContraption.getBlockEntityClientSide(contraption, localPos);
    }

    @Override
    public void spawnPipeParticles(class_1937 world, class_2338 pos, PipeConnection.Flow flow, boolean openEnd, class_2350 side, int amount) {
        class_310 mc = class_310.method_1551();
        if (world == mc.field_1687)
            if (isRenderEntityWithoutDistance(mc, pos))
                return;
        if (openEnd)
            spawnPouringLiquid(world, pos, flow, side, amount);
        else if (world.field_9229.method_43057() < PipeConnection.IDLE_PARTICLE_SPAWN_CHANCE)
            spawnRimParticles(world, pos, flow.fluid, side, amount);
    }

    private static boolean isRenderEntityWithoutDistance(class_310 mc, class_2338 pos) {
        class_1297 renderViewEntity = mc.method_1560();
        if (renderViewEntity == null)
            return true;
        class_243 center = VecHelper.getCenterOf(pos);
        return renderViewEntity.method_73189().method_1022(center) > PipeConnection.MAX_PARTICLE_RENDER_DISTANCE;
    }

    private static void spawnRimParticles(class_1937 world, class_2338 pos, FluidStack fluid, class_2350 side, int amount) {
        class_2394 particle = FluidFX.getDrippingParticle(fluid);
        FluidFX.spawnRimParticles(world, pos, side, amount, particle, PipeConnection.RIM_RADIUS);
    }

    private static void spawnPouringLiquid(class_1937 world, class_2338 pos, PipeConnection.Flow flow, class_2350 side, int amount) {
        class_2394 particle = FluidFX.getFluidParticle(flow.fluid);
        class_243 directionVec = class_243.method_24954(side.method_62675());
        FluidFX.spawnPouringLiquid(world, pos, amount, particle, PipeConnection.RIM_RADIUS, directionVec, flow.inbound);
    }

    @Override
    public void spawnSteamEngineParticles(SteamEngineBlockEntity be) {
        Float targetAngle = SteamEngineRenderer.getTargetAngle(be);
        PoweredShaftBlockEntity ste = be.target.get();
        if (ste == null)
            return;
        if (!ste.isPoweredBy(be.method_11016()) || ste.engineEfficiency == 0)
            return;
        if (targetAngle == null)
            return;

        float angle = AngleHelper.deg(targetAngle);
        angle += (angle < 0) ? -180 + 75 : 360 - 75;
        angle %= 360;

        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft == null || shaft.getSpeed() == 0)
            return;

        if (angle >= 0 && !(be.prevAngle > 180 && angle < 180)) {
            be.prevAngle = angle;
            return;
        }
        if (angle < 0 && !(be.prevAngle < -180 && angle > -180)) {
            be.prevAngle = angle;
            return;
        }

        FluidTankBlockEntity sourceBE = be.source.get();
        if (sourceBE != null) {
            FluidTankBlockEntity controller = sourceBE.getControllerBE();
            if (controller != null && controller.boiler != null) {
                controller.boiler.queueSoundOnSide(be.method_11016(), SteamEngineBlock.getFacing(be.method_11010()));
            }
        }

        class_2350 facing = SteamEngineBlock.getFacing(be.method_11010());

        class_1937 world = be.method_10997();
        class_243 offset = VecHelper.rotate(
            new class_243(0, 0, 1).method_1019(VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 1).method_18805(1, 1, 0).method_1029().method_1021(.5f)),
            AngleHelper.verticalAngle(facing),
            class_2351.field_11048
        );
        offset = VecHelper.rotate(offset, AngleHelper.horizontalAngle(facing), class_2351.field_11052);
        class_243 v = offset.method_1021(.5f).method_1019(class_243.method_24953(be.method_11016()));
        class_243 m = offset.method_1020(class_243.method_24954(facing.method_62675()).method_1021(.75f));
        world.method_8406(AllParticleTypes.STEAM_JET, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);

        be.prevAngle = angle;
    }

    @Override
    public void spawnSuperGlueParticles(class_1937 world, class_2338 pos, class_2350 direction, boolean fullBlock) {
        SuperGlueSelectionHandler.spawnParticles(world, pos, direction, fullBlock);
    }

    @Override
    public void tickBlazeBurnerAnimation(BlazeBurnerBlockEntity be) {
        if (!VisualizationManager.supportsVisualization(be.method_10997())) {
            BlazeBurnerRenderer.tickAnimation(be);
        }
    }

    @Override
    public void sendPacket(class_2596<class_2792> packet) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.field_3944.method_52787(packet);
        }
    }

    @Override
    public void sendPacket(class_1657 player, class_2596<class_2792> packet) {
        if (player instanceof class_746 clientPlayer) {
            clientPlayer.field_3944.method_52787(packet);
        }
    }

    @Override
    public void createBasinFluidParticles(class_1937 world, BasinBlockEntity blockEntity) {
        class_5819 r = world.field_9229;

        if (!blockEntity.visualizedOutputFluids.isEmpty())
            createBasinOutputFluidParticles(world, blockEntity, r);

        if (!blockEntity.areFluidsMoving && r.method_43057() > 1 / 8f)
            return;

        int segments = 0;
        for (SmartFluidTankBehaviour behaviour : blockEntity.getTanks()) {
            if (behaviour == null)
                continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks())
                if (!tankSegment.isEmpty(0))
                    segments++;
        }
        if (segments < 2)
            return;

        float totalUnits = blockEntity.getTotalFluidUnits(0);
        if (totalUnits == 0)
            return;
        float fluidLevel = class_3532.method_15363(totalUnits / 162000, 0, 1);
        float rim = 2 / 16f;
        float space = 12 / 16f;
        class_2338 pos = blockEntity.method_11016();
        float surface = pos.method_10264() + rim + space * fluidLevel + 1 / 32f;

        if (blockEntity.areFluidsMoving) {
            createBasinMovingFluidParticles(world, blockEntity, surface, segments);
            return;
        }

        for (SmartFluidTankBehaviour behaviour : blockEntity.getTanks()) {
            if (behaviour == null)
                continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0))
                    continue;
                float x = pos.method_10263() + rim + space * r.method_43057();
                float z = pos.method_10260() + rim + space * r.method_43057();
                FluidStack stack = tankSegment.getRenderedFluid();
                world.method_8494(
                    new FluidParticleData(AllParticleTypes.BASIN_FLUID, stack.getFluid(), stack.getComponentChanges()),
                    x,
                    surface,
                    z,
                    0,
                    0,
                    0
                );
            }
        }
    }

    private static void createBasinOutputFluidParticles(class_1937 world, BasinBlockEntity blockEntity, class_5819 r) {
        class_2680 blockState = blockEntity.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock))
            return;
        class_2350 direction = blockState.method_11654(BasinBlock.FACING);
        if (direction == class_2350.field_11033)
            return;
        class_243 directionVec = class_243.method_24954(direction.method_62675());
        class_243 outVec = VecHelper.getCenterOf(blockEntity.method_11016()).method_1019(directionVec.method_1021(.65).method_1023(0, 1 / 4f, 0));
        class_243 outMotion = directionVec.method_1021(1 / 16f).method_1031(0, -1 / 16f, 0);

        for (int i = 0; i < 2; i++) {
            blockEntity.visualizedOutputFluids.forEach(ia -> {
                FluidStack fluidStack = ia.getValue();
                class_2394 fluidParticle = FluidFX.getFluidParticle(fluidStack);
                class_243 m = VecHelper.offsetRandomly(outMotion, r, 1 / 16f);
                world.method_8494(fluidParticle, outVec.field_1352, outVec.field_1351, outVec.field_1350, m.field_1352, m.field_1351, m.field_1350);
            });
        }
    }

    private static void createBasinMovingFluidParticles(class_1937 world, BasinBlockEntity blockEntity, float surface, int segments) {
        class_243 pointer = new class_243(1, 0, 0).method_1021(1 / 16f);
        float interval = 360f / segments;
        class_243 centerOf = VecHelper.getCenterOf(blockEntity.method_11016());
        float intervalOffset = (AnimationTickHolder.getTicks() * 18) % 360;

        int currentSegment = 0;
        for (SmartFluidTankBehaviour behaviour : blockEntity.getTanks()) {
            if (behaviour == null)
                continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0))
                    continue;
                float angle = interval * (1 + currentSegment) + intervalOffset;
                class_243 vec = centerOf.method_1019(VecHelper.rotate(pointer, angle, class_2351.field_11052));
                FluidStack stack = tankSegment.getRenderedFluid();
                world.method_8494(
                    new FluidParticleData(AllParticleTypes.BASIN_FLUID, stack.getFluid(), stack.getComponentChanges()),
                    vec.method_10216(),
                    surface,
                    vec.method_10215(),
                    1,
                    0,
                    0
                );
                currentSegment++;
            }
        }
    }

    @Override
    public void cartClicked(class_1657 player, class_1688 minecart) {
        CouplingHandlerClient.onCartClicked((class_746) player, minecart);
    }

    @Override
    public void advertiseToAddressHelper(ClipboardBlockEntity blockEntity) {
        AddressEditBoxHelper.advertiseClipboard(blockEntity);
    }

    @Override
    public void updateClipboardScreen(UUID lastEdit, class_2338 pos, ClipboardContent content) {
        class_310 mc = class_310.method_1551();
        if (!(mc.field_1755 instanceof ClipboardScreen cs))
            return;
        if (lastEdit != null && mc.field_1724.method_5667().equals(lastEdit))
            return;
        if (!pos.equals(cs.targetedBlock))
            return;
        cs.reopenWith(content);
    }

    @Override
    public GlobalRailwayManager getGlobalRailwayManager() {
        return Create.RAILWAYS;
    }

    @Override
    public void registerToCurveInteraction(TrackBlockEntity be) {
        TrackBlockOutline.registerToCurveInteraction(be);
    }

    @Override
    public void removeFromCurveInteraction(TrackBlockEntity be) {
        TrackBlockOutline.removeFromCurveInteraction(be);
    }

    @Override
    @SuppressWarnings("unchecked")
    public void invalidateCarriage(CarriageContraptionEntity entity) {
        // Update the portal cutoff first to ensure it's reflected in the updated mesh.
        entity.updateRenderedPortalCutoff();
        AtomicReference<ClientContraption> clientContraption = (AtomicReference<ClientContraption>) entity.getContraption().clientContraption;
        ClientContraption maybeNullClientContraption = clientContraption.getAcquire();
        // Nothing to invalidate if it hasn't been created yet.
        if (maybeNullClientContraption != null) {
            maybeNullClientContraption.invalidateStructure();
            maybeNullClientContraption.invalidateChildren();
        }
    }

    @Override
    public void startControlling(class_1657 player, AbstractContraptionEntity be, class_2338 pos) {
        ControlsHandler.startControlling((class_746) player, be, pos);
    }

    @Override
    public void tickBlazeBurnerMovement(MovementContext context) {
        BlazeBurnerMovementRenderBehaviour render = AllMovementBehaviours.BLAZE_BURNER.getAttachRender();
        render.tick(context);
    }

    @Override
    public void cannonDontAnimateItem(class_1268 hand) {
        Create.POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
    }

    @Override
    public void tryToggleActive(LecternControllerBlockEntity controller) {
        class_746 player = class_310.method_1551().field_1724;
        UUID uuid = player.method_5667();
        if (controller.user == null && uuid.equals(controller.prevUser)) {
            LinkedControllerClientHandler.deactivateInLectern(player);
        } else if (controller.prevUser == null && uuid.equals(controller.user)) {
            LinkedControllerClientHandler.activateInLectern(controller.method_11016());
        }
    }

    @Override
    public void toggleLinkedControllerBindMode(class_2338 pos) {
        LinkedControllerClientHandler.toggleBindMode(class_310.method_1551().field_1724, pos);
    }

    @Override
    public void toggleLinkedControllerActive() {
        LinkedControllerClientHandler.toggle(class_310.method_1551().field_1724);
    }

    @Override
    public void factoryPanelMoveToSlot(SmartBlockEntity be, PanelSlot slot) {
        FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour) be.getBehaviour(FilteringBehaviour.TYPE);
        if (behaviour.getSlotPositioning() instanceof FactoryPanelSlotPositioning fpsp) {
            fpsp.slot = slot;
        }
    }

    @Override
    public boolean factoryPanelClicked(class_1937 world, class_1657 player, ServerFactoryPanelBehaviour behaviour) {
        return FactoryPanelConnectionHandler.panelClicked(world, player, behaviour);
    }

    @Override
    public void zapperDontAnimateItem(class_1268 hand) {
        Create.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
    }

    @Override
    public void openSequencedGearshiftScreen(SequencedGearshiftBlockEntity be) {
        ScreenOpener.open(new SequencedGearshiftScreen(be));
    }

    @Override
    public void openClipboardScreen(class_1657 player, class_9323 components, class_2338 pos) {
        if (class_310.method_1551().field_1724 == player)
            ScreenOpener.open(new ClipboardScreen(player.method_31548().method_67532(), components, pos));
    }

    @Override
    public void openDisplayLinkScreen(DisplayLinkBlockEntity be, class_1657 player) {
        if (!(player instanceof class_746))
            return;
        if (be.targetOffset.equals(class_2338.field_11176)) {
            player.method_7353(CreateLang.translateDirect("display_link.invalid"), true);
            return;
        }
        ScreenOpener.open(new DisplayLinkScreen(be));
    }

    @Override
    public void openThresholdSwitchScreen(ThresholdSwitchBlockEntity be, class_1657 player) {
        if (player instanceof class_746)
            ScreenOpener.open(new ThresholdSwitchScreen(be));
    }

    @Override
    public void openElevatorContactScreen(ElevatorContactBlockEntity be, class_1657 player) {
        if (player instanceof class_746)
            ScreenOpener.open(new ElevatorContactScreen(be.method_11016(), be.shortName, be.longName, be.doorControls.mode));
    }

    @Override
    public void openStationScreen(class_1937 world, class_2338 pos, class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (world.method_8321(pos) instanceof StationBlockEntity be) {
            GlobalStation station = be.getStation();
            class_2680 blockState = be.method_11010();
            if (station == null || blockState == null)
                return;
            boolean assembling = blockState.method_26204() == AllBlocks.TRACK_STATION && blockState.method_11654(StationBlock.ASSEMBLING);
            ScreenOpener.open(assembling ? new AssemblyScreen(be, station) : new StationScreen(be, station));
        }
    }

    @Override
    public void openFactoryPanelScreen(ServerFactoryPanelBehaviour behaviour, class_1657 player) {
        if (player instanceof class_746)
            ScreenOpener.open(new FactoryPanelScreen(behaviour));
    }

    @Override
    public void openSymmetryWandScreen(class_1799 stack, class_1268 hand) {
        ScreenOpener.open(new SymmetryWandScreen(stack, hand));
    }

    @Override
    public void openSchematicEditScreen() {
        ScreenOpener.open(new SchematicEditScreen());
    }

    @Override
    public void openWorldshaperScreen(class_1799 item, class_1268 hand) {
        ScreenOpener.open(new WorldshaperScreen(item, hand));
    }
}
