package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.CrushWheelRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.ArrayList;
import java.util.List;

public class CrushingCategory extends CreateCategory<class_8786<? extends AbstractCrushingRecipe>> {
    public static List<class_8786<? extends AbstractCrushingRecipe>> getRecipes(class_10289 preparedRecipes) {
        List<class_8786<? extends AbstractCrushingRecipe>> recipes = new ArrayList<>();
        recipes.addAll(preparedRecipes.method_64698(AllRecipeTypes.CRUSHING));
        recipes.addAll(preparedRecipes.method_64698(AllRecipeTypes.MILLING));
        return recipes;
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<? extends AbstractCrushingRecipe>> getRecipeType() {
        return JeiClientPlugin.CRUSHING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.crushing");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.CRUSHING_WHEEL, AllItems.CRUSHED_GOLD);
    }

    @Override
    public int getHeight() {
        return 100;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<? extends AbstractCrushingRecipe> entry, IFocusGroup focuses) {
        AbstractCrushingRecipe recipe = entry.comp_1933();
        builder.addInputSlot(51, 3).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        List<ChanceOutput> results = recipe.results();
        for (int i = 0, size = results.size(), start = (179 - 19 * size) / 2 + 3; i < size; i++) {
            addChanceSlot(builder, start + i * 19, 83, results.get(i));
        }
    }

    @Override
    public void draw(
        class_8786<? extends AbstractCrushingRecipe> entry,
        IRecipeSlotsView recipeSlotsView,
        class_332 graphics,
        double mouseX,
        double mouseY
    ) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 72, 7);
        graphics.field_59826.method_70922(new CrushWheelRenderState(new Matrix3x2f(graphics.method_51448()), 42, 24));
    }
}
