package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.FanRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.fan.processing.HauntingRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.List;

public class FanHauntingCategory extends CreateCategory<class_8786<HauntingRecipe>> {
    public static List<class_8786<HauntingRecipe>> getRecipes(class_10289 preparedRecipes) {
        return preparedRecipes.method_64698(AllRecipeTypes.HAUNTING).stream().toList();
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<HauntingRecipe>> getRecipeType() {
        return JeiClientPlugin.FAN_HAUNTING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.fan_haunting");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.PROPELLER, class_1802.field_23842);
    }

    @Override
    public int getHeight() {
        return 77;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<HauntingRecipe> entry, IFocusGroup focuses) {
        HauntingRecipe recipe = entry.comp_1933();
        List<ChanceOutput> results = recipe.results();
        int outputSize = results.size();
        if (outputSize == 1) {
            builder.addInputSlot(21, 48).setBackground(SLOT, -1, -1).add(recipe.ingredient());
            addChanceSlot(builder, 141, 48, results.getFirst());
        } else {
            int xOffsetAmount = 1 - Math.min(3, outputSize);
            builder.addInputSlot(21 + xOffsetAmount * 5, 48).setBackground(SLOT, -1, -1).add(recipe.ingredient());
            for (int i = 0, left = 141 + xOffsetAmount * 9, top = 48; i < outputSize; i++) {
                addChanceSlot(builder, left + (i % 3) * 19, top + (i / 3) * -19, results.get(i));
            }
        }
    }

    @Override
    public void draw(class_8786<HauntingRecipe> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        int xOffsetAmount = 1 - Math.min(3, entry.comp_1933().results().size());
        AllGuiTextures.JEI_SHADOW.render(graphics, 46, 27);
        AllGuiTextures.JEI_LIGHT.render(graphics, 65, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 54 + 7 * xOffsetAmount, 51);
        graphics.field_59826.method_70922(new FanRenderState(new Matrix3x2f(graphics.method_51448()), 56, 4, class_2246.field_22089.method_9564()));
    }
}
