package com.zurrtum.create.client.compat.jei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.BasinBlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.gui.render.MixingBasinRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.mixer.PotionRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_10289;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;

import java.util.List;

public class PotionCategory extends CreateCategory<class_8786<PotionRecipe>> {
    public static List<class_8786<PotionRecipe>> getRecipes(class_10289 preparedRecipes) {
        return preparedRecipes.method_64698(AllRecipeTypes.POTION).stream().toList();
    }

    @Override
    @NotNull
    public IRecipeType<class_8786<PotionRecipe>> getRecipeType() {
        return JeiClientPlugin.AUTOMATIC_BREWING;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.automatic_brewing");
    }

    @Override
    public IDrawable getIcon() {
        return new TwoIconRenderer(AllItems.MECHANICAL_MIXER, class_1802.field_8740);
    }

    @Override
    public int getHeight() {
        return 103;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<PotionRecipe> entry, IFocusGroup focuses) {
        PotionRecipe recipe = entry.comp_1933();
        builder.addInputSlot(21, 51).setBackground(SLOT, -1, -1).add(recipe.ingredient());
        addFluidSlot(builder, 40, 51, recipe.fluidIngredient()).setBackground(SLOT, -1, -1);
        addFluidSlot(builder, 142, 51, recipe.result()).setBackground(SLOT, -1, -1);
    }

    @Override
    public void draw(class_8786<PotionRecipe> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat = HeatCondition.HEATED;
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, 33);
        Matrix3x2f pose = new Matrix3x2f(graphics.method_51448());
        AllGuiTextures.JEI_HEAT_BAR.render(graphics, 4, 81);
        AllGuiTextures.JEI_LIGHT.render(graphics, 81, 88);
        graphics.field_59826.method_70922(new BasinBlazeBurnerRenderState(pose, 91, 69, requiredHeat.visualizeAsBlazeBurner()));
        graphics.field_59826.method_70922(new MixingBasinRenderState(pose, 91, -5));
        graphics.method_51439(
            class_310.method_1551().field_1772,
            CreateLang.translateDirect(requiredHeat.getTranslationKey()),
            9,
            86,
            requiredHeat.getColor(),
            false
        );
    }
}
