package com.zurrtum.create.client.compat.jei.renderer;

import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class JunkSlotRenderer implements IIngredientRenderer<class_1799> {
    private static final JunkSlotRenderer INSTANCE = new JunkSlotRenderer();

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, float chance) {
        class_1799 temp = class_1802.field_8077.method_7854();
        class_2487 nbt = new class_2487();
        nbt.method_10548("chance", chance);
        class_9279.method_57453(class_9334.field_49628, temp, nbt);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, x, y).setCustomRenderer(VanillaTypes.ITEM_STACK, INSTANCE).add(temp);
    }

    @Override
    public void render(class_332 graphics, class_1799 temp) {
        AllGuiTextures.JEI_CHANCE_SLOT.render(graphics, -1, -1);
        class_2561 text = class_2561.method_43470("?").method_27692(class_124.field_1067);
        class_327 textRenderer = graphics.field_44656.field_1772;
        graphics.method_51439(textRenderer, text, textRenderer.method_27525(text) / -2 + 7, 4, 0xffefefef, true);
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, class_1799 ingredient, class_1836 tooltipFlag) {
        tooltip.clear();
        IIngredientRenderer.super.getTooltip(tooltip, ingredient, tooltipFlag);
    }

    @Override
    @NotNull
    public List<class_2561> getTooltip(class_1799 temp, class_1836 tooltipFlag) {
        float chance = temp.method_58695(class_9334.field_49628, class_9279.field_49302).method_57461().method_66563("chance", 0);
        String number = chance < 0.01 ? "<1" : chance > 0.99 ? ">99" : String.valueOf(Math.round(chance * 100));
        return List.of(
            CreateLang.translateDirect("recipe.assembly.junk"),
            CreateLang.translateDirect("recipe.processing.chance", number).method_27692(class_124.field_1065)
        );
    }
}
