package com.zurrtum.create.client.compat.jei.widget;

import com.mojang.datafixers.util.Either;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;

public class PotionTooltip implements IRecipeSlotRichTooltipCallback {
    @Override
    public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        List<Either<class_5348, class_5632>> lines = tooltip.getLines();
        if (!lines.isEmpty()) {
            lines.removeFirst();
        }
        recipeSlotView.getDisplayedIngredient(FabricTypes.FLUID_STACK).ifPresent(ingredient -> {
            FluidVariant variant = ingredient.getFluidVariant();
            if (variant.isOf(AllFluids.POTION)) {
                class_9323 components = variant.getComponentMap();
                class_1844 contents = components.method_58695(class_9334.field_49651, class_1844.field_49274);
                BottleType bottleType = components.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, BottleType.REGULAR);
                class_1935 itemFromBottleType = PotionFluidHandler.itemFromBottleType(bottleType);
                class_2561 name = contents.method_64195(itemFromBottleType.method_8389().method_7876() + ".effect.");
                List<Either<class_5348, class_5632>> list = new ArrayList<>();
                list.add(Either.left(name));
                contents.method_57409(class_1792.class_9635.field_51353, text -> list.add(Either.left(text)), class_1836.field_41070, components);
                lines.addAll(0, list);
            }
        });
    }
}
