package com.zurrtum.create.client.compat.trinkets;

import com.zurrtum.create.AllItems;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class GoggleTrinketRenderer implements TrinketRenderer {
    public static void register() {
        TrinketRendererRegistry.registerRenderer(AllItems.GOGGLES, new GoggleTrinketRenderer());
    }

    @Override
    public void render(
        class_1799 stack,
        SlotReference slotReference,
        class_583<? extends class_10042> contextModel,
        class_4587 matrices,
        class_11659 queue,
        int light,
        class_10042 state,
        float headYaw,
        float headPitch
    ) {
        if (stack.method_31574(AllItems.GOGGLES) && contextModel instanceof class_591 entityModel) {
            matrices.method_22903();
            entityModel.method_63512().method_22703(matrices);
            entityModel.method_2838().method_22703(matrices);
            matrices.method_46416(0.0F, -0.25F, 0.0F);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0F));
            matrices.method_22905(0.625F, -0.625F, -0.625F);
            if (headOccupied((class_10055) state, slotReference)) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0F));
                matrices.method_46416(0.0F, -0.25F, 0.0F);
            }
            class_10444 item = new class_10444();
            item.field_55337 = class_811.field_4316;
            class_310 mc = class_310.method_1551();
            mc.method_65386().method_65596(item, stack, item.field_55337, mc.field_1687, null, 0);
            item.method_65604(matrices, queue, light, class_4608.field_21444, 0);
            matrices.method_22909();
        }
    }

    public static boolean headOccupied(class_10055 state, SlotReference slotReference) {
        if (!state.field_55309.method_7960()) {
            return true;
        }
        TrinketInventory inv = slotReference.inventory().getComponent().getInventory().get("head").get("hat");
        return inv != null && !inv.method_5442();
    }
}
