package com.zurrtum.create.client.content.contraptions;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.trains.entity.TrainRelocatorClient;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.client.foundation.utility.RaycastHelper.PredicateTraceResult;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionInteractionPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.*;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3965;
import net.minecraft.class_745;
import net.minecraft.class_746;

public class ContraptionHandlerClient {

    /* Global map of loaded contraptions */

    public static WorldAttached<Map<Integer, WeakReference<AbstractContraptionEntity>>> loadedContraptions;
    static WorldAttached<List<AbstractContraptionEntity>> queuedAdditions;

    static {
        loadedContraptions = new WorldAttached<>($ -> new HashMap<>());
        queuedAdditions = new WorldAttached<>($ -> ObjectLists.synchronize(new ObjectArrayList<>()));
    }

    public static void tick(class_1937 world) {
        Map<Integer, WeakReference<AbstractContraptionEntity>> map = loadedContraptions.get(world);
        List<AbstractContraptionEntity> queued = queuedAdditions.get(world);

        for (AbstractContraptionEntity contraptionEntity : queued)
            map.put(contraptionEntity.method_5628(), new WeakReference<>(contraptionEntity));
        queued.clear();

        Collection<WeakReference<AbstractContraptionEntity>> values = map.values();
        for (Iterator<WeakReference<AbstractContraptionEntity>> iterator = values.iterator(); iterator.hasNext(); ) {
            WeakReference<AbstractContraptionEntity> weakReference = iterator.next();
            AbstractContraptionEntity contraptionEntity = weakReference.get();
            if (contraptionEntity == null || !contraptionEntity.isAliveOrStale()) {
                iterator.remove();
                continue;
            }
            if (!contraptionEntity.method_5805()) {
                contraptionEntity.staleTicks--;
                continue;
            }

            ContraptionColliderClient.collideEntities(contraptionEntity);
        }
    }

    public static void addSpawnedContraptionsToCollisionList(class_1297 entity, class_1937 world) {
        if (entity instanceof AbstractContraptionEntity)
            queuedAdditions.get(world).add((AbstractContraptionEntity) entity);
    }

    public static void entitiesWhoJustDismountedGetSentToTheRightLocation(class_1309 entityLiving, class_1937 world) {
        if (!world.method_8608())
            return;

        AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.get(entityLiving).ifPresent(position -> {
            if (entityLiving.method_5854() == null)
                entityLiving.method_5641(position.field_1352, position.field_1351, position.field_1350, entityLiving.method_36454(), entityLiving.method_36455());
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set(entityLiving, Optional.empty());
            entityLiving.method_24830(false);
        });
    }

    public static void preventRemotePlayersWalkingAnimations(class_745 remotePlayer) {
        int lastOverride = AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.get(remotePlayer);
        if (lastOverride == -1)
            return;

        if (lastOverride > 5) {
            AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set(remotePlayer, -1);
            AllSynchedDatas.OVERRIDE_LIMB_SWING.set(remotePlayer, 0F);
            return;
        }
        AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set(remotePlayer, lastOverride + 1);

        float limbSwing = AllSynchedDatas.OVERRIDE_LIMB_SWING.get(remotePlayer);
        remotePlayer.field_6014 = remotePlayer.method_23317() - (limbSwing / 4);
        remotePlayer.field_5969 = remotePlayer.method_23321();
    }

    public static boolean rightClickingOnContraptionsGetsHandledLocally(class_310 mc, class_1268 hand) {
        class_746 player = mc.field_1724;

        if (player == null)
            return false;
        if (player.method_7325())
            return false;
        if (mc.field_1687 == null)
            return false;

        Couple<class_243> rayInputs = getRayInputs(mc, player);
        class_243 origin = rayInputs.getFirst();
        class_243 target = rayInputs.getSecond();
        class_238 aabb = new class_238(origin, target).method_1014(16);

        Collection<WeakReference<AbstractContraptionEntity>> contraptions = ContraptionHandlerClient.loadedContraptions.get(mc.field_1687).values();

        double bestDistance = Double.MAX_VALUE;
        class_3965 bestResult = null;
        AbstractContraptionEntity bestEntity = null;

        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            AbstractContraptionEntity contraptionEntity = ref.get();
            if (contraptionEntity == null)
                continue;
            if (!contraptionEntity.method_5829().method_994(aabb))
                continue;

            class_3965 rayTraceResult = rayTraceContraption(origin, target, contraptionEntity);
            if (rayTraceResult == null)
                continue;

            double distance = contraptionEntity.toGlobalVector(rayTraceResult.method_17784(), 1).method_1022(origin);
            if (distance > bestDistance)
                continue;

            bestResult = rayTraceResult;
            bestDistance = distance;
            bestEntity = contraptionEntity;
        }

        if (bestResult == null)
            return false;

        class_2350 face = bestResult.method_17780();
        class_2338 pos = bestResult.method_17777();

        if (bestEntity.handlePlayerInteraction(player, pos, face, hand)) {
            player.field_3944.method_52787(new ContraptionInteractionPacket(bestEntity, hand, pos, face));
        } else
            handleSpecialInteractions(bestEntity, player, pos, face, hand);
        return true;
    }

    private static boolean handleSpecialInteractions(
        AbstractContraptionEntity contraptionEntity,
        class_1657 player,
        class_2338 localPos,
        class_2350 side,
        class_1268 interactionHand
    ) {
        if (player.method_5998(interactionHand).method_31574(AllItems.WRENCH) && contraptionEntity instanceof CarriageContraptionEntity car)
            return TrainRelocatorClient.carriageWrenched(car.toGlobalVector(VecHelper.getCenterOf(localPos), 1), car);
        return false;
    }

    public static Couple<class_243> getRayInputs(class_310 mc, class_746 player) {
        class_243 origin = player.method_33571();
        double reach = player.method_55754();
        if (mc.field_1765 != null && mc.field_1765.method_17784() != null)
            reach = Math.min(mc.field_1765.method_17784().method_1022(origin), reach);
        class_243 target = RaycastHelper.getTraceTarget(player, reach, origin);
        return Couple.create(origin, target);
    }

    @Nullable
    public static class_3965 rayTraceContraption(class_243 origin, class_243 target, AbstractContraptionEntity contraptionEntity) {
        class_243 localOrigin = contraptionEntity.toLocalVector(origin, 1);
        class_243 localTarget = contraptionEntity.toLocalVector(target, 1);
        Contraption contraption = contraptionEntity.getContraption();

        MutableObject<class_3965> mutableResult = new MutableObject<>();
        PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil(
            localOrigin, localTarget, p -> {
                for (class_2350 d : Iterate.directions) {
                    if (d == class_2350.field_11036)
                        continue;
                    class_2338 pos = d == class_2350.field_11033 ? p : p.method_10093(d);
                    class_3501 blockInfo = contraption.getBlocks().get(pos);
                    if (blockInfo == null)
                        continue;
                    class_2680 state = blockInfo.comp_1342();
                    class_265 raytraceShape = state.method_26218(contraption.getContraptionWorld(), class_2338.field_10980.method_10074());
                    if (raytraceShape.method_1110())
                        continue;
                    if (contraption.isHiddenInPortal(pos))
                        continue;
                    class_3965 rayTrace = raytraceShape.method_1092(localOrigin, localTarget, pos);
                    if (rayTrace != null) {
                        mutableResult.setValue(rayTrace);
                        return true;
                    }
                }
                return false;
            }
        );

        if (predicateResult == null || predicateResult.missed())
            return null;

        class_3965 rayTraceResult = mutableResult.getValue();
        return rayTraceResult;
    }

}
