package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.OrientedRotatingVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import org.joml.Quaternionf;

import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_7833;

public class BearingVisual<B extends KineticBlockEntity & IBearingBlockEntity> extends OrientedRotatingVisual<B> implements SimpleDynamicVisual {
    final OrientedInstance topInstance;

    final class_7833 rotationAxis;
    final Quaternionf blockOrientation;

    public BearingVisual(VisualizationContext context, B blockEntity, float partialTick) {
        super(
            context,
            blockEntity,
            partialTick,
            class_2350.field_11035,
            blockEntity.method_11010().method_11654(class_2741.field_12525).method_10153(),
            Models.partial(AllPartialModels.SHAFT_HALF)
        );

        class_2350 facing = blockState.method_11654(class_2741.field_12525);
        rotationAxis = class_7833.method_46356(class_2350.method_10156(class_2350.class_2352.field_11056, rotationAxis()).method_23955());

        blockOrientation = getBlockStateOrientation(facing);

        PartialModel top = blockEntity.isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;

        topInstance = instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(top)).createInstance();

        topInstance.position(getVisualPosition()).rotation(blockOrientation).setChanged();
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float interpolatedAngle = blockEntity.getInterpolatedAngle(ctx.partialTick() - 1);
        Quaternionf rot = rotationAxis.rotationDegrees(interpolatedAngle);

        rot.mul(blockOrientation);

        topInstance.rotation(rot).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        relight(topInstance);
    }

    @Override
    protected void _delete() {
        super._delete();
        topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(class_2350 facing) {
        Quaternionf orientation;

        if (facing.method_10166().method_10179()) {
            orientation = class_7833.field_40716.rotationDegrees(AngleHelper.horizontalAngle(facing.method_10153()));
        } else {
            orientation = new Quaternionf();
        }

        orientation.mul(class_7833.field_40714.rotationDegrees(-90 - AngleHelper.verticalAngle(facing)));
        return orientation;
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(topInstance);
    }
}
