package com.zurrtum.create.client.content.equipment.toolbox;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.Create;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement.GuiPartialRenderBuilder;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.content.equipment.toolbox.ToolboxMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxDisposeAllPacket;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import net.minecraft.class_8942;
import net.minecraft.class_9129;

public class ToolboxScreen extends AbstractSimiContainerScreen<ToolboxMenu> {

    protected static final AllGuiTextures BG = AllGuiTextures.TOOLBOX;
    protected static final AllGuiTextures PLAYER = AllGuiTextures.PLAYER_INVENTORY;

    protected class_1735 hoveredToolboxSlot;
    private IconButton confirmButton;
    private IconButton disposeButton;
    private ElementWidget renderedItem;
    private ElementWidget renderedLid;
    private ElementWidget renderedTopDrawer;
    private ElementWidget renderedBottomDrawer;
    private ElementWidget renderedTopLeftDrawer;
    private ElementWidget renderedTopBottomDrawer;
    private class_1767 color;

    private List<class_768> extraAreas = Collections.emptyList();

    public ToolboxScreen(ToolboxMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        method_25426();
    }

    public static ToolboxScreen create(
        class_310 mc,
        MenuType<ToolboxBlockEntity> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        ToolboxBlockEntity entity = getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71402(), Create.LOGGER)) {
            class_11368 view = class_11352.method_71417(logging, extraData.method_56349(), extraData.method_10798());
            entity.readClient(view);
            return type.create(ToolboxScreen::new, syncId, inventory, title, entity);
        }
    }

    @Override
    protected void method_25426() {
        setWindowSize(30 + BG.getWidth(), BG.getHeight() + PLAYER.getHeight() - 24);
        setWindowOffset(-11, 0);
        super.method_25426();
        method_37067();

        color = field_2797.contentHolder.getColor();

        confirmButton = new IconButton(field_2776 + 30 + BG.getWidth() - 33, field_2800 + BG.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> {
            field_22787.field_1724.method_7346();
        });
        method_37063(confirmButton);

        disposeButton = new IconButton(field_2776 + 30 + 81, field_2800 + 69, AllIcons.I_TOOLBOX);
        disposeButton.withCallback(() -> {
            field_22787.field_1724.field_3944.method_52787(new ToolboxDisposeAllPacket(field_2797.contentHolder.method_11016()));
        });
        disposeButton.setToolTip(CreateLang.translateDirect("toolbox.depositBox"));
        method_37063(disposeButton);

        extraAreas = ImmutableList.of(new class_768(field_2776 + 30 + BG.getWidth(), field_2800 + BG.getHeight() - 15 - 34 - 6, 72, 68));

        int x1 = field_2776 + field_2792 - 1;
        int y1 = field_2800 + BG.getHeight() - 13;
        renderedTopDrawer = new ElementWidget(x1, y1).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125F)
            .transform(this::transformTopDrawer).atLocal(-0.2f, 0.4f));
        method_37063(renderedTopDrawer);
        renderedItem = new ElementWidget(
            field_2776 + field_2792 + 5,
            field_2800 + BG.getHeight() - 54
        ).showingElement(GuiGameElement.of(field_2797.contentHolder.method_11010().method_26204().method_9564()).scale(3.125F).rotate(-22, -202, 0)
            .padding(12));
        method_37063(renderedItem);
        renderedLid = new ElementWidget(
            field_2776 + field_2792 + 10,
            field_2800 + BG.getHeight() - 58
        ).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_LIDS.get(color)).scale(3.125F).transform(this::transformLid).padding(6));
        method_37063(renderedLid);
        renderedBottomDrawer = new ElementWidget(x1, field_2800 + BG.getHeight() - 7).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER)
            .scale(3.125F).transform(this::transformBottomDrawer).atLocal(-0.2f, 0.4f));
        method_37063(renderedBottomDrawer);
        renderedTopLeftDrawer = new ElementWidget(x1, y1).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125F)
            .transform(this::transformTopDrawer).atLocal(-0.2f, 0.4f)).withScissor(0, 0, 15, 50);
        method_37063(renderedTopLeftDrawer);
        renderedTopBottomDrawer = new ElementWidget(x1, y1).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125F)
            .transform(this::transformTopDrawer).atLocal(-0.2f, 0.4f)).withScissor(0, 6, 50, 44);
        method_37063(renderedTopBottomDrawer);
    }

    private void transformLid(class_4587 ms, float partialTicks) {
        ms.method_46416(0.796F, 1.408F, 0);
        TransformStack.of(ms).rotateXDegrees(-22).rotateYDegrees(-202).translate(0, -6 / 16f, 12 / 16f)
            .rotateXDegrees(-105 * field_2797.contentHolder.lid.getValue(partialTicks)).translate(0, 6 / 16f, -12 / 16f);
        ms.method_22905(1, -1, 1);
    }

    private void transformTopDrawer(class_4587 ms, float partialTicks) {
        ms.method_46416(1.02F, 0.384F, 0);
        TransformStack.of(ms).rotateXDegrees(-22).rotateYDegrees(-202).translate(0, 0, field_2797.contentHolder.drawers.getValue(partialTicks) * -.175f);
        ms.method_22905(1, -1, 1);
    }

    private void transformBottomDrawer(class_4587 ms, float partialTicks) {
        ms.method_46416(1.02F, 0.38F, 0);
        TransformStack.of(ms).rotateXDegrees(-22).rotateYDegrees(-202)
            .translate(0, 0, field_2797.contentHolder.drawers.getValue(partialTicks) * -.175f * 2);
        ms.method_22905(1, -1, 1);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
        renderedLid.getRenderElement().clear();
        renderedTopDrawer.getRenderElement().clear();
        renderedBottomDrawer.getRenderElement().clear();
        renderedTopLeftDrawer.getRenderElement().clear();
        renderedTopBottomDrawer.getRenderElement().clear();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        field_2797.renderPass = true;
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        field_2797.renderPass = false;
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        partialTicks = AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());
        int x = this.field_2776 + field_2792 - BG.getWidth();

        BG.render(graphics, x, field_2800);
        graphics.method_51439(field_22793, field_22785, x + 15, field_2800 + 4, 0xFF592424, false);

        int invX = this.field_2776;
        int invY = field_2800 + field_2779 - PLAYER.getHeight();
        renderPlayerInventory(graphics, invX, invY);

        ((GuiPartialRenderBuilder) renderedLid.getRenderElement()).tick(field_2797.contentHolder.lid.settled() ? 1 : partialTicks);
        float drawerTicks = field_2797.contentHolder.drawers.settled() ? 1 : partialTicks;
        ((GuiPartialRenderBuilder) renderedTopDrawer.getRenderElement()).tick(drawerTicks);
        ((GuiPartialRenderBuilder) renderedBottomDrawer.getRenderElement()).tick(drawerTicks);
        ((GuiPartialRenderBuilder) renderedTopLeftDrawer.getRenderElement()).tick(drawerTicks);
        ((GuiPartialRenderBuilder) renderedTopBottomDrawer.getRenderElement()).tick(drawerTicks);

        hoveredToolboxSlot = null;
        for (int compartment = 0; compartment < 8; compartment++) {
            int baseIndex = compartment * ToolboxInventory.STACKS_PER_COMPARTMENT;
            class_1735 slot = field_2797.field_7761.get(baseIndex);
            class_1799 itemstack = slot.method_7677();
            int i = slot.field_7873 + this.field_2776;
            int j = slot.field_7872 + field_2800;

            if (itemstack.method_7960())
                itemstack = field_2797.getFilter(compartment);

            if (method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) {
                hoveredToolboxSlot = slot;
                int slotColor = 0x80FFFFFF;
                graphics.method_25296(i, j, i + 16, j + 16, slotColor, slotColor);
            }

            if (!itemstack.method_7960()) {
                int count = field_2797.totalCountInCompartment(compartment);
                String s = String.valueOf(count);
                graphics.method_51423(field_22787.field_1724, itemstack, i, j, 0);
                graphics.method_51432(field_22793, itemstack, i, j, s);
            }
        }
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (hoveredToolboxSlot != null)
            field_2787 = hoveredToolboxSlot;
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
