package com.zurrtum.create.client.content.fluids.spout;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.content.fluids.spout.SpoutBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class SpoutRenderer implements class_827<SpoutBlockEntity, SpoutRenderer.SpoutRenderState> {
    public SpoutRenderer(class_5614.class_5615 context) {
    }

    @Override
    public SpoutRenderState method_74335() {
        return new SpoutRenderState();
    }

    @Override
    public void updateRenderState(
        SpoutBlockEntity be,
        SpoutRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float radius = 0;
        int processingTicks = be.processingTicks;
        float processingPT = processingTicks - tickProgress;
        if (!fluidStack.isEmpty()) {
            float level = primaryTank.getFluidLevel().getValue(tickProgress);
            if (level != 0) {
                boolean top = false;//TODO fluidStack.getFluid().getFluidType().isLighterThanAir();
                float min = 2.5f / 16f;
                float n = 11 / 16f;
                float max = min + n;
                float yOffset = n * Math.max(level, 0.175f);
                float yMin = min - yOffset;
                float offset = top ? max - min : yOffset;
                state.fluid = new FluidRenderState(
                    ShadersModHelper.isShaderPackInUse() ? class_1921.method_29380() : PonderRenderTypes.fluid(),
                    fluidStack.getFluid(),
                    fluidStack.getComponentChanges(),
                    min,
                    max,
                    yMin,
                    offset,
                    state.field_62676
                );
            }
            if (processingTicks != -1) {
                float processingProgress = 1 - (processingPT - 5) / 10;
                processingProgress = class_3532.method_15363(processingProgress, 0, 1);
                radius = (float) (Math.pow(((2 * processingProgress) - 1), 2) - 1);
                class_238 box = new class_238(0.5, 0.0, 0.5, 0.5, -1.2, 0.5).method_1014(radius / 32f);
                state.process = new ProcessRenderState(
                    PonderRenderTypes.fluid(),
                    fluidStack.getFluid(),
                    fluidStack.getComponentChanges(),
                    box,
                    state.field_62676
                );
            }
        }
        float squeeze;
        if (processingPT < 0) {
            squeeze = 0;
        } else if (processingPT < 2) {
            squeeze = class_3532.method_48781(processingPT / 2f, 0, -1);
        } else if (processingPT < 10) {
            squeeze = -1;
        } else {
            squeeze = radius;
        }
        SuperByteBuffer top = CachedBuffers.partial(AllPartialModels.SPOUT_TOP, state.field_62674);
        SuperByteBuffer middle = CachedBuffers.partial(AllPartialModels.SPOUT_MIDDLE, state.field_62674);
        SuperByteBuffer bottom = CachedBuffers.partial(AllPartialModels.SPOUT_BOTTOM, state.field_62674);
        float offset = -3 * squeeze / 32f;
        state.bits = new BitsRenderState(class_1921.method_23577(), top, middle, bottom, offset, state.field_62676);
    }

    @Override
    public void render(SpoutRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.process != null) {
            queue.method_73483(matrices, state.process.layer, state.process);
        }
        queue.method_73483(matrices, state.bits.layer, state.bits);
        if (state.fluid != null) {
            matrices.method_46416(0, state.fluid.offset, 0);
            queue.method_73483(matrices, state.fluid.layer, state.fluid);
        }
    }

    public static class SpoutRenderState extends class_11954 {
        public FluidRenderState fluid;
        public ProcessRenderState process;
        public BitsRenderState bits;
    }

    public record FluidRenderState(
        class_1921 layer, class_3611 fluid, class_9326 changes, float min, float max, float yMin, float offset, int light
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(fluid, changes, min, yMin, min, max, min, max, vertexConsumer, matricesEntry, light, false, true);
        }
    }

    public record ProcessRenderState(
        class_1921 layer, class_3611 fluid, class_9326 changes, class_238 box, int light
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(
                fluid,
                changes,
                (float) box.field_1323,
                (float) box.field_1322,
                (float) box.field_1321,
                (float) box.field_1320,
                (float) box.field_1325,
                (float) box.field_1324,
                vertexConsumer,
                matricesEntry,
                light,
                true,
                true
            );
        }
    }

    public record BitsRenderState(
        class_1921 layer, SuperByteBuffer top, SuperByteBuffer middle, SuperByteBuffer bottom, float offset, int light
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            top.light(light).renderInto(matricesEntry, vertexConsumer);
            matricesEntry.method_67796(0, offset, 0);
            middle.light(light).renderInto(matricesEntry, vertexConsumer);
            matricesEntry.method_67796(0, offset, 0);
            bottom.light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
