package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import static com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;
import static com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock.FACING;

public class DeployerMovementRenderBehaviour implements MovementRenderBehaviour {
    @Nullable
    @Override
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new DeployerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(
        class_243 camera,
        class_327 textRenderer,
        MovementContext context,
        VirtualRenderWorld renderWorld,
        Matrix4f worldMatrix4f
    ) {
        if (VisualizationManager.supportsVisualization(context.world)) {
            return null;
        }
        DeployerMovementRenderState state = new DeployerMovementRenderState(context.localPos);
        state.layer = class_1921.method_23577();
        class_2680 blockState = context.state;
        Mode mode = context.blockEntityData.method_67491("Mode", Mode.CODEC).orElse(Mode.PUNCH);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0;
        }
        state.shaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564());
        state.pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        state.hand = CachedBuffers.partial(handPose, blockState);
        double factor;
        if (context.contraption.stalled || context.position == null || context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374(AnimationTickHolder.getRenderTime() * .5f) * .25f + .25f;
        } else {
            class_243 center = VecHelper.getCenterOf(class_2338.method_49638(context.position));
            double distance = context.position.method_1022(center);
            double nextDistance = context.position.method_1019(context.motion).method_1022(center);
            factor = .5f - class_3532.method_15350(class_3532.method_16436(AnimationTickHolder.getPartialTicks(), distance, nextDistance), 0, 1);
        }
        class_2350 facing = blockState.method_11654(FACING);
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        if (context.state.method_26204() instanceof IRotate def) {
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime(context.world) / 20;
        state.angle = (time * speed) % 360;
        state.yRot = axis == class_2350.class_2351.field_11051 ? class_3532.field_29847 * 90 : 0;
        state.zRot = axis.method_10179() ? class_3532.field_29847 * 90 : 0;
        state.light = class_761.method_23794(renderWorld, context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        if (!context.disabled) {
            state.offset = class_243.method_24954(facing.method_62675()).method_1021(factor);
        }
        state.upAngle = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        state.eastAngle = class_3532.field_29847 * (facing == class_2350.field_11036 ? 270 : facing == class_2350.field_11033 ? 90 : 0);
        state.southAngle = class_3532.field_29847 * ((blockState.method_11654(AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051) ? 90 : 0);
        return state;
    }

    public static class DeployerMovementRenderState extends MovementRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer shaft;
        public SuperByteBuffer pole;
        public SuperByteBuffer hand;
        public float yRot;
        public float zRot;
        public float angle;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public class_243 offset;
        public float upAngle;
        public float eastAngle;
        public float southAngle;

        public DeployerMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, layer, this);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            shaft.center().rotateY(yRot).rotateZ(zRot).uncenter().rotateCentered(angle, class_2350.field_11036).light(light).useLevelLight(world, worldMatrix4f)
                .renderInto(matricesEntry, vertexConsumer);
            if (offset != null) {
                pole.translate(offset);
                hand.translate(offset);
            }
            pole.rotateCentered(upAngle, class_2350.field_11036).rotateCentered(eastAngle, class_2350.field_11034).rotateCentered(southAngle, class_2350.field_11035)
                .light(light).useLevelLight(world, worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            hand.rotateCentered(upAngle, class_2350.field_11036).rotateCentered(eastAngle, class_2350.field_11034).light(light).useLevelLight(world, worldMatrix4f)
                .renderInto(matricesEntry, vertexConsumer);
        }
    }
}
