package com.zurrtum.create.client.content.redstone.thresholdSwitch;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.ponder.AllCreatePonderTags;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity.ThresholdType;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureThresholdSwitchPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2459;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class ThresholdSwitchScreen extends AbstractSimiScreen {

    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private SelectionScrollInput inStacks;

    private IconButton confirmButton;
    private IconButton flipSignals;

    private final class_2561 invertSignal = CreateLang.translateDirect("gui.threshold_switch.invert_signal");
    private ElementWidget renderedItem;
    private ElementWidget torchPower;
    private ElementWidget torchOff;

    private AllGuiTextures background;
    private ThresholdSwitchBlockEntity blockEntity;
    private int lastModification;

    public ThresholdSwitchScreen(ThresholdSwitchBlockEntity be) {
        super(CreateLang.translateDirect("gui.threshold_switch.title"));
        background = AllGuiTextures.THRESHOLD_SWITCH;
        this.blockEntity = be;
        lastModification = -1;
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        setWindowOffset(-20, 0);
        super.method_25426();

        int x = guiLeft;
        int y = guiTop;

        inStacks = (SelectionScrollInput) new SelectionScrollInput(x + 100, y + 23, 52, 42).forOptions(List.of(
            CreateLang.translateDirect(
                "schedule.condition.threshold.items"), CreateLang.translateDirect("schedule.condition.threshold.stacks")
        )).titled(CreateLang.translateDirect("schedule.condition.threshold.item_measure")).setState(blockEntity.inStacks ? 1 : 0);

        offBelow = new ScrollInput(x + 48, y + 47, 1, 18).withRange(blockEntity.getMinLevel(), blockEntity.getMaxLevel() + 1 - getValueStep())
            .titled(CreateLang.translateDirect("gui.threshold_switch.lower_threshold")).calling(state -> {
                lastModification = 0;
                int valueStep = getValueStep();

                if (onAbove.getState() / valueStep == 0 && state / valueStep == 0)
                    return;

                if (onAbove.getState() / valueStep <= state / valueStep) {
                    onAbove.setState((state + valueStep) / valueStep * valueStep);
                    onAbove.onChanged();
                }
            }).withStepFunction(sc -> sc.shift ? 10 * getValueStep() : getValueStep()).setState(blockEntity.offWhenBelow);

        onAbove = new ScrollInput(x + 48, y + 23, 1, 18).withRange(blockEntity.getMinLevel() + getValueStep(), blockEntity.getMaxLevel() + 1)
            .titled(CreateLang.translateDirect("gui.threshold_switch.upper_threshold")).calling(state -> {
                lastModification = 0;
                int valueStep = getValueStep();

                if (offBelow.getState() / valueStep == 0 && state / valueStep == 0)
                    return;

                if (offBelow.getState() / valueStep >= state / valueStep) {
                    offBelow.setState((state - valueStep) / valueStep * valueStep);
                    offBelow.onChanged();
                }
            }).withStepFunction(sc -> sc.shift ? 10 * getValueStep() : getValueStep()).setState(blockEntity.onWhenAbove);

        onAbove.onChanged();
        offBelow.onChanged();

        method_37063(onAbove);
        method_37063(offBelow);
        method_37063(inStacks);

        confirmButton = new IconButton(x + background.getWidth() - 33, y + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::method_25419);
        method_37063(confirmButton);

        flipSignals = new IconButton(x + background.getWidth() - 62, y + background.getHeight() - 24, AllIcons.I_FLIP);
        flipSignals.withCallback(() -> send(!blockEntity.isInverted()));
        flipSignals.setToolTip(invertSignal);
        method_37063(flipSignals);

        renderedItem = new ElementWidget(
            x + background.getWidth() + 6,
            y + background.getHeight() - 56
        ).showingElement(GuiGameElement.of(AllItems.THRESHOLD_SWITCH.method_7854()).scale(5));
        method_37063(renderedItem);

        class_2680 torch = class_2246.field_10523.method_9564();
        torchPower = new ElementWidget(x + 22, y + 19).showingElement(GuiGameElement.of(torch).rotate(-22.5F, 45, 0).scale(1.25F));
        method_37063(torchPower);
        torchOff = new ElementWidget(x + 22, y + 43).showingElement(GuiGameElement.of(torch.method_11657(class_2459.field_11446, false)).rotate(-22.5F, 45, 0)
            .scale(1.25F));
        method_37063(torchOff);

        updateInputBoxes();
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
        torchPower.getRenderElement().clear();
        torchOff.getRenderElement().clear();
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        int itemX = guiLeft + 13;
        int itemY = guiTop + 80;
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.THRESHOLD_SWITCH_TARGETS));
            return true;
        }
        return super.method_25402(click, doubled);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);
        graphics.method_51439(field_22793, field_22785, x + background.getWidth() / 2 - field_22793.method_27525(field_22785) / 2, y + 4, 0xFF592424, false);

        ThresholdType typeOfCurrentTarget = blockEntity.getTypeOfCurrentTarget();
        boolean forItems = typeOfCurrentTarget == ThresholdType.ITEM;
        AllGuiTextures inputBg = forItems ? AllGuiTextures.THRESHOLD_SWITCH_ITEMCOUNT_INPUTS : AllGuiTextures.THRESHOLD_SWITCH_MISC_INPUTS;

        inputBg.render(graphics, x + 44, y + 21);
        inputBg.render(graphics, x + 44, y + 21 + 24);

        int valueStep = 1;
        boolean stacks = inStacks.getState() == 1;
        if (typeOfCurrentTarget == ThresholdType.FLUID)
            valueStep = BucketFluidInventory.CAPACITY;

        if (forItems) {
            class_2561 suffix = inStacks.getState() == 0 ? CreateLang.translateDirect("schedule.condition.threshold.items") : CreateLang.translateDirect(
                "schedule.condition.threshold.stacks");
            valueStep = inStacks.getState() == 0 ? 1 : 64;
            graphics.method_51439(field_22793, suffix, x + 105, y + 28, 0xFFFFFFFF, true);
            graphics.method_51439(field_22793, suffix, x + 105, y + 28 + 24, 0xFFFFFFFF, true);

        }

        graphics.method_51439(
            field_22793,
            class_2561.method_43470("≥ " + (typeOfCurrentTarget == ThresholdType.UNSUPPORTED ? "" : forItems ? onAbove.getState() / valueStep : format(
                blockEntity,
                onAbove.getState() / valueStep,
                stacks
            ).getString())),
            x + 53,
            y + 28,
            0xFFFFFFFF,
            true
        );
        graphics.method_51439(
            field_22793,
            class_2561.method_43470("≤ " + (typeOfCurrentTarget == ThresholdType.UNSUPPORTED ? "" : forItems ? offBelow.getState() / valueStep : format(
                blockEntity,
                offBelow.getState() / valueStep,
                stacks
            ).getString())),
            x + 53,
            y + 28 + 24,
            0xFFFFFFFF,
            true
        );

        int itemX = x + 13;
        int itemY = y + 80;

        class_1799 displayItem = blockEntity.getDisplayItemForScreen();
        graphics.method_51427(displayItem.method_7960() ? new class_1799(class_1802.field_8077) : displayItem, itemX, itemY);

        int torchX = x + 23;
        int torchY = y + 24;

        boolean highlightTopRow = blockEntity.isInverted() ^ blockEntity.isPowered();
        AllGuiTextures.THRESHOLD_SWITCH_CURRENT_STATE.render(graphics, torchX - 3, torchY - 4 + (highlightTopRow ? 0 : 24));
        if (blockEntity.isInverted()) {
            torchPower.method_46419(y + 43);
            torchOff.method_46419(y + 19);
        } else {
            torchPower.method_46419(y + 19);
            torchOff.method_46419(y + 43);
        }

        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            ArrayList<class_2561> list = new ArrayList<>();
            if (displayItem.method_7960()) {
                list.add(CreateLang.translateDirect("gui.threshold_switch.not_attached"));
                list.add(CreateLang.translateDirect("display_link.view_compatible").method_27692(class_124.field_1063));
                graphics.method_51434(field_22793, list, mouseX, mouseY);
                return;
            }

            list.add(displayItem.method_7964());
            if (typeOfCurrentTarget == ThresholdType.UNSUPPORTED) {
                list.add(CreateLang.translateDirect("gui.threshold_switch.incompatible").method_27692(class_124.field_1080));
                list.add(CreateLang.translateDirect("display_link.view_compatible").method_27692(class_124.field_1063));
                graphics.method_51434(field_22793, list, mouseX, mouseY);
                return;
            }

            CreateLang.translate("gui.threshold_switch.currently", format(blockEntity, blockEntity.currentLevel / valueStep, stacks))
                .style(class_124.field_1062).addTo(list);

            if (blockEntity.currentMinLevel / valueStep == 0)
                CreateLang.translate("gui.threshold_switch.range_max", format(blockEntity, blockEntity.currentMaxLevel / valueStep, stacks))
                    .style(class_124.field_1080).addTo(list);
            else
                CreateLang.translate(
                    "gui.threshold_switch.range",
                    blockEntity.currentMinLevel / valueStep,
                    format(blockEntity, blockEntity.currentMaxLevel / valueStep, stacks)
                ).style(class_124.field_1080).addTo(list);

            list.add(CreateLang.translateDirect("display_link.view_compatible").method_27692(class_124.field_1063));

            graphics.method_51434(field_22793, list, mouseX, mouseY);
            return;
        }

        for (boolean power : Iterate.trueAndFalse) {
            int thisTorchY = power ? torchY : torchY + 26;
            if (mouseX >= torchX && mouseX < torchX + 16 && mouseY >= thisTorchY && mouseY < thisTorchY + 16) {
                graphics.method_51434(
                    field_22793,
                    List.of(CreateLang.translate(power ^ blockEntity.isInverted() ? "gui.threshold_switch.power_on_when" : "gui.threshold_switch.power_off_when")
                        .color(AbstractSimiWidget.HEADER_RGB).component()),
                    mouseX,
                    mouseY
                );
                return;
            }
        }
    }

    public static class_5250 format(ThresholdSwitchBlockEntity be, int value, boolean stacks) {
        ThresholdType type = be.getTypeOfCurrentTarget();
        if (type == ThresholdType.CUSTOM)
            if (be.method_10997().method_8321(be.getTargetPos()) instanceof ThresholdSwitchObservable tso)
                return tso.format(value);

        String suffix = type == ThresholdType.ITEM ? stacks ? "schedule.condition.threshold.stacks" : "schedule.condition.threshold.items" : "schedule.condition.threshold.buckets";
        return CreateLang.text(value + " ").add(CreateLang.translate(suffix)).component();
    }

    @Override
    public void method_25393() {
        super.method_25393();

        if (lastModification >= 0)
            lastModification++;

        if (lastModification >= 20) {
            lastModification = -1;
            send(blockEntity.isInverted());
        }

        if (inStacks == null)
            return;

        updateInputBoxes();
    }

    private void updateInputBoxes() {
        ThresholdType typeOfCurrentTarget = blockEntity.getTypeOfCurrentTarget();
        boolean forItems = typeOfCurrentTarget == ThresholdType.ITEM;
        final int valueStep = getValueStep();
        inStacks.field_22763 = inStacks.field_22764 = forItems;
        onAbove.method_25358(forItems ? 48 : 103);
        offBelow.method_25358(forItems ? 48 : 103);

        onAbove.field_22764 = typeOfCurrentTarget != ThresholdType.UNSUPPORTED;
        offBelow.field_22764 = typeOfCurrentTarget != ThresholdType.UNSUPPORTED;

        int min = blockEntity.currentMinLevel + valueStep;
        int max = blockEntity.currentMaxLevel;
        onAbove.withRange(min, max + 1);
        int roundedState = class_3532.method_15340((onAbove.getState() / valueStep) * valueStep, min, max);
        if (roundedState != onAbove.getState()) {
            onAbove.setState(roundedState);
            onAbove.onChanged();
        }

        min = blockEntity.currentMinLevel;
        max = blockEntity.currentMaxLevel - valueStep;
        offBelow.withRange(min, max + 1);
        roundedState = class_3532.method_15340((offBelow.getState() / valueStep) * valueStep, min, max);
        if (roundedState != offBelow.getState()) {
            offBelow.setState(roundedState);
            offBelow.onChanged();
        }
    }

    private int getValueStep() {
        boolean stacks = inStacks.getState() == 1;
        int valueStep = 1;
        if (blockEntity.getTypeOfCurrentTarget() == ThresholdType.FLUID)
            valueStep = BucketFluidInventory.CAPACITY;
        else if (stacks)
            valueStep = 64;
        return valueStep;
    }

    @Override
    public void method_25432() {
        send(blockEntity.isInverted());
    }

    protected void send(boolean invert) {
        field_22787.field_1724.field_3944.method_52787(new ConfigureThresholdSwitchPacket(
            blockEntity.method_11016(),
            offBelow.getState(),
            onAbove.getState(),
            invert,
            inStacks.getState() == 1
        ));
    }

}
