package com.zurrtum.create.client.content.schematics.client.tools;

import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class FlipTool extends PlacementToolBase {

    private final AABBOutline outline = new AABBOutline(new class_238(class_2338.field_10980));

    @Override
    public void init() {
        super.init();
        renderSelectedFace = false;
    }

    @Override
    public boolean handleRightClick(class_310 mc) {
        mirror();
        return true;
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        mirror();
        return true;
    }

    @Override
    public void updateSelection(class_310 mc) {
        super.updateSelection(mc);
    }

    private void mirror() {
        if (schematicSelected && selectedFace.method_10166().method_10179()) {
            schematicHandler.getTransformation().flip(selectedFace.method_10166());
            schematicHandler.markDirty();
        }
    }

    @Override
    public void renderOnSchematic(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer) {
        if (!schematicSelected || !selectedFace.method_10166().method_10179()) {
            super.renderOnSchematic(mc, ms, buffer);
            return;
        }

        class_2350 facing = selectedFace.method_10170();
        class_238 bounds = schematicHandler.getBounds();

        class_243 directionVec = class_243.method_24954(class_2350.method_10156(class_2352.field_11056, facing.method_10166()).method_62675());
        class_243 boundsSize = new class_243(bounds.method_17939(), bounds.method_17940(), bounds.method_17941());
        class_243 vec = boundsSize.method_18806(directionVec);
        bounds = bounds.method_1002(vec.field_1352, vec.field_1351, vec.field_1350).method_1009(1 - directionVec.field_1352, 1 - directionVec.field_1351, 1 - directionVec.field_1350);
        bounds = bounds.method_997(directionVec.method_1021(.5f).method_18806(boundsSize));

        outline.setBounds(bounds);
        AllSpecialTextures tex = AllSpecialTextures.CHECKERED;
        outline.getParams().lineWidth(1 / 16f).disableLineNormals().colored(0xdddddd).withFaceTextures(tex, tex);
        outline.render(mc, ms, buffer, class_243.field_1353, AnimationTickHolder.getPartialTicks());

        super.renderOnSchematic(mc, ms, buffer);
    }

}
